/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main.update;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateNotificationDialog;
import com.floreantpos.main.update.UpdateNotificationHandler;
import com.floreantpos.main.update.UpdatePendingDialog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateService;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class UpdateManager {
    public static final String SOFTWARE_NUMERIC_VERSION = "software.numeric.version";
    public static final String HAS_UPDATE = "has_update";
    public static final String FORCE_UPDATE = "force_update";
    private JFrame a;

    public JFrame getParentWindow() {
        return this.a;
    }

    public void setParentWindow(JFrame jFrame) {
        this.a = jFrame;
    }

    public void checkForUpdate() {
        String string = Application.getInstance().getUpdateServerURL();
        String string2 = VersionInfo.getAppName();
        String string3 = VersionInfo.getVersion();
        int n = VersionInfo.getNumericVersion();
        UpdateService.checkForUpdate((Component)this.a, (UpdateListener)new UpdateNotificationHandler(false), (String)string, (String)string2, (String)string3, (int)n);
    }

    public boolean isUpdateAvailble() {
        String string = Application.getInstance().getUpdateServerURL();
        String string2 = VersionInfo.getAppName();
        String string3 = VersionInfo.getVersion();
        int n = VersionInfo.getNumericVersion();
        return UpdateService.isUpdateAvailable((Component)this.a, (UpdateListener)new UpdateNotificationHandler(false), (String)string, (String)string2, (String)string3, (int)n);
    }

    public void checkHasRemainingUpdates() {
        try {
            if (!AppConfig.getBoolean(HAS_UPDATE, false)) {
                return;
            }
            Information information = UpdateManager.a();
            if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
                OroMqttClient oroMqttClient = OroMqttClient.getInstance();
                oroMqttClient.initMqttClient(Application.getInstance().getMqttDeviceId());
                this.a(information, "MESSAGE", "Software update", "Software will automatically restart for an update in 30sec.");
                PosLog.debug(this.getClass(), "mqtt client started");
                UpdatePendingDialog updatePendingDialog = new UpdatePendingDialog();
                updatePendingDialog.open();
            }
            this.a(information);
            AppConfig.removeProperty(HAS_UPDATE);
            System.exit(0);
        }
        catch (Exception exception) {
            AppConfig.removeProperty(HAS_UPDATE);
            POSMessageDialog.showError(null, "Update failed: " + exception.getMessage(), exception);
            System.exit(1);
        }
    }

    private void a(Information information, String string, String string2, String string3) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("action", (Object)string);
        jSONObject.put("content", (Object)string2);
        jSONObject.put("msg", (Object)string3);
        jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
        jSONObject.put("terminalAppNumericVersion", information.getPkgrel());
        OroMqttClient.getInstance().publishData("auto-update-service", jSONObject.toString());
    }

    private static Information a() throws Exception {
        String string = System.getProperty("java.io.tmpdir") + "/" + UpdateManager.b() + "/update.xml";
        Information information = UpdateXMLParser.parse((String)string, (Modes)Modes.FILE);
        if (information != null) {
            return information;
        }
        throw new Exception("Failed to load update configuration file.");
    }

    private void a(Information information) throws Exception {
        UpdateManager.b(information);
        File file = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        String string = URLDecoder.decode(file.getPath(), "UTF-8");
        String string2 = string.replace(file.getName(), "auto-updater.jar");
        String string3 = VersionInfo.getAppName();
        ProcessBuilder processBuilder = new ProcessBuilder("java", "-cp", string2, "com.floreantpos.update.UpdateServiceWindow", string, string3);
        processBuilder.start();
    }

    private static void b(Information information) throws Exception {
        String string = System.getProperty("java.io.tmpdir") + "/" + UpdateManager.b() + "/" + information.getFilename();
        PosLog.info(UpdateManager.class, "Updating from " + string);
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (!string3.startsWith("lib") || !string3.contains("auto-updater")) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            File file = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!file.isFile()) {
                return;
            }
            file = file.getParentFile();
            String string4 = string2 = URLDecoder.decode(file.getPath(), "UTF-8");
            PosLog.info(UpdateManager.class, "decode parent path: " + string2);
            PosLog.info(UpdateManager.class, "auto updater destination: " + string4);
            File file2 = new File(string4, "auto-updater.jar");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            inputStream.close();
            fileOutputStream.close();
            PosLog.info(UpdateManager.class, "Successfully copied auto-updater.jar");
            break;
        }
        zipFile.close();
    }

    private static String b() {
        return VersionInfo.getAppName().replaceAll("\\W+", "_").toLowerCase();
    }

    public void publishIfNewUpdateAvailable() throws Exception {
        int n = AppConfig.getInt("last_app_version", VersionInfo.getNumericVersion());
        if (VersionInfo.getNumericVersion() > n) {
            Information information = UpdateManager.a();
            Store store = StoreDAO.getRestaurant();
            Integer n2 = store.getSoftwareNumericVersion();
            if (n2 < VersionInfo.getNumericVersion()) {
                store.setSoftwareVersion(VersionInfo.getVersion());
                store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
                StoreDAO.getInstance().update(store);
                DataProvider.get().refreshStore();
            }
            this.a(information, "UPDATE", "Software has been updated", "");
            AppConfig.removeProperty(HAS_UPDATE);
            AppConfig.removeProperty(FORCE_UPDATE);
            AppConfig.removeProperty("last_app_version");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    POSMessageDialog.showMessage(UpdateManager.this.a, "Software has been update to version " + VersionInfo.getVersion());
                }
            });
        }
    }

    private void c() {
        String string = UpdateManager.b();
        PosWindow posWindow = Application.getPosWindow();
        String string2 = Application.getInstance().getUpdateServerURL();
        UpdateService.startDownload((Component)posWindow, (UpdateListener)new UpdateNotificationHandler(), (String)string2, (String)string);
    }

    public void subscribeToUpdateService() throws Exception {
        OroMqttClient.getInstance().subscribeToStore("auto-update-service", 0, new IMqttMessageListener(){

            public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
                try {
                    int n;
                    PosLog.debug(this.getClass(), "Update message received");
                    String string2 = new String(mqttMessage.getPayload());
                    JSONObject jSONObject = new JSONObject(string2);
                    String string3 = jSONObject.getString("terminalKey");
                    PosLog.debug(this.getClass(), "Update notification from terminal " + string3);
                    if (string3.equals(TerminalUtil.getSystemUID())) {
                        return;
                    }
                    if (jSONObject.has("terminalAppNumericVersion") && (n = jSONObject.getInt("terminalAppNumericVersion")) <= VersionInfo.getNumericVersion()) {
                        return;
                    }
                    Action action = Action.valueOf(jSONObject.getString("action"));
                    Object object = jSONObject.get("content");
                    Object object2 = jSONObject.get("msg");
                    Toolkit.getDefaultToolkit().beep();
                    switch (action) {
                        case MESSAGE: {
                            PosLog.debug(this.getClass(), "going to show that software will be updated");
                            UpdateNotificationDialog.showMessage(object.toString(), object2.toString(), false);
                            break;
                        }
                        case UPDATE: {
                            if (String.valueOf(VersionInfo.getNumericVersion()).equals(StoreDAO.getRestaurant().getSoftwareVersion())) {
                                return;
                            }
                            UpdateNotificationDialog updateNotificationDialog = UpdateNotificationDialog.getInstance(object.toString(), object2.toString(), true);
                            updateNotificationDialog.setUpdateButtonVisible(false);
                            updateNotificationDialog.startUpdating();
                        }
                    }
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
            }
        });
    }

    private void a(Integer n, String string, Integer n2) {
        try {
            boolean bl;
            Integer n3 = VersionInfo.getNumericVersion();
            Integer n4 = 172;
            boolean bl2 = bl = n2 != null && n2 > n3;
            if (bl || n != null && n > n4) {
                String string2 = "Some other terminal is running updated version of the software.\nTo continue, you must update to version %s or later.\nDo you want to update now?.";
                string2 = String.format(string2, string);
                String string3 = null;
                string3 = TerminalConfig.isShowDbConfigureButton() ? POSMessageDialog.showOptionDialog(Application.getPosWindow(), string2, "Update required", "Yes", "Use different database", "No") : POSMessageDialog.showOptionDialog(Application.getPosWindow(), string2, "Update required", "Yes", "No");
                if (string3 == null || string3.equals("No")) {
                    POSMessageDialog.showError(Application.getPosWindow(), "System will now shutdown.");
                    System.exit(1);
                } else if (string3.equals("Yes")) {
                    this.c();
                } else {
                    DatabaseConfigurationDialog databaseConfigurationDialog = DatabaseConfigurationDialog.show(Application.getPosWindow());
                    if (databaseConfigurationDialog.isCanceled()) {
                        POSMessageDialog.showError(Application.getPosWindow(), "System will now shutdown.");
                        System.exit(1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performDatabaseUpgrade() throws Exception {
        String string;
        boolean bl;
        Database database = AppConfig.getDefaultDatabase();
        String string2 = AppConfig.getConnectString();
        String string3 = AppConfig.getDatabaseUser();
        String string4 = AppConfig.getDatabasePassword();
        String string5 = database.getHibernateConnectionDriverClass();
        Map<String, String> map = DatabaseUtil.getStoreProperties(string2, string5, string3, string4);
        String string6 = map.get("software.version");
        Integer n = null;
        Integer n2 = null;
        try {
            n = Integer.parseInt(map.get("database.version"));
            n2 = Integer.parseInt(map.get(SOFTWARE_NUMERIC_VERSION));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a(n, string6, n2);
        if (!DatabaseUtil.isDbUpdateNeeded(n)) {
            return;
        }
        String string7 = Messages.getString("DB_UPGRADE_REQUIRED");
        String string8 = Messages.getString("ALERT");
        int n3 = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string7, string8);
        if (n3 != 0) {
            return;
        }
        string7 = Messages.getString("DB_UPGRADE_ALERT_MESSAGE");
        n3 = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string7, string8);
        if (n3 != 0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SHUTDOWN_MESSAGE"));
            System.exit(1);
        }
        if (bl = DatabaseUtil.updateDatabase(string2, string = database.getHibernateDialect(), string5, string3, string4)) {
            JOptionPane.showMessageDialog(Application.getPosWindow(), Messages.getString("DB_UPGRADE_SUCCESS"));
            Main.restart();
        } else {
            JOptionPane.showMessageDialog(Application.getPosWindow(), Messages.getString("DatabaseConfigurationDialog.3"));
        }
    }

    static enum Action {
        MESSAGE,
        UPDATE;

    }
}

