/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.base.BaseCashBreakdown;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DataProvider;
import org.apache.commons.lang.StringUtils;

public class CashBreakdown
extends BaseCashBreakdown {
    private static final long serialVersionUID = 1L;

    public Currency getCurrency() {
        return DataProvider.get().getCurrency(this.getCurrencyId());
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            this.setCurrencyId(null);
        } else {
            this.setCurrencyId(currency.getId());
        }
    }

    public String getCurrencyName() {
        return this.getCurrency().getName();
    }

    public void setCurrencyName(String string) {
    }

    public CashDrawer getCashDrawer() {
        String string = this.getCashDrawerId();
        if (StringUtils.isNotEmpty((String)string)) {
            return CashDrawerDAO.getInstance().get(string);
        }
        return null;
    }

    public void setCashDrawer(CashDrawer cashDrawer) {
        if (cashDrawer != null) {
            this.setCashDrawerId(cashDrawer.getId());
        } else {
            this.setCashDrawerId(null);
        }
    }

    @Override
    public Double getBalance() {
        CashDrawer cashDrawer = this.getCashDrawer();
        return cashDrawer == null || cashDrawer.getReportTime() == null ? super.getBalance() : super.getTotalAmount();
    }
}

