/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseInventoryStock;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class InventoryStock
extends BaseInventoryStock {
    private static final long serialVersionUID = 1L;
    private double menuItemCost;
    private String locationName;
    private InventoryLocation inventoryLocation;

    public InventoryStock() {
    }

    public InventoryStock(String string) {
        super(string);
    }

    @Override
    public String getSku() {
        String string = super.getSku();
        return StringUtils.isNotEmpty((String)string) ? string : "";
    }

    public void setMenuItem(MenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        this.setMenuItemId(menuItem.getId());
        this.setItemName(menuItem.getName());
        this.setSku(menuItem.getSku());
    }

    public InventoryLocation getInventoryLocation() {
        String string = this.getLocationId();
        if (string == null) {
            return null;
        }
        if (this.inventoryLocation != null && this.inventoryLocation.getId().equals(string)) {
            return this.inventoryLocation;
        }
        return DataProvider.get().getInventoryLocationById(string);
    }

    public void setInventoryLocation(InventoryLocation inventoryLocation) {
        this.inventoryLocation = inventoryLocation;
    }

    public double getMenuItemCost() {
        return this.menuItemCost;
    }

    public void setMenuItemCost(double d) {
        this.menuItemCost = d;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String string) {
        this.locationName = string;
    }

    public MenuItem getMenuItem() {
        if (StringUtils.isEmpty((String)this.getMenuItemId())) {
            return null;
        }
        return (MenuItem)DataProvider.get().getObjectOf(MenuItem.class, (Serializable)((Object)this.getMenuItemId()));
    }
}

