/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.dao.ModifierGroupDAO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="menuItemModifierSpec")
@JsonIgnoreProperties(ignoreUnknown=true, value={"defaultModifiers", "modifiers"})
public class MenuItemModifierSpec
extends BaseMenuItemModifierSpec {
    private static final long serialVersionUID = 1L;
    private ModifierGroup modifierGroup;

    public MenuItemModifierSpec() {
    }

    public MenuItemModifierSpec(String string) {
        super(string);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menuitem_modifiergroup_" + this.toString() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @XmlTransient
    public Set<MenuModifier> getModifiers() {
        Set<MenuItemModifierPage> set = this.getModifierPages();
        HashSet<MenuModifier> hashSet = new HashSet<MenuModifier>();
        if (set != null) {
            for (MenuItemModifierPage menuItemModifierPage : set) {
                if (menuItemModifierPage.getPageItems() == null) continue;
                for (MenuItemModifierPageItem menuItemModifierPageItem : menuItemModifierPage.getPageItems()) {
                    MenuModifier menuModifier = menuItemModifierPageItem.getMenuModifier();
                    if (menuModifier == null) continue;
                    menuModifier.setPageItemId(menuItemModifierPageItem.getId());
                    hashSet.add(menuModifier);
                }
            }
        }
        return hashSet;
    }

    public boolean hasMenuItemModifierPageItem() {
        Set<MenuItemModifierPage> set = this.getModifierPages();
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (MenuItemModifierPage menuItemModifierPage : set) {
            List<MenuItemModifierPageItem> list = menuItemModifierPage.getPageItems();
            if (list == null && list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return super.getName();
    }

    @JsonIgnoreProperties
    public Set<MenuModifier> getDefaultModifiers() {
        HashSet<MenuModifier> hashSet = new HashSet<MenuModifier>();
        List<DefaultMenuModifier> list = super.getDefaultModifierList();
        if (list != null) {
            for (DefaultMenuModifier defaultMenuModifier : list) {
                hashSet.add(defaultMenuModifier.getModifier());
            }
        }
        return hashSet;
    }

    public ModifierGroup getModifierGroup() {
        if (this.modifierGroup != null) {
            return this.modifierGroup;
        }
        String string = super.getModifierGroupId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.modifierGroup = ModifierGroupDAO.getInstance().get(string);
        return this.modifierGroup;
    }

    public void setModifierGroup(ModifierGroup modifierGroup) {
        this.modifierGroup = modifierGroup;
        String string = null;
        if (modifierGroup != null) {
            string = modifierGroup.getId();
        }
        this.setModifierGroupId(string);
    }
}

