/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.IconFactory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.base.BaseMenuPageItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.awt.Color;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlTransient;

public class MenuPageItem
extends BaseMenuPageItem {
    private static final long serialVersionUID = 1L;
    private transient MenuItem menuItem;
    private transient ImageIcon image;
    private transient Color buttonColor;
    private transient Color textColor;
    private final String randomId = UUID.randomUUID().toString();

    public MenuPageItem() {
    }

    public MenuPageItem(String string) {
        super(string);
    }

    public MenuPageItem(Integer n, Integer n2) {
        super.setCol(n);
        super.setRow(n2);
    }

    public MenuPageItem(Integer n, Integer n2, MenuItem menuItem, MenuPage menuPage) {
        super.setCol(n);
        super.setRow(n2);
        this.setMenuItem(menuItem);
        this.setMenuPage(menuPage);
    }

    public void setMenuPage(MenuPage menuPage) {
        if (menuPage != null) {
            this.setMenuPageId(menuPage.getId());
        } else {
            this.setMenuPageId(null);
        }
    }

    public MenuItem getMenuItem() {
        if (this.menuItem == null && this.getMenuItemId() != null) {
            this.menuItem = MenuItemDAO.getInstance().get(this.getMenuItemId());
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        if (menuItem != null) {
            this.setMenuItemId(menuItem.getId());
            this.setMenuItemName(menuItem.getDisplayName());
            this.setButtonColorCode(menuItem.getButtonColorCode());
            this.setTextColorCode(menuItem.getTextColorCode());
            this.setImageId(menuItem.getImageId());
            this.setShowImageOnly(menuItem.isShowImageOnly());
        } else {
            this.setMenuItemId(null);
        }
    }

    public void setImage(ImageIcon imageIcon) {
        this.image = imageIcon;
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId(), 80, 80);
    }

    public ImageIcon getImage(int n, int n2) {
        return IconFactory.getIconFromImageResource(this.getImageId(), n - 20, n2 - 20);
    }

    public ImageIcon getScaledImageIcon(int n, int n2) {
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(this.getImageId());
        if (imageResource != null) {
            this.image = new ImageIcon(imageResource.getImage().getScaledInstance(n, n2, 1));
        }
        return this.image;
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public String getRandomId() {
        return this.randomId;
    }
}

