/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Address;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.base.BaseOutlet;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.Color;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"departments", "tableServingBGColor", "tableServingForeColor", "tableBookForeColor", "tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatForeColor", "tableSeatBGColor"})
@XmlRootElement
public class Outlet
extends BaseOutlet {
    private static final long serialVersionUID = 1L;

    public Outlet() {
    }

    public Outlet(String string) {
        super(string);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String string = null;
        if (taxGroup != null) {
            string = taxGroup.getId();
        }
        super.setTaxGroupId(string);
    }

    public Address getAddress() {
        if (StringUtils.isNotEmpty((String)this.getAddressId())) {
            return AddressDAO.getInstance().get(this.getAddressId());
        }
        return null;
    }

    public void setAddress(Address address) {
        String string = null;
        if (address != null) {
            string = address.getId();
        }
        super.setAddressId(string);
    }

    public Currency getCurrency() {
        return DataProvider.get().getCurrency(this.getCurrencyId());
    }

    public void setCurrency(Currency currency) {
        String string = null;
        if (currency != null) {
            string = currency.getId();
        }
        super.setCurrencyId(string);
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public String getProperty(String string) {
        Map<String, String> map = this.getProperties();
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperties().get(string);
        if (StringUtils.isEmpty((String)string3)) {
            string3 = string2;
        }
        return string3;
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperties().get(string);
        if (StringUtils.isEmpty((String)string2)) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public void addProperty(String string, String string2) {
        this.getProperties().put(string, string2);
    }

    public boolean isAllwMemberbasedPOI() {
        String string = this.getProperty("inventory.allowMemberPOI");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateOnHandBlncForSale() {
        String string = this.getProperty("inventory.updateOnHandBlnceForSale");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateAvlBlncForSale() {
        String string = this.getProperty("inventory.updateAvlBlnceForSale");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public boolean isAllwNegOnHandBlnce() {
        String string = this.getProperty("inventory.allowNegetiveOnHandBalance");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateAvlBlncForPOCreated() {
        String string = this.getProperty("inventory.updateAvailBalanceForPurchaseOrderCreated");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateOnHandBlncForPORec() {
        String string = this.getProperty("inventory.updateOnHandBalanceForPurchaseOrderReceived");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public String getImageId() {
        String string;
        String string2 = this.getProperty("logo.imageid");
        if (StringUtils.isEmpty((String)string2) && (string = this.getProperty("ticket.header.logo.imageid")) != null) {
            this.addProperty("logo.imageid", string);
            return string;
        }
        return string2;
    }

    public boolean isInventoryAvgPricingMethod() {
        String string = this.getProperty("inventory.pricing.method");
        if (string == null) {
            return false;
        }
        return string.equals("avg");
    }

    public static String getWebServiceUrl() {
        Store store = Application.getInstance().getStore();
        return store.getProperty("web.service.url") + "/service/data/store/" + store.getProperty("web.service.schema");
    }

    public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
        try {
            String string = this.getProperty("tips.receiver.delivery");
            if (StringUtils.isNotEmpty((String)string)) {
                return TipsReceivedBy.valueOf(string);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception exception) {
            throw new PosException("Tips received by configuration is wrong.");
        }
    }

    public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
        try {
            String string = this.getProperty("tips.receiver.nonDelivery");
            if (StringUtils.isNotEmpty((String)string)) {
                return TipsReceivedBy.valueOf(string);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception exception) {
            throw new PosException("Tips received by configuration is wrong.");
        }
    }

    public double getOvertimeMarkup() {
        try {
            String string = this.getProperty("overtime.markup");
            if (StringUtils.isNotEmpty((String)string)) {
                return Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public boolean hasCreateMemberPermission() {
        try {
            String string = this.getProperty("member.create.permission");
            if (StringUtils.isNotEmpty((String)string)) {
                return Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isAutoSyncCharges() {
        return this.getBooleanProperty("Charges.Automatically_Sync_Day", Boolean.FALSE);
    }

    public boolean isAllowPenyRounding() {
        try {
            String string = this.getProperty("store.peny.rounding");
            if (StringUtils.isNotEmpty((String)string)) {
                return Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getCustomerMonitorDisplayOption() {
        try {
            String string = this.getProperty("customer.monitor.display.option");
            if (StringUtils.isNotEmpty((String)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getCustomerMonitorDisplaySlideDuration() {
        try {
            String string = this.getProperty("customer.monitor.slide.duration");
            if (StringUtils.isNotEmpty((String)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    public String getServerUrl() {
        try {
            String string = this.getProperty("update_server_url");
            if (StringUtils.isNotEmpty((String)string)) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void setTablePrimaryFontSize(int n) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(n));
    }

    public int getTablePrimaryFontSize() {
        return this.getProperty("floorplan.primaryFontSize") == null ? 18 : Integer.valueOf(this.getProperty("floorplan.primaryFontSize"));
    }

    public void setTableSecondaryFontSize(int n) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(n));
    }

    public int getTableSecondaryFontSize() {
        return this.getProperty("floorplan.secondaryFontSize") == null ? 10 : Integer.valueOf(this.getProperty("floorplan.secondaryFontSize"));
    }

    public void setTableBtnWidth(int n) {
        this.addProperty("floorplan.btnWidth", String.valueOf(n));
    }

    public int getTableBtnWidth() {
        return this.getProperty("floorplan.btnWidth") == null ? 100 : Integer.valueOf(this.getProperty("floorplan.btnWidth"));
    }

    public void setTableBtnHeight(int n) {
        this.addProperty("floorplan.btnHeight", String.valueOf(n));
    }

    public int getTableBtnHeight() {
        return this.getProperty("floorplan.btnHeight") == null ? 80 : Integer.valueOf(this.getProperty("floorplan.btnHeight"));
    }

    public void setTableSeatForeColor(Color color) {
        this.addProperty("floorplan.seatForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.seatForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.seatForeColor")));
    }

    public void setTableSeatBGColor(Color color) {
        this.addProperty("floorplan.seatBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.seatBGColor")) ? Color.ORANGE : new Color(Integer.parseInt(this.getProperty("floorplan.seatBGColor")));
    }

    public void setTableServingForeColor(Color color) {
        this.addProperty("floorplan.servingForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.servingForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.servingForeColor")));
    }

    public void setTableServingBGColor(Color color) {
        this.addProperty("floorplan.servingBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.servingBGColor")) ? new Color(255, 102, 102) : new Color(Integer.parseInt(this.getProperty("floorplan.servingBGColor")));
    }

    public void setTableBookForeColor(Color color) {
        this.addProperty("floorplan.bookForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.bookForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.bookForeColor")));
    }

    public void setTableBookBGColor(Color color) {
        this.addProperty("floorplan.bookBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.bookBGColor")) ? Color.YELLOW : new Color(Integer.parseInt(this.getProperty("floorplan.bookBGColor")));
    }

    public void setTableFreeForeColor(Color color) {
        this.addProperty("floorplan.freeForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.freeForeColor")) ? Color.black : new Color(Integer.parseInt(this.getProperty("floorplan.freeForeColor")));
    }

    public void setTableFreeBGColor(Color color) {
        this.addProperty("floorplan.freeBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.freeBGColor")) ? Color.white : new Color(Integer.parseInt(this.getProperty("floorplan.freeBGColor")));
    }

    public boolean isShowTableNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableName", "false"));
    }

    public boolean isShowTableNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableNumber", "true"));
    }

    public boolean isShowServerNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showServerName", "true"));
    }

    public boolean isShowTokenNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTokenName", "true"));
    }

    public void setShowTableNameOnTable(boolean bl) {
        this.addProperty("floorplan.showTableName", String.valueOf(bl));
    }

    public void setShowTableNumberOnTable(boolean bl) {
        this.addProperty("floorplan.showTableNumber", String.valueOf(bl));
    }

    public void setShowServerNameOnTable(boolean bl) {
        this.addProperty("floorplan.showServerName", String.valueOf(bl));
    }

    public void setShowTokenNumberOnTable(boolean bl) {
        this.addProperty("floorplan.showTokenName", String.valueOf(bl));
    }
}

