/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseShopTableStatus;
import com.floreantpos.model.base.BaseShopTableTicket;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ShopTableStatus
extends BaseShopTableStatus {
    private static final long serialVersionUID = 1L;

    public ShopTableStatus() {
    }

    public ShopTableStatus(Integer n) {
        super(n);
    }

    public TableStatus getTableStatus() {
        Integer n = super.getTableStatusNum();
        return TableStatus.get(n);
    }

    public void setTableStatus(TableStatus tableStatus) {
        super.setTableStatusNum(tableStatus.getValue());
    }

    public List<ShopTableTicket> getTicketNumbers() {
        String string = this.getTicketInformations();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Gson gson = new Gson();
        List list = (List)gson.fromJson(string, new TypeToken<List<ShopTableTicket>>(){}.getType());
        return list;
    }

    public void setTicketNumbers(List<ShopTableTicket> list) {
        if (list == null || list.size() == 0) {
            this.setTicketInformations(null);
            return;
        }
        JsonArray jsonArray = new JsonArray();
        for (ShopTableTicket shopTableTicket : list) {
            jsonArray.add(shopTableTicket.toJson());
        }
        this.setTicketInformations(jsonArray.toString());
    }

    public String getTicketId() {
        List<String> list = this.getListOfTicketNumbers();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getListOfTicketNumbers() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (ShopTableTicket shopTableTicket : list) {
                arrayList.add(shopTableTicket.getTicketId());
            }
        }
        return arrayList;
    }

    public boolean hasMultipleTickets() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        return list != null && list.size() > 0;
    }

    public void setTicketId(String string) {
        this.setTableTicket(string, null, null, null);
    }

    public void setTableTicket(String string, Integer n, String string2, String string3) {
        if (string == null) {
            this.setTableStatus(TableStatus.Available);
            this.setTicketNumbers(null);
        } else {
            BaseShopTableTicket baseShopTableTicket = null;
            List<ShopTableTicket> list = this.getTicketNumbers();
            if (list != null && !list.isEmpty()) {
                for (ShopTableTicket shopTableTicket : list) {
                    if (!shopTableTicket.getTicketId().equals(string)) continue;
                    baseShopTableTicket = shopTableTicket;
                }
            } else {
                list = new ArrayList<ShopTableTicket>();
            }
            if (baseShopTableTicket == null) {
                baseShopTableTicket = new ShopTableTicket();
                list.add((ShopTableTicket)baseShopTableTicket);
            }
            baseShopTableTicket.setTicketId(string);
            baseShopTableTicket.setTokenNo(n);
            baseShopTableTicket.setUserId(string2);
            baseShopTableTicket.setUserName(string3);
            this.setTicketNumbers(list);
        }
    }

    public void addToTableTickets(List<Ticket> list) {
        Object object;
        if (list == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ShopTableTicket> list2 = this.getTicketNumbers();
        if (list2 == null) {
            list2 = new ArrayList<ShopTableTicket>();
        }
        for (ShopTableTicket comparable : list2) {
            object = comparable.getTicketId();
            if (object == null) continue;
            arrayList.add((String)object);
        }
        for (Ticket ticket : list) {
            if (arrayList.contains(ticket.getId())) continue;
            object = new ShopTableTicket();
            ((BaseShopTableTicket)object).setTicketId(ticket.getId());
            ((BaseShopTableTicket)object).setTokenNo(ticket.getTokenNo());
            ((BaseShopTableTicket)object).setUserId(ticket.getOwner().getId());
            ((BaseShopTableTicket)object).setUserName(ticket.getOwner().getFirstName());
            list2.add((ShopTableTicket)object);
        }
        this.setTicketNumbers(list2);
    }

    public String getUserId() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).getUserId();
    }

    public String getUserName() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        if (list == null || list.isEmpty()) {
            return "";
        }
        int n = list.size();
        if (n > 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopTableTicket shopTableTicket : list) {
                if (arrayList.contains(shopTableTicket.getUserId())) continue;
                arrayList.add(shopTableTicket.getUserId());
            }
            if (arrayList.size() > 1) {
                return "Multi owner";
            }
        }
        return list.get(0).getUserName();
    }

    public String getTokenNo() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        if (list == null || list.isEmpty()) {
            return "";
        }
        int n = list.size();
        if (n == 1) {
            return String.valueOf(list.get(0).getTokenNo());
        }
        String string = "";
        int n2 = 1;
        Iterator<ShopTableTicket> iterator = list.iterator();
        while (iterator.hasNext()) {
            ShopTableTicket shopTableTicket = iterator.next();
            string = string + String.valueOf(shopTableTicket.getTokenNo());
            if (n2 == 4) break;
            ++n2;
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }
}

