/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Tax;
import com.floreantpos.model.base.BaseTaxGroup;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={""})
@XmlRootElement
public class TaxGroup
extends BaseTaxGroup {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;

    public TaxGroup() {
    }

    public TaxGroup(String string) {
        super(string);
    }

    public TaxGroup(String string, String string2) {
        super(string, string2);
    }

    @Override
    public String toString() {
        String string = super.getName();
        List<Tax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return string;
        }
        string = string + " (";
        Iterator<Tax> iterator = list.iterator();
        while (iterator.hasNext()) {
            Tax tax = iterator.next();
            string = string + tax.getName() + ":" + tax.getRate();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public String getUniqueId() {
        return ("taxgroup_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string)) {
            return this.propertiesContainer.get(string).getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

