/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.Color;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="terminal")
public class Terminal
extends BaseTerminal {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_MOBILE = 1;

    public Terminal() {
    }

    public Terminal(Integer n) {
        super(n);
    }

    public User getAssignedUser() {
        return DataProvider.get().getUserById(this.getAssignedUserId());
    }

    public void setAssignedUser(User user) {
        this.setAssignedUserId(user == null ? null : user.getId());
    }

    public Outlet getOutlet() {
        if (this.getOutletId() == null) {
            return null;
        }
        return OutletDAO.getInstance().get(this.getOutletId());
    }

    public void setOutlet(Outlet outlet) {
        this.setOutletId(outlet == null ? null : outlet.getId());
    }

    public Department getDepartment() {
        if (this.getDepartmentId() == null) {
            return null;
        }
        return DepartmentDAO.getInstance().get(this.getDepartmentId());
    }

    public void setDepartment(Department department) {
        this.setDepartmentId(department == null ? null : department.getId());
    }

    public SalesArea getSalesArea() {
        if (this.getSalesAreaId() == null) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
    }

    public void setSalesArea(SalesArea salesArea) {
        this.setSalesAreaId(salesArea == null ? null : salesArea.getId());
    }

    public TerminalType getTerminalType() {
        return DataProvider.get().getTerminalType(this.getTerminalTypeId());
    }

    public void setTerminalType(TerminalType terminalType) {
        this.setTerminalTypeId(terminalType == null ? null : terminalType.getId());
    }

    public boolean isCashDrawerAssigned() {
        return this.getAssignedUser() != null;
    }

    public String getProperty(String string) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(string);
    }

    public String getProperty(String string, String string2) {
        if (this.getProperties() == null) {
            return string2;
        }
        String string3 = this.getProperties().get(string);
        if (StringUtils.isEmpty((String)string3)) {
            return string2;
        }
        return string3;
    }

    public void addProperty(String string, String string2) {
        this.getProperties().put(string, string2);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isShowTableNumber() {
        return this.getProperty("floorplan.showTableNumber") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showTableNumber"));
    }

    public boolean isShowServerName() {
        return this.getProperty("floorplan.showServerName") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showServerName"));
    }

    public boolean isShowTokenNum() {
        return this.getProperty("floorplan.showTokenName") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showTokenName"));
    }

    public boolean isAutoPrintReceipt() {
        return Boolean.valueOf(this.getProperty("auto_print_receipt", "false"));
    }

    public void setAutoPrintReceipt(boolean bl) {
        this.addProperty("auto_print_receipt", String.valueOf(bl));
    }

    public void setPrimaryFontSize(int n) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(n));
    }

    public int getPrimaryFontSize() {
        return this.getProperty("floorplan.primaryFontSize") == null ? 12 : Integer.valueOf(this.getProperty("floorplan.primaryFontSize"));
    }

    public void setSecondaryFontSize(int n) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(n));
    }

    public int getSecondaryFontSize() {
        return this.getProperty("floorplan.secondaryFontSize") == null ? 2 : Integer.valueOf(this.getProperty("floorplan.secondaryFontSize"));
    }

    public void setBtnWidth(int n) {
        this.addProperty("floorplan.btnWidth", String.valueOf(n));
    }

    public int getBtnWidth() {
        return this.getProperty("floorplan.btnWidth") == null ? 40 : Integer.valueOf(this.getProperty("floorplan.btnWidth"));
    }

    public void setBtnHeight(int n) {
        this.addProperty("floorplan.btnHeight", String.valueOf(n));
    }

    public int getBtnHeight() {
        return this.getProperty("floorplan.btnHeight") == null ? 40 : Integer.valueOf(this.getProperty("floorplan.btnHeight"));
    }

    public void setSeatForeColor(Color color) {
        this.addProperty("floorplan.seatForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getSeatForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.seatForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.seatForeColor")));
    }

    public void setSeatBGColor(Color color) {
        this.addProperty("floorplan.seatBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getSeatBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.seatBGColor")) ? Color.ORANGE : new Color(Integer.parseInt(this.getProperty("floorplan.seatBGColor")));
    }

    public void setServingForeColor(Color color) {
        this.addProperty("floorplan.servingForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getServingForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.servingForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.servingForeColor")));
    }

    public void setServingBGColor(Color color) {
        this.addProperty("floorplan.servingBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getServingBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.servingBGColor")) ? new Color(255, 102, 102) : new Color(Integer.parseInt(this.getProperty("floorplan.servingBGColor")));
    }

    public void setBookForeColor(Color color) {
        this.addProperty("floorplan.bookForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getBookForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.bookForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.bookForeColor")));
    }

    public void setBookBGColor(Color color) {
        this.addProperty("floorplan.bookBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getBookBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.bookBGColor")) ? Color.YELLOW : new Color(Integer.parseInt(this.getProperty("floorplan.bookBGColor")));
    }

    public void setFreeForeColor(Color color) {
        this.addProperty("floorplan.freeForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getFreeForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.freeForeColor")) ? Color.black : new Color(Integer.parseInt(this.getProperty("floorplan.freeForeColor")));
    }

    public void setFreeBGColor(Color color) {
        this.addProperty("floorplan.freeBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getFreeBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.freeBGColor")) ? Color.white : new Color(Integer.parseInt(this.getProperty("floorplan.freeBGColor")));
    }

    public boolean isShowTableName() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableName", "false"));
    }
}

