/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.BaseCashDrawerDAO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class CashDrawerDAO
extends BaseCashDrawerDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findReports(Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession, Boolean bl) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            if (bl != null) {
                criteria.add(bl != false ? Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME) : Restrictions.isNotNull((String)CashDrawer.PROP_REPORT_TIME));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCashDrawerIds(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)CashDrawer.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer loadFullCashDrawer(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            CashDrawer cashDrawer = (CashDrawer)session.get(this.getReferenceClass(), (Serializable)((Object)string));
            Hibernate.initialize(cashDrawer.getTransactions());
            CashDrawer cashDrawer2 = cashDrawer;
            return cashDrawer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer loadFullCashDrawer(CashDrawer cashDrawer) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)cashDrawer);
            Hibernate.initialize(cashDrawer.getTransactions());
            CashDrawer cashDrawer2 = cashDrawer;
            return cashDrawer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumOfOpeningBalance(StoreSession storeSession) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
            Double d = (Double)criteria.uniqueResult();
            if (d == null) {
                double d2 = 0.0;
                return d2;
            }
            double d3 = d;
            return d3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByUnSyncStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)CashDrawer.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)CashDrawer.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateCashDrawerSync(List<String> list) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update CashDrawer set %s=:synced where %s in" + string2;
            string3 = String.format(string3, CashDrawer.PROP_CLOUD_SYNCED, CashDrawer.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)true);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string);
        }
    }

    public void saveOrUpdateCashDrawer(List<CashDrawer> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CashDrawer cashDrawer : list) {
                CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
                CashDrawer cashDrawer2 = cashDrawerDAO.get(cashDrawer.getId());
                String string = cashDrawer.getAssignedUserId();
                if (cashDrawer2 != null) {
                    String string2 = cashDrawer2.getId();
                    long l = cashDrawer2.getVersion();
                    PropertyUtils.copyProperties((Object)cashDrawer2, (Object)cashDrawer);
                    cashDrawer2.setId(string2);
                    cashDrawer2.setVersion(l);
                    cashDrawer2.setAssignedUserId(string);
                    this.update(cashDrawer2, session);
                    continue;
                }
                cashDrawer.setVersion(0L);
                this.save(cashDrawer, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

