/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.BaseGiftCardDAO;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class GiftCardDAO
extends BaseGiftCardDAO {
    public void saveAsList(List<GiftCard> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (GiftCard giftCard : list) {
                String string = giftCard.getCardNumber();
                if (string == null) continue;
                string = string.replaceAll("-", "");
                giftCard.setCardNumber(string);
                GiftCard giftCard2 = (GiftCard)session.get(GiftCard.class, (Serializable)((Object)string));
                if (giftCard2 == null) {
                    session.save((Object)giftCard);
                    continue;
                }
                session.update((Object)giftCard);
            }
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard findByCardNumber(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_CARD_NUMBER, (Object)string));
                if (criteria.list().isEmpty()) {
                    GiftCard giftCard = null;
                    return giftCard;
                }
                GiftCard giftCard = (GiftCard)criteria.list().get(0);
                return giftCard;
            }
            GiftCard giftCard = null;
            return giftCard;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByCardAndIssueDate(String string, String string2, Date date, Date date2, String string3, PaginationSupport paginationSupport) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            if (date != null && date2 != null) {
                criteria.add(Restrictions.between((String)GiftCard.PROP_ISSUE_DATE, (Object)date, (Object)date2));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)GiftCard.PROP_CARD_NUMBER, (String)string, (MatchMode)MatchMode.START));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string2));
            }
            if (string3.equalsIgnoreCase("ACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true));
            } else if (string3.equalsIgnoreCase("DEACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false));
            } else if (string3.equalsIgnoreCase("DISABLED")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)true));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)GiftCard.PROP_ISSUE_DATE));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Date> findByDate() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)GiftCard.PROP_ISSUE_DATE)));
            if (criteria.list().isEmpty()) {
                List<Date> list = null;
                return list;
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCard> findExceptDisable() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            if (!criteria.list().isEmpty()) {
                List list = criteria.list();
                return list;
            }
            List<GiftCard> list = null;
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard initialize(GiftCard giftCard) {
        if (giftCard == null) {
            return giftCard;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)giftCard);
            GiftCard giftCard2 = giftCard;
            return giftCard2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findActiveCardByBatchNumber(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false), (Criterion)Restrictions.isNotNull((String)GiftCard.PROP_ACTIVATION_DATE))));
                if (criteria.list().isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCardListByBatchNumber(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List list = null;
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
                list = criteria.list();
                if (list != null) {
                    for (GiftCard giftCard : list) {
                        this.delete(giftCard);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCard> findByBatchNumber(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
            if (!criteria.list().isEmpty()) {
                List list = criteria.list();
                return list;
            }
            List<GiftCard> list = null;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBatchNo(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
            criteria.setMaxResults(1);
            boolean bl = criteria.list().size() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCard> findGiftCards(Date date, Date date2, boolean bl, String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add(Restrictions.between((String)GiftCard.PROP_ACTIVATION_DATE, (Object)date, (Object)date2));
            if (bl) {
                criteria.add((Criterion)Restrictions.lt((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            }
            if ("Owner".equals(string)) {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_OWNER_NAME));
            } else {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_ACTIVATION_DATE));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

