/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuGroupDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;

public class MenuGroupDAO
extends BaseMenuGroupDAO {
    @Override
    public Serializable save(Object object, Session session) throws HibernateException {
        Serializable serializable = super.save(object, session);
        this.updateDependentModels((MenuGroup)object, session);
        return serializable;
    }

    @Override
    public void update(Object object, Session session) throws HibernateException {
        super.update(object, session);
        this.updateDependentModels((MenuGroup)object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) throws HibernateException {
        super.saveOrUpdate(object, session);
        this.updateDependentModels((MenuGroup)object, session);
    }

    private void updateDependentModels(MenuGroup menuGroup, Session session) {
        String string = "update MenuItem set %s=:groupName, %s=:categoryId, %s=:categoryName, %s=:beverage where %s=:groupId";
        string = String.format(string, MenuItem.PROP_MENU_GROUP_NAME, MenuItem.PROP_MENU_CATEGORY_ID, MenuItem.PROP_MENU_CATEGORY_NAME, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(string);
        query.setParameter("groupName", (Object)menuGroup.getName());
        query.setParameter("categoryId", (Object)menuGroup.getMenuCategoryId());
        query.setParameter("categoryName", (Object)menuGroup.getMenuCategoryName());
        query.setParameter("beverage", (Object)menuGroup.isBeverage());
        query.setParameter("groupId", (Object)menuGroup.getId());
        query.executeUpdate();
        session.saveOrUpdate((Object)menuGroup);
    }

    public void initialize(MenuGroup menuGroup) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuGroup);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadActiveGroups(MenuCategory menuCategory, PaginatedListModel paginatedListModel) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedListModel.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            List list = criteria.list();
            paginatedListModel.setData(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuGroup> loadActiveGroupsByOrderType(OrderType orderType) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            List<MenuCategory> list = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuCategory menuCategory : list) {
                arrayList.add(menuCategory.getId());
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_MENU_CATEGORY_ID, arrayList));
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuGroup> findEnabledByParent(MenuCategory menuCategory) throws PosException {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findEnabledGroupsIdsByParent(MenuCategory menuCategory) throws PosException {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)MenuGroup.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuGroup> findByParent(MenuCategory menuCategory) throws PosException {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean hasChildren(Terminal terminal, MenuGroup menuGroup, OrderType orderType) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number.intValue() > 0;
            return bl;
        }
    }

    public void releaseParent(List<MenuGroup> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuGroup menuGroup : list) {
                menuGroup.setMenuCategoryId(null);
                session.saveOrUpdate((Object)menuGroup);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseParentAndDelete(MenuGroup menuGroup) {
        if (menuGroup == null) {
            return;
        }
        this.initialize(menuGroup);
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            String string = "delete from MENUGROUP_DISCOUNT where MENUGROUP_ID='%s'";
            string = String.format(string, menuGroup.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            String string2 = "update MENU_ITEM set GROUP_ID=null where GROUP_ID='%s'";
            string2 = String.format(string2, menuGroup.getId());
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            session.delete((Object)menuGroup);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsMenuGroups(MenuCategory menuCategory) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuGroups(PaginationSupport paginationSupport, String string, MenuCategory menuCategory, String ... stringArray) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuGroup.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME));
            if (stringArray != null && stringArray.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String string2 : stringArray) {
                    projectionList.add((Projection)Projections.property((String)string2), string2);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuGroup.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuGroup> findGroupsWithInventoryItems() throws PosException {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_MENU_GROUP_ID));
            List list = criteria.list();
            criteria = session.createCriteria(MenuGroup.class);
            criteria.add(Restrictions.in((String)MenuGroup.PROP_ID, (Collection)list));
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuGroup findMenuGroupByName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuGroup menuGroup = (MenuGroup)list.get(0);
                return menuGroup;
            }
            MenuGroup menuGroup = null;
            return menuGroup;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuGroup> findAllUnSyncMenuGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateMenuGroupSync(List<String> list, boolean bl) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update MenuGroup set %s=:synced where %s in" + string2;
            string3 = String.format(string3, MenuGroup.PROP_CLOUD_SYNCED, MenuGroup.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)bl);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string);
        }
    }

    public void saveOrUpdateMenuGroups(List<MenuGroup> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuGroup menuGroup : list) {
                MenuGroup menuGroup2 = this.get(menuGroup.getId());
                if (menuGroup2 != null) {
                    String string = menuGroup2.getId();
                    long l = menuGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)menuGroup2, (Object)menuGroup);
                    menuGroup2.setId(string);
                    menuGroup2.setVersion(l);
                    this.update(menuGroup2, session);
                    continue;
                }
                this.save(menuGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

