/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.BaseStockCountDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StockCountDAO
extends BaseStockCountDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdate(StockCount stockCount, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(stockCount, bl, session);
            transaction.commit();
        }
    }

    public void saveOrUpdate(StockCount stockCount, boolean bl, Session session) {
        if (stockCount.getId() == null) {
            stockCount.setCreatedDate(new Date());
        }
        stockCount.setLastModifiedDate(new Date());
        if (bl) {
            this.adjustInventoryItems(session, stockCount);
        }
        session.saveOrUpdate((Object)stockCount);
    }

    private void adjustInventoryItems(Session session, StockCount stockCount) {
        List<StockCountItem> list = stockCount.getCountItems();
        if (list == null) {
            return;
        }
        for (StockCountItem stockCountItem : list) {
            if (stockCountItem.isAdjusted().booleanValue()) continue;
            stockCountItem.setAdjusted(Boolean.TRUE);
            Double d = stockCountItem.getActualUnit() - stockCountItem.getUnitOnHand();
            if (d == 0.0) continue;
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            MenuItem menuItem = MenuItemDAO.getInstance().get(stockCountItem.getItemId(), session);
            Hibernate.initialize(menuItem.getStockUnits());
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setQuantity(Math.abs(d));
            inventoryTransaction.setUnit(stockCountItem.getUnit());
            double d2 = menuItem.getBaseUnitQuantity(stockCountItem.getUnit());
            inventoryTransaction.setUnitCost(d2 * menuItem.getCost());
            inventoryTransaction.setTotal(d2 * inventoryTransaction.getQuantity() * menuItem.getCost());
            inventoryTransaction.setTransactionDate(new Date());
            String string = stockCountItem.getReason();
            if (StringUtils.isEmpty((CharSequence)string)) {
                String string2 = d > 0.0 ? "ADJUST_IN" : "ADJUST_OUT";
                inventoryTransaction.setReason(string2);
            } else {
                inventoryTransaction.setReason(string);
            }
            if (d > 0.0) {
                inventoryTransaction.setType(InventoryTransactionType.IN.getType());
                inventoryTransaction.setToInventoryLocation(stockCountItem.getInventoryLocation());
            } else {
                inventoryTransaction.setType(InventoryTransactionType.OUT.getType());
                inventoryTransaction.setFromInventoryLocation(stockCountItem.getInventoryLocation());
            }
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextStockCountSequenceNumber() {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)StockCount.PROP_REF_NUMBER));
            Object object = criteria.uniqueResult();
            if (object == null) {
                String string = "10001";
                return string;
            }
            String string = String.valueOf(Integer.parseInt((String)object) + 1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBy(String string, Date date, Date date2, Boolean bl) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                criteria.add(Restrictions.ilike((String)StockCount.PROP_REF_NUMBER, (Object)string));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)StockCount.PROP_CREATED_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)StockCount.PROP_CREATED_DATE, (Object)date2));
            }
            if (!bl.booleanValue()) {
                criteria.add(Restrictions.isNull((String)StockCount.PROP_VERIFIED_BY));
            }
            List list = criteria.list();
            return list;
        }
    }
}

