/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.BaseStoreSessionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.swing.PaginationSupport;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionDAO
extends BaseStoreSessionDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStoreSession(PaginationSupport paginationSupport) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(StoreSession.class);
            criteria.addOrder(Order.asc((String)StoreSession.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)date2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME), (Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)date2))));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Outlet outlet, Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)date2)));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            List list = criteria.list();
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)date), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)date2)));
            List list2 = criteria.list();
            if (!list2.isEmpty()) {
                for (StoreSession storeSession : list2) {
                    if (list.contains(storeSession)) continue;
                    list.add(storeSession);
                }
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreSession findOpenSession(Outlet outlet) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            List list = criteria.list();
            if (list != null) {
                StoreSession storeSession = (StoreSession)list.get(0);
                return storeSession;
            }
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getStoreSessionTotalGuest(StoreSession storeSession) {
        Session session;
        block5: {
            List<String> list;
            block4: {
                Integer n;
                session = null;
                try {
                    list = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                    if (list != null && !list.isEmpty()) break block4;
                    n = 0;
                }
                catch (Throwable throwable) {
                    this.closeSession(session);
                    throw throwable;
                }
                this.closeSession(session);
                return n;
            }
            session = this.getSession();
            Criteria criteria = session.createCriteria(PosTransaction.class, "t");
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, list));
            criteria.setProjection((Projection)Projections.sum((String)"ticket.numberOfGuests"));
            Long l = (Long)criteria.uniqueResult();
            if (l == null) break block5;
            Integer n = l.intValue();
            this.closeSession(session);
            return n;
        }
        Integer n = 0;
        this.closeSession(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> getTransactionsByOutlet(Date date, Date date2, Outlet outlet, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, date, date2, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, date, date2, outlet);
            if (pagination != null) {
                object = (Number)criteria.uniqueResult();
                pagination.setNumRows(((Number)object).intValue());
            }
            object = list;
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, Date date, Date date2, Outlet outlet) {
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)date2));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void saveOrUpdateStoreSessions(List<StoreSession> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (StoreSession storeSession : list) {
                StoreSession storeSession2 = this.get(storeSession.getId());
                String string = storeSession.getClosedByUserId();
                if (storeSession2 != null) {
                    String string2 = storeSession2.getId();
                    long l = storeSession2.getVersion();
                    PropertyUtils.copyProperties((Object)storeSession2, (Object)storeSession);
                    if (string != null) {
                        storeSession2.setClosedByUserId(string);
                    }
                    storeSession2.setId(string2);
                    storeSession2.setVersion(l);
                    this.update(storeSession2, session);
                    continue;
                }
                this.save(storeSession, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

