/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.BaseTaxGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class TaxGroupDAO
extends BaseTaxGroupDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(TaxGroup taxGroup, String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)TaxGroup.PROP_NAME, (Object)string).ignoreCase());
            if (taxGroup.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)TaxGroup.PROP_ID, (Object)taxGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxGroup> findAllUnSyncTaxGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)TaxGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)TaxGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaxGroupSync(List<String> list, boolean bl) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update Tax set %s=:synced where %s in" + string2;
            string3 = String.format(string3, Tax.PROP_CLOUD_SYNCED, Tax.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)bl);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        finally {
            this.closeSession((Session)string);
        }
    }

    public void saveOrUpdateTaxGroups(List<TaxGroup> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (TaxGroup taxGroup : list) {
                ArrayList<Tax> arrayList = new ArrayList<Tax>();
                if (taxGroup.getTaxes() != null) {
                    for (Tax tax : taxGroup.getTaxes()) {
                        Tax tax2 = TaxDAO.getInstance().get(tax.getId());
                        if (arrayList == null) continue;
                        arrayList.add(tax2);
                    }
                }
                taxGroup.setTaxes(arrayList);
                TaxGroup taxGroup2 = this.get(taxGroup.getId());
                if (taxGroup2 != null) {
                    String string = taxGroup2.getId();
                    long l = taxGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)taxGroup2, (Object)taxGroup);
                    taxGroup2.setId(string);
                    taxGroup2.setVersion(l);
                    this.update(taxGroup2, session);
                    continue;
                }
                this.save(taxGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

