/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseTerminalDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TerminalDAO
extends BaseTerminalDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDrawerAssigned(Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)terminal.getId()));
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ASSIGNED_USER_ID));
            Object object = criteria.uniqueResult();
            boolean bl = object != null;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Integer createNewTerminalId() {
        Session session = null;
        try {
            session = this.getSession();
            Integer n = this.createNewTerminalId(session);
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Integer createNewTerminalId(Session session) {
        Integer n;
        Criteria criteria;
        Object object;
        Random random = new Random();
        do {
            n = random.nextInt(10000) + 1;
            criteria = session.createCriteria(this.getClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)n));
        } while ((object = criteria.uniqueResult()) != null);
        return n;
    }

    public Terminal createNewTerminal(String string, Integer n, Outlet outlet) {
        return this.createNewTerminal(string, n, outlet, null);
    }

    public Terminal createNewTerminal(String string, Integer n, Outlet outlet, Session session) {
        if (n == null || n == -1) {
            n = this.createNewTerminalId();
        }
        Terminal terminal = new Terminal();
        terminal.setId(n);
        terminal.setTerminalKey(string);
        terminal.setName(String.valueOf("Terminal " + n));
        if (outlet != null) {
            terminal.setOutletId(outlet.getId());
        }
        if (session == null) {
            this.save(terminal);
        } else {
            this.save(terminal, session);
        }
        return terminal;
    }

    public void refresh(Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            session.refresh((Object)terminal);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findOpenTerminals() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNotNull((String)Terminal.PROP_ASSIGNED_USER_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findCashDrawerTerminals() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_HAS_CASH_DRAWER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void performBatchSave(Object ... objectArray) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Object object : objectArray) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void performBatchSave(List<String> list, Object ... objectArray) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Object object : objectArray) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            if (list != null) {
                for (String string : list) {
                    Query query = session.createQuery(string);
                    query.executeUpdate();
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetCashDrawer(CashDrawer cashDrawer, Terminal terminal, User user, double d) throws Exception {
        Session session = null;
        Transaction transaction = null;
        cashDrawer.setClosedBy(user);
        cashDrawer.setReportTime(new Date());
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            terminal.setAssignedUserId(null);
            terminal.setCurrentCashDrawer(null);
            this.update(terminal, session);
            this.saveOrUpdate(cashDrawer, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetStaffBank(User user, CashDrawer cashDrawer) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.resetStaffBank(user, cashDrawer, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetStaffBank(User user, CashDrawer cashDrawer, Session session) throws Exception {
        User user2;
        cashDrawer.setClosedBy(user);
        cashDrawer.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer, session);
        String string = cashDrawer.getAssignedUserId();
        if (StringUtils.isNotEmpty((String)string) && (user2 = UserDAO.getInstance().get(string)) != null) {
            user2.setStaffBankStarted(false);
            user2.setCurrentCashDrawer(null);
            UserDAO.getInstance().update(user2, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal initialize(Terminal terminal) {
        if (terminal == null || terminal.getId() == null) {
            return terminal;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)terminal);
            Terminal terminal2 = terminal;
            return terminal2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal getByTerminalKey(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Terminal terminal = this.getByTerminalKey(string, session);
            return terminal;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Terminal getByTerminalKey(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)string));
        List list = criteria.list();
        if (list.size() > 0) {
            return (Terminal)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal findByAssignedUser(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ASSIGNED_USER_ID, (Object)user.getId()));
            List list = criteria.list();
            if (list.size() > 0) {
                Terminal terminal = (Terminal)list.get(0);
                return terminal;
            }
            Terminal terminal = null;
            return terminal;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVersionEqual(Class clazz, Object object, long l) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)object));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            Object object2 = criteria.uniqueResult();
            if (object2 instanceof Number) {
                boolean bl = ((Number)object2).longValue() == l;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVersion(Class clazz, String string, Object object) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)string, (Object)object));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            long l = (Long)criteria.uniqueResult();
            return l;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSqlQuery(List<String> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (String string : list) {
                SQLQuery sQLQuery = session.createSQLQuery(string);
                sQLQuery.executeUpdate();
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List executeSqlQuery(String string) {
        return this.executeSqlQuery(string, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeSqlQuery(String string, long l, long l2) {
        Session session = null;
        try {
            session = this.createNewSession();
            SQLQuery sQLQuery = session.createSQLQuery(string);
            if (l2 > 0L) {
                sQLQuery.setFirstResult((int)l);
                sQLQuery.setMaxResults((int)l2);
            }
            List list = sQLQuery.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findTerminalsByDeviceType(int n, int n2) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_DEVICE_TYPE, (Object)n));
            if (n2 > 0) {
                criteria.setMaxResults(n2);
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findDataList(Class clazz, Date date) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)date)));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastUpdateTime(Class clazz) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            criteria.setProjection((Projection)Projections.max((String)"lastUpdateTime"));
            criteria.add((Criterion)Restrictions.eq((String)"cloudSynced", (Object)false));
            criteria.setMaxResults(1);
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
        catch (QueryException queryException) {
            PosLog.debug(this.getClass(), queryException.getMessage());
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }
}

