/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.posserver;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.posserver.Check;
import com.floreantpos.posserver.Checks;
import com.floreantpos.posserver.POSDefaultInfo;
import com.floreantpos.posserver.POSRequest;
import com.floreantpos.posserver.POSResponse;
import com.floreantpos.posserver.PrintText;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import java.io.DataOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jfree.util.Log;
import org.xml.sax.InputSource;

public class PosRequestHandler
extends Thread {
    private Socket a;

    public PosRequestHandler(Socket socket) throws Exception {
        this.a = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                byte[] byArray = new byte[3000];
                this.a.getInputStream().read(byArray);
                String string = new String(byArray).trim();
                if (string.length() <= 0) {
                    break;
                }
                PosLog.info(this.getClass(), "Request From Terminal==>[" + string + "]");
                int n = string.indexOf("<");
                string = string.substring(n);
                POSRequest pOSRequest = this.a(string);
                POSResponse pOSResponse = this.a(pOSRequest);
                String string2 = this.a(pOSResponse);
                PosLog.info(this.getClass(), "Reponse to Terminal===>[" + string2 + "]");
                DataOutputStream dataOutputStream = new DataOutputStream(this.a.getOutputStream());
                byte[] byArray2 = string2.getBytes();
                dataOutputStream.write(byArray2, 0, byArray2.length);
                dataOutputStream.flush();
            }
        }
        catch (Exception exception) {
            Log.debug((Object)("Error:" + exception));
        }
        finally {
            try {
                Thread.sleep(5000L);
                this.a.close();
            }
            catch (Exception exception) {
                Log.debug((Object)("Error:" + exception));
            }
        }
    }

    private POSRequest a(String string) throws Exception {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(string));
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{POSRequest.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        return (POSRequest)unmarshaller.unmarshal(inputSource);
    }

    private POSResponse a(POSRequest pOSRequest) {
        POSResponse pOSResponse = new POSResponse();
        return pOSResponse;
    }

    private String a(POSResponse pOSResponse) throws Exception {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{POSResponse.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)pOSResponse, (Writer)stringWriter);
        String string = "";
        string = stringWriter.toString();
        string = string.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"\\?>", "");
        String string2 = String.format("%05d", string.length());
        string = string2 + string;
        return string;
    }

    private POSResponse b(POSRequest pOSRequest) {
        POSResponse pOSResponse = new POSResponse();
        User user = UserDAO.getInstance().findUserBySecretKey(pOSRequest.b.a);
        List<Ticket> list = TicketDAO.getInstance().findOpenTicketsForUser(user);
        Checks checks = new Checks();
        checks.setCheckList(new ArrayList<Check>());
        for (Ticket ticket : list) {
            List<Integer> list2 = ticket.getTableNumbers();
            if (list2 == null || list2.size() <= 0) continue;
            Check check = new Check();
            String string = list2.get(0).toString();
            if (list2.get(0) < 10) {
                string = "0" + list2.get(0).toString();
            }
            check.setTableNo(string);
            check.setTableName("");
            check.setChkName(String.valueOf(ticket.getId()));
            check.setChkNo(String.valueOf(ticket.getId()));
            check.setAmt(String.valueOf(Math.round((ticket.getDueAmount() - ticket.getTaxAmount()) * 100.0)));
            check.setTax(String.valueOf(Math.round(ticket.getTaxAmount() * 100.0)));
            checks.getCheckList().add(check);
        }
        pOSResponse.setChecks(checks);
        POSDefaultInfo pOSDefaultInfo = new POSDefaultInfo();
        pOSDefaultInfo.setServer(pOSRequest.b.a);
        pOSDefaultInfo.setTable(pOSRequest.b.b);
        pOSDefaultInfo.setCheck(pOSRequest.b.d);
        pOSDefaultInfo.setRes("1");
        pOSDefaultInfo.setrText(Messages.getString("PosRequestHandler.0"));
        pOSResponse.setPosDefaultInfo(pOSDefaultInfo);
        return pOSResponse;
    }

    private POSResponse c(POSRequest pOSRequest) {
        POSResponse pOSResponse = new POSResponse();
        User user = UserDAO.getInstance().findUserBySecretKey(pOSRequest.b.a);
        List<Ticket> list = TicketDAO.getInstance().findOpenTicketsForUser(user);
        Checks checks = new Checks();
        checks.setCheckList(new ArrayList<Check>());
        for (Ticket ticket : list) {
            List<Integer> list2 = ticket.getTableNumbers();
            if (list2 == null || list2.size() <= 0 || !list2.contains(Integer.parseInt(pOSRequest.b.b))) continue;
            Check check = new Check();
            String string = list2.get(0).toString();
            if (list2.get(0) < 10) {
                string = "0" + list2.get(0).toString();
            }
            check.setTableNo(String.valueOf(string));
            check.setTableName("");
            check.setChkName("");
            check.setChkNo(String.valueOf(ticket.getId()));
            check.setAmt(String.valueOf(Math.round((ticket.getDueAmount() - ticket.getTaxAmount()) * 100.0)));
            check.setTax(String.valueOf(Math.round(ticket.getTaxAmount() * 100.0)));
            checks.getCheckList().add(check);
            break;
        }
        pOSResponse.setChecks(checks);
        POSDefaultInfo pOSDefaultInfo = new POSDefaultInfo();
        pOSDefaultInfo.setServer(pOSRequest.b.a);
        pOSDefaultInfo.setTable(pOSRequest.b.b);
        pOSDefaultInfo.setCheck(pOSRequest.b.d);
        pOSDefaultInfo.setRes("1");
        pOSDefaultInfo.setrText(Messages.getString("PosRequestHandler.0"));
        pOSResponse.setPosDefaultInfo(pOSDefaultInfo);
        return pOSResponse;
    }

    private POSResponse d(POSRequest pOSRequest) {
        POSResponse pOSResponse = new POSResponse();
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(pOSRequest.b.d);
        String string = pOSRequest.c.e;
        PosTransaction posTransaction = null;
        if (string.equals("8")) {
            posTransaction = PaymentType.CASH.createTransaction();
            posTransaction.setCaptured(true);
        } else {
            if (string.equals(PaymentType.CREDIT_CARD.name())) {
                posTransaction = PaymentType.CREDIT_CARD.createTransaction();
            } else if (string.equals(PaymentType.GIFT_CERTIFICATE.name())) {
                posTransaction = PaymentType.GIFT_CERTIFICATE.createTransaction();
            }
            posTransaction.setCaptured(false);
            posTransaction.setCardNumber(pOSRequest.c.f);
            String string2 = pOSRequest.c.g;
            if (string2 != null) {
                posTransaction.setCardExpMonth(string2.substring(0, 2));
                posTransaction.setCardExpYear(string2.substring(2, 4));
            }
        }
        double d = Double.parseDouble(pOSRequest.c.a) / 100.0;
        posTransaction.setTenderAmount(d);
        posTransaction.setTicket(ticket);
        if (d >= ticket.getDueAmount()) {
            posTransaction.setAmount(ticket.getDueAmount());
        } else {
            posTransaction.setAmount(d);
        }
        PosTransactionService posTransactionService = PosTransactionService.getInstance();
        try {
            double d2 = ticket.getDueAmount();
            posTransactionService.settleTicket(ticket, posTransaction, Application.getCurrentUser());
            SettleTicketProcessor.printTicket(ticket, posTransaction);
            SettleTicketProcessor.showTransactionCompleteMsg(d2, d, ticket, posTransaction);
            if (SettleTicketProcessor.waitDialog.isVisible()) {
                SettleTicketProcessor.waitDialog.setCanceled(false);
                SettleTicketProcessor.waitDialog.dispose();
                RootView.getInstance().showDefaultView();
            }
            POSDefaultInfo pOSDefaultInfo = new POSDefaultInfo();
            pOSDefaultInfo.setServer(pOSRequest.b.a);
            pOSDefaultInfo.setTable(pOSRequest.b.b);
            pOSDefaultInfo.setCheck(pOSRequest.b.d);
            pOSDefaultInfo.setRes("1");
            pOSDefaultInfo.setrText(Messages.getString("PosRequestHandler.0"));
            pOSResponse.setPosDefaultInfo(pOSDefaultInfo);
            return pOSResponse;
        }
        catch (Exception exception) {
            Log.debug((Object)(Messages.getString("PosRequestHandler.24") + exception));
            return pOSResponse;
        }
    }

    private POSResponse e(POSRequest pOSRequest) {
        POSResponse pOSResponse = new POSResponse();
        POSDefaultInfo pOSDefaultInfo = new POSDefaultInfo();
        pOSDefaultInfo.setServer(pOSRequest.b.a);
        pOSDefaultInfo.setTable(pOSRequest.b.b);
        pOSDefaultInfo.setCheck(pOSRequest.b.d);
        List<PrintText> list = this.b(pOSRequest.b.d);
        pOSResponse.setPrintChecks(list);
        pOSResponse.setPosDefaultInfo(pOSDefaultInfo);
        return pOSResponse;
    }

    private List<PrintText> b(String string) {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(string);
        ArrayList<PrintText> arrayList = new ArrayList<PrintText>();
        Store store = Application.getInstance().getStore();
        Terminal terminal = Application.getInstance().getTerminal();
        arrayList.add(new PrintText(store.getName(), "center"));
        arrayList.add(new PrintText(store.getAddressLine1(), "center"));
        arrayList.add(new PrintText(store.getTelephone(), "center"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.25"), "center"));
        String string2 = "__________________________________";
        arrayList.add(new PrintText(string2, "center"));
        arrayList.add(new PrintText("*" + ticket.getOrderType() + "*", "center"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.29") + ticket.getTerminal().getId()));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.30") + ticket.getId()));
        if (terminal.isShowTableNumber()) {
            arrayList.add(new PrintText(Messages.getString("PosRequestHandler.31") + ticket.getTableNumbers()));
        } else {
            arrayList.add(new PrintText(Messages.getString("PosRequestHandler.31") + ticket.getTableNames()));
        }
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.32") + ticket.getNumberOfGuests()));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.33") + ticket.getOwner().getFirstName()));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.34") + new Date()));
        arrayList.add(new PrintText(string2, "center"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.35"), "right"));
        arrayList.add(new PrintText(string2, "center"));
        if (ticket.getTicketItems() != null) {
            List<TicketItem> list = ticket.getTicketItems();
            for (TicketItem ticketItem : list) {
                arrayList.add(new PrintText(ticketItem.getName() + "   " + ticketItem.getQuantity() + "    " + ticketItem.getUnitPriceDisplay(), "right"));
            }
        }
        arrayList.add(new PrintText(string2, "center"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.38") + ticket.getSubtotalAmount(), "right"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.39") + ticket.getTaxAmount(), "right"));
        arrayList.add(new PrintText(string2, "center"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.40") + ticket.getTotalAmountWithTips(), "right"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.41") + ticket.getPaidAmount(), "right"));
        arrayList.add(new PrintText(Messages.getString("PosRequestHandler.42") + ticket.getDueAmount(), "right"));
        return arrayList;
    }
}

