/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportTableModel;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.util.NumberUtil;
import java.awt.print.PrinterAbortException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosPrintService {
    private static final SimpleDateFormat a = new SimpleDateFormat("dd MMM, yyyy hh:mm aaa");
    private static Log b = LogFactory.getLog(PosPrintService.class);

    public static void printDrawerPullReport(CashDrawer cashDrawer) {
        try {
            JasperPrint jasperPrint = PosPrintService.populateDrawerPullReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterAbortException printerAbortException) {
        }
        catch (Exception exception) {
            PosLog.error(PosPrintService.class, exception);
        }
    }

    public static void printCashDrawerSummaryReport(CashDrawer cashDrawer) {
        try {
            JasperPrint jasperPrint = PosPrintService.populateStoreSessionSummaryReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterAbortException printerAbortException) {
        }
        catch (Exception exception) {
            PosLog.error(PosPrintService.class, exception);
        }
    }

    public static void printReportByJasperPrint(JasperPrint jasperPrint) {
        try {
            List<Printer> list = DataProvider.get().getPrinters().getReportPrinters();
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (StringUtils.isEmpty((CharSequence)string)) continue;
                jasperPrint.setProperty("printerName", string);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception exception) {
            PosLog.error(PosPrintService.class, exception);
        }
    }

    public static void printServerTipsReport(TipsCashoutReport tipsCashoutReport) {
        try {
            JasperPrint jasperPrint = PosPrintService.createServerTipsReport(tipsCashoutReport);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(PosPrintService.class, exception);
            b.error((Object)"error print tips report", (Throwable)exception);
        }
    }

    public static JasperPrint createServerTipsReport(TipsCashoutReport tipsCashoutReport) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("server", tipsCashoutReport.getServer());
        if (tipsCashoutReport.getFromDate() != null) {
            hashMap.put("fromDate", Application.formatDate(tipsCashoutReport.getFromDate()));
        }
        if (tipsCashoutReport.getToDate() != null) {
            hashMap.put("toDate", Application.formatDate(tipsCashoutReport.getToDate()));
        }
        hashMap.put("reportDate", new SimpleDateFormat("dd MMM yyyy, hh:mm aaa").format(tipsCashoutReport.getReportTime()));
        hashMap.put("transactionCount", tipsCashoutReport.getDatas() == null ? "0" : "" + tipsCashoutReport.getDatas().size());
        hashMap.put("cashTips", NumberUtil.formatNumber(tipsCashoutReport.getCashTipsAmount()));
        hashMap.put("chargedTips", NumberUtil.formatNumber(tipsCashoutReport.getChargedTipsAmount()));
        hashMap.put("declaredTips", tipsCashoutReport.getDeclaredTipsAmount());
        hashMap.put("tipsDue", tipsCashoutReport.getTipsDue());
        Store store = StoreDAO.getRestaurant();
        hashMap.put("headerLine1", store.getName());
        JasperReport jasperReport = ReportUtil.getReport("ServerTipsReport");
        JRTableModelDataSource jRTableModelDataSource = new JRTableModelDataSource((TableModel)new TipsCashoutReportTableModel(tipsCashoutReport.getDatas(), new String[]{"ticketId", "saleType", "ticketTotal", "tips", "chargedTips", "tipsPaid"}));
        return JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)jRTableModelDataSource);
    }

    public static JasperPrint populateDrawerPullReportParameters(CashDrawer cashDrawer) throws Exception {
        String string;
        boolean bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", bl ? "Staff bank report" : "Cash drawer report");
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            string = user.getFullName();
            hashMap.put("user", (bl ? "Staff: " : Messages.getString("PosPrintService.4") + " ") + string);
        }
        if (cashDrawer.getStartTime() != null) {
            hashMap.put("startTime", "Started: " + a.format(cashDrawer.getStartTime()));
        }
        hashMap.put("date", "Report Time: " + a.format(new Date()));
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        string = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", string);
        hashMap.put("subreportParameter", jasperReport);
        JasperReport jasperReport2 = ReportUtil.getReport("terminal_status_report");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("DrawerPullReport" + cashDrawer.getId());
        return jasperPrint;
    }

    public static JasperPrint populateStoreSessionSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", "End of day sales report");
        hashMap.put("IS_IGNORE_PAGINATION", true);
        hashMap.put("startTime", "Opening time: " + a.format(cashDrawer.getStartTime()));
        hashMap.put("user", "Opened by: " + cashDrawer.getAssignedBy());
        if (cashDrawer.getReportTime() != null) {
            hashMap.put("date", "Closing time: " + a.format(cashDrawer.getReportTime()));
            hashMap.put("reportUser", "Closed by: " + cashDrawer.getClosedBy());
        }
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport jasperReport = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport2 = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", jasperReport);
        hashMap.put("subreportParameter", jasperReport2);
        JasperReport jasperReport3 = ReportUtil.getReport("store-session-summary-report");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("StoreSessionSummaryReport");
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer) throws Exception {
        boolean bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Store store = StoreDAO.getRestaurant();
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", bl ? "Staff bank report" : "Cash drawer report");
        JasperPrint jasperPrint = PosPrintService.populateTerminalStatusReport(cashDrawer, bl, hashMap);
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer, boolean bl, HashMap hashMap) throws JRException {
        String string;
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            string = user.getFullName();
            hashMap.put("user", (bl ? "Staff: " : Messages.getString("PosPrintService.4") + " ") + string);
        }
        if (cashDrawer.getStartTime() != null) {
            hashMap.put("startTime", "Started: " + a.format(cashDrawer.getStartTime()));
        }
        hashMap.put("date", "Report Time: " + a.format(new Date()));
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        string = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", string);
        hashMap.put("subreportParameter", jasperReport);
        JasperReport jasperReport2 = ReportUtil.getReport("terminal_status_report");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, (Map)hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("TerminalStatusReport" + cashDrawer.getTerminalId());
        return jasperPrint;
    }

    public static CashDrawer populateCashDrawerReportSummary(List<CashDrawer> list) {
        CashDrawer cashDrawer = new CashDrawer();
        HashMap<String, CashBreakdown> hashMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (CashDrawer cashDrawer2 : list) {
                Object object;
                if (cashDrawer2.getReportTime() == null) {
                    try {
                        object = new CashDrawerReportService(cashDrawer2);
                        ((CashDrawerReportService)object).populateReport();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                arrayList.add(cashDrawer2.getId());
                cashDrawer.setBeginCash(cashDrawer.getBeginCash() + cashDrawer2.getBeginCash());
                cashDrawer.setNetSales(cashDrawer.getNetSales() + cashDrawer2.getNetSales());
                cashDrawer.setSalesTax(cashDrawer.getSalesTax() + cashDrawer2.getSalesTax());
                cashDrawer.setSalesDeliveryCharge(cashDrawer.getSalesDeliveryCharge() + cashDrawer2.getSalesDeliveryCharge());
                cashDrawer.setChargedTips(cashDrawer.getChargedTips() + cashDrawer2.getChargedTips());
                cashDrawer.setTotalVoid(cashDrawer.getTotalVoid() + cashDrawer2.getTotalVoid());
                cashDrawer.setTotalVoidWst(cashDrawer.getTotalVoidWst() + cashDrawer2.getTotalVoidWst());
                cashDrawer.setTipsPaid(cashDrawer.getTipsPaid() + cashDrawer2.getTipsPaid());
                cashDrawer.setTotalDiscountCount(cashDrawer.getTotalDiscountCount() + cashDrawer2.getTotalDiscountCount());
                cashDrawer.setTotalDiscountAmount(cashDrawer.getTotalDiscountAmount() + cashDrawer2.getTotalDiscountAmount());
                cashDrawer.setCashReceiptCount(cashDrawer.getCashReceiptCount() + cashDrawer2.getCashReceiptCount());
                cashDrawer.setCashReceiptAmount(cashDrawer.getCashReceiptAmount() + cashDrawer2.getCashReceiptAmount());
                cashDrawer.setCreditCardReceiptCount(cashDrawer.getCreditCardReceiptCount() + cashDrawer2.getCreditCardReceiptCount());
                cashDrawer.setCreditCardReceiptAmount(cashDrawer.getCreditCardReceiptAmount() + cashDrawer2.getCreditCardReceiptAmount());
                cashDrawer.setDebitCardReceiptCount(cashDrawer.getDebitCardReceiptCount() + cashDrawer2.getDebitCardReceiptCount());
                cashDrawer.setDebitCardReceiptAmount(cashDrawer.getDebitCardReceiptAmount() + cashDrawer2.getDebitCardReceiptAmount());
                cashDrawer.setGiftCertReturnCount(cashDrawer.getGiftCertReturnCount() + cashDrawer2.getGiftCertReturnCount());
                cashDrawer.setGiftCertReturnAmount(cashDrawer.getGiftCertReturnAmount() + cashDrawer2.getGiftCertReturnAmount());
                cashDrawer.setGiftCertChangeAmount(cashDrawer.getGiftCertChangeAmount() + cashDrawer2.getGiftCertChangeAmount());
                cashDrawer.setCustomPaymentCount(cashDrawer.getCustomPaymentCount() + cashDrawer2.getCustomPaymentCount());
                cashDrawer.setCustomPaymentAmount(cashDrawer.getCustomPaymentAmount() + cashDrawer2.getCustomPaymentAmount());
                cashDrawer.setRefundReceiptCount(cashDrawer.getRefundReceiptCount() + cashDrawer2.getRefundReceiptCount());
                cashDrawer.setRefundAmount(cashDrawer.getRefundAmount() + cashDrawer2.getRefundAmount());
                cashDrawer.setPayOutCount(cashDrawer.getPayOutCount() + cashDrawer2.getPayOutCount());
                cashDrawer.setPayOutAmount(cashDrawer.getPayOutAmount() + cashDrawer2.getPayOutAmount());
                cashDrawer.setDrawerBleedCount(cashDrawer.getDrawerBleedCount() + cashDrawer2.getDrawerBleedCount());
                cashDrawer.setDrawerBleedAmount(cashDrawer.getDrawerBleedAmount() + cashDrawer2.getDrawerBleedAmount());
                cashDrawer.setCashTips(cashDrawer.getCashTips() + cashDrawer2.getCashTips());
                cashDrawer.setChargedTips(cashDrawer.getChargedTips() + cashDrawer2.getChargedTips());
                cashDrawer.setCashBack(cashDrawer.getCashBack() + cashDrawer2.getCashBack());
                cashDrawer.setCashToDeposit(cashDrawer.getCashToDeposit() + cashDrawer2.getCashToDeposit());
                object = cashDrawer2.getCashBreakdownList();
                if (object != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        CashBreakdown cashBreakdown = (CashBreakdown)iterator.next();
                        CashBreakdown cashBreakdown2 = (CashBreakdown)hashMap.get(cashBreakdown.getCurrency().getName());
                        if (cashBreakdown2 == null) {
                            cashBreakdown2 = new CashBreakdown();
                            hashMap.put(cashBreakdown.getCurrency().getName(), cashBreakdown2);
                        }
                        cashBreakdown2.setBalance(cashBreakdown2.getBalance() + cashBreakdown.getBalance());
                        cashBreakdown2.setBalance(cashBreakdown2.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawer.setStoreSession(cashDrawer2.getStoreSession());
            }
        }
        cashDrawer.calculate();
        cashDrawer.setVoidEntries(new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(arrayList)));
        return cashDrawer;
    }

    public static void printCashDrawerReportSummary(StoreSession storeSession) {
        List<CashDrawer> list = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, false);
        CashDrawer cashDrawer = PosPrintService.populateCashDrawerReportSummary(list);
        cashDrawer.setStartTime(storeSession.getOpenTime());
        cashDrawer.setAssignedBy(storeSession.getOpenedBy());
        cashDrawer.setReportTime(storeSession.getCloseTime());
        cashDrawer.setClosedBy(storeSession.getClosedBy());
        PosPrintService.printCashDrawerSummaryReport(cashDrawer);
    }

    public static JasperPrint populateServerSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", "Server summary report");
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            string = user.getFullName();
            hashMap.put("user", "Staff : " + string);
        }
        string = DateUtil.formatFullDateAndTimeAsString(cashDrawer.getStartTime());
        if (cashDrawer.getReportTime() != null) {
            hashMap.put("date", "<b>From:</b> " + string + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(cashDrawer.getReportTime()));
        } else {
            hashMap.put("date", "<b>From:</b> " + string + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(new Date()));
        }
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport jasperReport = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport2 = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", jasperReport);
        hashMap.put("subreportParameter", jasperReport2);
        JasperReport jasperReport3 = ReportUtil.getReport("server-summary-report");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("ServerSummaryReport");
        return jasperPrint;
    }

    public static CashDrawer populateCloudCashDrawerReportSummary(List<CashDrawer> list) {
        CashDrawer cashDrawer = new CashDrawer();
        HashMap<String, CashBreakdown> hashMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (CashDrawer cashDrawer2 : list) {
                arrayList.add(cashDrawer2.getId());
                cashDrawer.setBeginCash(cashDrawer.getBeginCash() + cashDrawer2.getBeginCash());
                cashDrawer.setNetSales(cashDrawer.getNetSales() + cashDrawer2.getNetSales());
                cashDrawer.setSalesTax(cashDrawer.getSalesTax() + cashDrawer2.getSalesTax());
                cashDrawer.setSalesDeliveryCharge(cashDrawer.getSalesDeliveryCharge() + cashDrawer2.getSalesDeliveryCharge());
                cashDrawer.setTotalVoid(cashDrawer.getTotalVoid() + cashDrawer2.getTotalVoid());
                cashDrawer.setTotalVoidWst(cashDrawer.getTotalVoidWst() + cashDrawer2.getTotalVoidWst());
                cashDrawer.setTipsPaid(cashDrawer.getTipsPaid() + cashDrawer2.getTipsPaid());
                cashDrawer.setTotalDiscountCount(cashDrawer.getTotalDiscountCount() + cashDrawer2.getTotalDiscountCount());
                cashDrawer.setTotalDiscountAmount(cashDrawer.getTotalDiscountAmount() + cashDrawer2.getTotalDiscountAmount());
                cashDrawer.setCashReceiptCount(cashDrawer.getCashReceiptCount() + cashDrawer2.getCashReceiptCount());
                cashDrawer.setCashReceiptAmount(cashDrawer.getCashReceiptAmount() + cashDrawer2.getCashReceiptAmount());
                cashDrawer.setCreditCardReceiptCount(cashDrawer.getCreditCardReceiptCount() + cashDrawer2.getCreditCardReceiptCount());
                cashDrawer.setCreditCardReceiptAmount(cashDrawer.getCreditCardReceiptAmount() + cashDrawer2.getCreditCardReceiptAmount());
                cashDrawer.setDebitCardReceiptCount(cashDrawer.getDebitCardReceiptCount() + cashDrawer2.getDebitCardReceiptCount());
                cashDrawer.setDebitCardReceiptAmount(cashDrawer.getDebitCardReceiptAmount() + cashDrawer2.getDebitCardReceiptAmount());
                cashDrawer.setGiftCertReturnCount(cashDrawer.getGiftCertReturnCount() + cashDrawer2.getGiftCertReturnCount());
                cashDrawer.setGiftCertReturnAmount(cashDrawer.getGiftCertReturnAmount() + cashDrawer2.getGiftCertReturnAmount());
                cashDrawer.setGiftCertChangeAmount(cashDrawer.getGiftCertChangeAmount() + cashDrawer2.getGiftCertChangeAmount());
                cashDrawer.setCustomPaymentCount(cashDrawer.getCustomPaymentCount() + cashDrawer2.getCustomPaymentCount());
                cashDrawer.setCustomPaymentAmount(cashDrawer.getCustomPaymentAmount() + cashDrawer2.getCustomPaymentAmount());
                cashDrawer.setRefundReceiptCount(cashDrawer.getRefundReceiptCount() + cashDrawer2.getRefundReceiptCount());
                cashDrawer.setRefundAmount(cashDrawer.getRefundAmount() + cashDrawer2.getRefundAmount());
                cashDrawer.setPayOutCount(cashDrawer.getPayOutCount() + cashDrawer2.getPayOutCount());
                cashDrawer.setPayOutAmount(cashDrawer.getPayOutAmount() + cashDrawer2.getPayOutAmount());
                cashDrawer.setDrawerBleedCount(cashDrawer.getDrawerBleedCount() + cashDrawer2.getDrawerBleedCount());
                cashDrawer.setDrawerBleedAmount(cashDrawer.getDrawerBleedAmount() + cashDrawer2.getDrawerBleedAmount());
                cashDrawer.setCashTips(cashDrawer.getCashTips() + cashDrawer2.getCashTips());
                cashDrawer.setChargedTips(cashDrawer.getChargedTips() + cashDrawer2.getChargedTips());
                cashDrawer.setCashBack(cashDrawer.getCashBack() + cashDrawer2.getCashBack());
                cashDrawer.setCashToDeposit(cashDrawer.getCashToDeposit() + cashDrawer2.getCashToDeposit());
                List<CashBreakdown> list2 = cashDrawer2.getCashBreakdownList();
                if (list2 != null) {
                    for (CashBreakdown cashBreakdown : list2) {
                        CashBreakdown cashBreakdown2 = (CashBreakdown)hashMap.get(cashBreakdown.getCurrency().getName());
                        if (cashBreakdown2 == null) {
                            cashBreakdown2 = new CashBreakdown();
                            hashMap.put(cashBreakdown.getCurrency().getName(), cashBreakdown2);
                        }
                        cashBreakdown2.setBalance(cashBreakdown2.getBalance() + cashBreakdown.getBalance());
                        cashBreakdown2.setBalance(cashBreakdown2.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawer.setStoreOperationData(cashDrawer2.getStoreOperationData());
            }
        }
        cashDrawer.calculate();
        cashDrawer.setVoidEntries(new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(arrayList)));
        return cashDrawer;
    }
}

