/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesExceptionReportView
extends JPanel {
    private SimpleDateFormat a = new SimpleDateFormat("yyyy MMM dd, hh:mm a");
    private SimpleDateFormat b = new SimpleDateFormat("yyyy MMM dd");
    private JXDatePicker c = UiUtil.getCurrentMonthStart();
    private JXDatePicker d = UiUtil.getCurrentMonthEnd();
    private JButton e = new JButton(POSConstants.GO);
    private JPanel f;

    public SalesExceptionReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.c);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.d);
        jPanel.add((Component)this.e, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.f = new JPanel(new BorderLayout());
        jPanel2.add(this.f);
        this.add(jPanel2);
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SalesExceptionReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(SalesExceptionReportView.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void a() throws Exception {
        Date date;
        Date date2 = this.c.getDate();
        if (date2.after(date = this.d.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        date2 = DateUtil.startOfDay(date2);
        date = DateUtil.endOfDay(date);
        ReportService reportService = new ReportService();
        SalesExceptionReport salesExceptionReport = reportService.getSalesExceptionReport(date2, date);
        JasperReport jasperReport = ReportUtil.getReport("sales_summary_exception_voids");
        JasperReport jasperReport2 = ReportUtil.getReport("sales_summary_exception_refund_trns");
        JasperReport jasperReport3 = ReportUtil.getReport("sales_summary_exception_discounts");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("fromDate", this.b.format(date2));
        hashMap.put("toDate", this.b.format(date));
        hashMap.put("reportTime", this.a.format(new Date()));
        hashMap.put("voidReport", (String)jasperReport);
        hashMap.put("voidReportDataSource", (String)new JRTableModelDataSource((TableModel)salesExceptionReport.getVoidTableModel()));
        hashMap.put("refundReport", (String)jasperReport2);
        hashMap.put("refundReportDataSource", (String)new JRTableModelDataSource((TableModel)salesExceptionReport.getRefundTableModel()));
        hashMap.put("discountReport", (String)jasperReport3);
        hashMap.put("discountReportDataSource", (String)new JRTableModelDataSource((TableModel)salesExceptionReport.getDiscountTableModel()));
        JasperReport jasperReport4 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_exception_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport4, hashMap, (JRDataSource)new JREmptyDataSource());
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.f.removeAll();
        this.f.add((Component)jRViewer);
        this.f.revalidate();
    }
}

