/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

public class SalesReport
extends Report {
    private SalesReportModel a;
    private SalesReportModel b;
    private boolean c;

    public SalesReport(boolean bl) {
        this.c = bl;
    }

    @Override
    public void refresh() throws Exception {
        this.createModels();
        JasperReport jasperReport = ReportUtil.getReport("sales_sub_report");
        JasperReport jasperReport2 = ReportUtil.getReport("sales_sub_report");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        String string = this.c ? Messages.getString("SalesReport.3") : Messages.getString("SalesReport.9");
        hashMap.put("reportTitle", string);
        hashMap.put("reportTime", ReportService.formatFullDate(new Date()));
        hashMap.put("dateRange", ReportService.formatFullDate(this.getStartDate()) + " to " + ReportService.formatFullDate(this.getEndDate()));
        hashMap.put("terminalName", this.getTerminal() == null ? POSConstants.ALL : this.getTerminal().getName());
        hashMap.put("itemDataSource", new JRTableModelDataSource((TableModel)this.a));
        hashMap.put("modifierDataSource", new JRTableModelDataSource((TableModel)this.b));
        hashMap.put("currency", Messages.getString("SalesReport.8") + " " + CurrencyUtil.getCurrencyName() + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("itemReport", jasperReport);
        hashMap.put("isShowGroup", this.isShowInGroups());
        hashMap.put("modifierReport", jasperReport2);
        if (this.b.getItems().size() > 0) {
            hashMap.put("modifierSection", "MODIFIERS");
        }
        JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
        this.viewer = new JRViewer(jasperPrint);
    }

    @Override
    public boolean isDateRangeSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported() {
        return true;
    }

    public void createModels() {
        Object object;
        Date date = this.getStartDate();
        Date date2 = this.getEndDate();
        Terminal terminal = this.getTerminal();
        List<MenuGroup> list = this.getMenuGroups();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, ReportItem> linkedHashMap2 = new LinkedHashMap<String, ReportItem>();
        List<TicketItem> list2 = TicketItemDAO.getInstance().findTicketItemWithinDate(date, date2, terminal, list, this.c);
        String string = null;
        for (TicketItem object32 : list2) {
            if (object32.getUnitPrice() == 0.0 && !this.isIncludedFreeItems()) continue;
            object = object32.getMenuItemId();
            string = (String)(object == null ? object32.getName() : object) + "-" + object32.getUnitPrice();
            Object object2 = (ReportItem)((HashMap)linkedHashMap).get(string);
            if (object2 == null) {
                object2 = new ReportItem();
                ((ReportItem)object2).setId(string);
                ((ReportItem)object2).setPrice(object32.getUnitPrice());
                ((ReportItem)object2).setCost(object32.getUnitCost());
                ((ReportItem)object2).setName(object32.getName());
                ((ReportItem)object2).setTaxRate(object32.getTotalTaxRate());
                ((ReportItem)object2).setGroupName(object32.getGroupName());
                ((ReportItem)object2).setBarcode((String)object);
                ((ReportItem)object2).setAdjustedPrice(object32.getAdjustedUnitPrice());
                linkedHashMap.put(string, object2);
            }
            ((ReportItem)object2).setQuantity(((ReportItem)object2).getQuantity() + object32.getQuantity());
            ((ReportItem)object2).setGrossTotal(((ReportItem)object2).getGrossTotal() + object32.getAdjustedTotalWithoutModifiers());
            ((ReportItem)object2).setDiscount(((ReportItem)object2).getDiscount() + object32.getAdjustedDiscountWithoutModifiers());
            ((ReportItem)object2).setTaxTotal(((ReportItem)object2).getTaxTotal() + object32.getAdjustedTaxWithoutModifiers());
            ((ReportItem)object2).setServiceCharge(((ReportItem)object2).getServiceCharge() + object32.getServiceCharge());
            double d = object32.isTaxIncluded() != false ? object32.getAdjustedTotalWithoutModifiers() - object32.getAdjustedTaxWithoutModifiers() : object32.getAdjustedSubtotalWithoutModifiers();
            ((ReportItem)object2).setNetTotal(((ReportItem)object2).getNetTotal() + d);
        }
        this.a = new SalesReportModel();
        Collection collection = ((HashMap)linkedHashMap).values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (ReportItem)iterator.next();
            if (((ReportItem)object).getQuantity() != 0.0) continue;
            iterator.remove();
        }
        this.a.setItems(new ArrayList<ReportItem>(collection));
        List<TicketItemModifier> list3 = TicketItemDAO.getInstance().findTicketItemModifierWithinDate(date, date2, terminal, list, this.c);
        for (Object object2 : list3) {
            if (((BaseTicketItemModifier)object2).getUnitPrice() == 0.0 && !this.isIncludedFreeItems()) continue;
            String string2 = ((BaseTicketItemModifier)object2).getItemId();
            string = (string2 == null ? ((BaseTicketItemModifier)object2).getName() : string2) + "-" + ((BaseTicketItemModifier)object2).getModifierType() + "-" + ((BaseTicketItemModifier)object2).getUnitPrice();
            ReportItem reportItem = (ReportItem)((HashMap)linkedHashMap2).get(string);
            if (reportItem == null) {
                reportItem = new ReportItem();
                reportItem.setId(string2);
                reportItem.setPrice(((BaseTicketItemModifier)object2).getUnitPrice());
                reportItem.setName(((BaseTicketItemModifier)object2).getName());
                reportItem.setTaxRate(((TicketItemModifier)object2).getTotalTaxRate());
                reportItem.setAdjustedPrice(((BaseTicketItemModifier)object2).getAdjustedUnitPrice());
                reportItem.setServiceCharge(((BaseTicketItemModifier)object2).getServiceCharge());
                linkedHashMap2.put(string, reportItem);
            }
            reportItem.setQuantity(reportItem.getQuantity() + ((TicketItemModifier)object2).getItemQuantity() * ((TicketItemModifier)object2).getTicketItemQuantity());
            reportItem.setDiscount(reportItem.getDiscount() + ((BaseTicketItemModifier)object2).getAdjustedDiscount());
            reportItem.setServiceCharge(reportItem.getServiceCharge() + ((BaseTicketItemModifier)object2).getServiceCharge());
            reportItem.setGrossTotal(reportItem.getGrossTotal() + ((BaseTicketItemModifier)object2).getAdjustedTotal());
            reportItem.setTaxTotal(reportItem.getTaxTotal() + ((BaseTicketItemModifier)object2).getAdjustedTax());
            double d = ((BaseTicketItemModifier)object2).isTaxIncluded() != false ? ((BaseTicketItemModifier)object2).getAdjustedSubtotal() - ((BaseTicketItemModifier)object2).getAdjustedTax() : ((BaseTicketItemModifier)object2).getAdjustedSubtotal();
            reportItem.setNetTotal(reportItem.getNetTotal() + d);
        }
        this.b = new SalesReportModel();
        object = new ArrayList(((HashMap)linkedHashMap2).values());
        this.b.setItems((List<ReportItem>)object);
    }
}

