/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TransactionReportModel
extends AbstractTableModel {
    private static final SimpleDateFormat a = new SimpleDateFormat("dd-MM-yyyy hh:mm a");
    private String[] b = new String[]{"transTime", "transNo", "owner", "paymentType", "totalAmount"};
    private List<PosTransaction> c;

    @Override
    public int getRowCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    @Override
    public int getColumnCount() {
        return this.b.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.b[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = this.c.get(n);
        switch (n2) {
            case 0: {
                return a.format(posTransaction.getTransactionTime());
            }
            case 1: {
                return posTransaction.getId();
            }
            case 2: {
                User user = posTransaction.getUser();
                if (user == null) {
                    return "";
                }
                return user.getFirstName() + " [" + user.getId() + "]";
            }
            case 3: {
                return posTransaction.getPaymentTypeString();
            }
            case 4: {
                return posTransaction.getAmount();
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.c;
    }

    public void setItems(List<PosTransaction> list) {
        this.c = list;
    }
}

