/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.NewBarTabAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.ImageIcon;

public class OrderTypeButton
extends PosButton
implements ActionListener {
    private OrderType a;

    public OrderTypeButton() {
        super("");
    }

    private Image a(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public OrderTypeButton(OrderType orderType) {
        this.a = orderType;
        if (orderType != null) {
            ImageIcon imageIcon = orderType.getImage();
            if (imageIcon != null) {
                Image image = imageIcon.getImage();
                if (orderType.isShowImageOnly().booleanValue()) {
                    this.setIcon(new ImageIcon(this.a(image, 80, 60)));
                } else {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setText(orderType.name());
                    this.setBackground(orderType.getButtonColor());
                    this.setForeground(orderType.getTextColor());
                    this.setIcon(new ImageIcon(this.a(image, 80, 60)));
                }
            } else {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setText(orderType.name());
                this.setBackground(orderType.getButtonColor());
                this.setForeground(orderType.getTextColor());
            }
        }
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.a()) {
            POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
            return;
        }
        try {
            if (this.a.isBarTab().booleanValue()) {
                new NewBarTabAction(this.a, null, Application.getPosWindow()).actionPerformed(actionEvent);
            } else if (this.a.isRetailOrder().booleanValue()) {
                try {
                    OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null);
                    RootView.getInstance().showView("ORDER_VIEW");
                }
                catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
                    PosLog.error(this.getClass(), ticketAlreadyExistsException);
                }
            } else if (this.a.isShowTableSelection().booleanValue()) {
                TableSelectorDialog tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(this.a);
                tableSelectorDialog.setCreateNewTicket(true);
                tableSelectorDialog.updateView(true);
                tableSelectorDialog.openUndecoratedFullScreen();
                if (!tableSelectorDialog.isCanceled()) {
                    return;
                }
            } else if (this.a.isRequiredCustomerData().booleanValue()) {
                CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.a);
                customerSelectorDialog.setCreateNewTicket(true);
                customerSelectorDialog.updateView(true);
                customerSelectorDialog.openUndecoratedFullScreen();
                if (!customerSelectorDialog.isCanceled()) {
                    return;
                }
            } else {
                OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this.getParent(), exception.getMessage(), exception);
        }
    }

    private boolean a() {
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            Set<UserPermission> set = userType.getPermissions();
            for (UserPermission userPermission : set) {
                if (!userPermission.equals(UserPermission.CREATE_TICKET)) continue;
                return true;
            }
        }
        return false;
    }
}

