/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;

public class ImageUploaderDialog
extends POSDialog {
    public static String LAST_USED_FOLDER = "";
    public static ImageResource.IMAGE_CATEGORY imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
    public JLabel lblImagePreview;
    public JLabel lblDescription;
    public File imageFile;
    public File[] imageFiles;
    public ImageResource imgResource;
    public POSTextField tfDescription;
    public POSToggleButton tbtnUnlisted;
    public POSToggleButton tbtnFloorPlan;
    public POSToggleButton tbtnProducts;
    public POSToggleButton tbtnPeople;
    private int b;
    private int c;
    private JPanel d;
    private ArrayList<File> e;
    private boolean f;
    private JProgressBar g;
    private JLabel h;
    private PosButton i;
    boolean a = false;

    public ImageUploaderDialog(ImageResource imageResource) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imgResource = imageResource;
        this.a();
        this.c();
    }

    public ImageUploaderDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.a();
        this.c();
        this.f = true;
    }

    private void a() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Image Upload");
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.tbtnUnlisted = new POSToggleButton("UNLISTED");
        this.tbtnFloorPlan = new POSToggleButton("FLOORPLAN");
        this.tbtnProducts = new POSToggleButton("PRODUCTS");
        this.tbtnPeople = new POSToggleButton("PEOPLE");
        buttonGroup.add(this.tbtnUnlisted);
        buttonGroup.add(this.tbtnFloorPlan);
        buttonGroup.add(this.tbtnProducts);
        buttonGroup.add(this.tbtnPeople);
        jPanel.add(this.tbtnUnlisted);
        jPanel.add(this.tbtnFloorPlan);
        jPanel.add(this.tbtnProducts);
        jPanel.add(this.tbtnPeople);
        this.tbtnProducts.setEnabled(true);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setBorder(new EmptyBorder(20, 5, 20, 5));
        jPanel2.add((Component)jPanel, "North");
        this.lblImagePreview = new JLabel();
        this.lblDescription = new JLabel("Description");
        this.tfDescription = new POSTextField(50);
        JLabel jLabel = new JLabel(" ");
        this.d = new JPanel(new FlowLayout());
        this.d.add((Component)this.lblImagePreview, "center");
        JScrollPane jScrollPane = new JScrollPane(this.d, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(350, 220));
        jScrollPane.setVisible(true);
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jPanel3.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)this.lblDescription, "West");
        jPanel3.add((Component)this.tfDescription, "Center");
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[grow][grow][grow]", ""));
        this.g = new JProgressBar();
        this.g.setBounds(40, 40, 160, 30);
        this.g.setValue(0);
        this.g.setMinimum(0);
        this.g.setStringPainted(true);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.i = new PosButton("Select Image");
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!ImageUploaderDialog.this.f) {
                        ImageUploaderDialog.this.selectImage();
                    } else {
                        ImageUploaderDialog.this.selectBulkImage();
                    }
                }
                catch (PosException posException) {
                    JOptionPane.showMessageDialog(null, posException.getMessage(), "Error", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Unsupported File Format", "Error", 0);
                }
            }
        });
        PosButton posButton = new PosButton("Done");
        posButton.setPreferredSize(PosUIManager.getSize(100, 0));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.doOk();
                ImageUploaderDialog.this.setCanceled(false);
            }
        });
        PosButton posButton2 = new PosButton("Cancel");
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.setCanceled(true);
                ImageUploaderDialog.this.dispose();
            }
        });
        this.h = new JLabel("Importing Images: ");
        this.h.setVisible(false);
        jPanel4.add((Component)this.i, "");
        jPanel4.add((Component)this.h, "left,split 2");
        jPanel4.add((Component)this.g, "");
        jPanel4.add((Component)posButton, "growy,right,skip 2, split 2");
        jPanel4.add((Component)posButton2, "");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void doOk() {
        if (!this.f) {
            this.b();
            ImageResourceDAO.getInstance().saveOrUpdate(this.imgResource);
        } else {
            this.doSaveMultipleImage();
        }
        this.dispose();
    }

    private void b() {
        try {
            if (this.imgResource == null) {
                this.imgResource = new ImageResource();
            }
            this.imgResource.setDescription(this.tfDescription.getText());
            File file = (File)this.lblImagePreview.getClientProperty("image");
            if (file != null) {
                this.imgResource.setImageData(POSUtil.convertImageToBlob(file));
            }
            if (this.tbtnUnlisted.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
            } else if (this.tbtnFloorPlan.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            } else if (this.tbtnPeople.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
            } else if (this.tbtnProducts.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            }
        }
        catch (Exception exception) {
            PosLog.error(ImageUploaderDialog.class, exception.getMessage(), exception);
        }
    }

    public void doSaveMultipleImage() {
        try {
            ArrayList<ImageResource> arrayList = new ArrayList<ImageResource>();
            for (File file : this.e) {
                this.imgResource = new ImageResource();
                if (file != null) {
                    this.imgResource.setImageData(POSUtil.convertImageToBlob(file));
                }
                if (this.tbtnUnlisted.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
                } else if (this.tbtnFloorPlan.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
                } else if (this.tbtnPeople.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
                } else if (this.tbtnProducts.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                }
                arrayList.add(this.imgResource);
            }
            ImageResourceDAO.getInstance().saveOrUpdate(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void selectBulkImage() throws Exception {
        block7: {
            Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jFileChooser = null;
            jFileChooser = LAST_USED_FOLDER != null ? new JFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            int n = jFileChooser.showOpenDialog(this);
            this.e = new ArrayList();
            if (n == 0) {
                File[] fileArray;
                for (File file : fileArray = jFileChooser.getSelectedFiles()) {
                    if (file.isDirectory()) {
                        File[] fileArray2 = file.listFiles();
                        for (int i = 0; i < fileArray2.length; ++i) {
                            if (fileArray2[i].isDirectory()) {
                                this.a(fileArray2[i]);
                                continue;
                            }
                            this.a(fileArray2[i]);
                        }
                        continue;
                    }
                    this.a(file);
                }
                break block7;
            }
            return;
        }
        System.out.println();
    }

    public void showImages() {
        if (!this.f) {
            this.g.setVisible(false);
            return;
        }
        this.i.setVisible(false);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ImageUploaderDialog.this.a) {
                        return;
                    }
                    int n = 1;
                    ImageUploaderDialog.this.g.setMaximum(ImageUploaderDialog.this.e.size());
                    ImageUploaderDialog.this.h.setVisible(true);
                    for (File file : ImageUploaderDialog.this.e) {
                        JLabel jLabel = new JLabel();
                        BufferedImage bufferedImage = ImageIO.read(file);
                        jLabel.putClientProperty("image", file);
                        ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(500, 500, 1));
                        jLabel.setIcon(imageIcon);
                        ImageUploaderDialog.this.d.add(jLabel);
                        ImageUploaderDialog.this.d.revalidate();
                        ImageUploaderDialog.this.d.repaint();
                        Thread.sleep(500L);
                        ImageUploaderDialog.this.g.setValue(n);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void a(File file) {
        String string = new MimetypesFileTypeMap().getContentType(file);
        String string2 = string.split("/")[0];
        if (string2.equals("image")) {
            this.e.add(file);
        }
    }

    public void selectImage() throws Exception {
        block8: {
            Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jFileChooser = null;
            jFileChooser = LAST_USED_FOLDER != null ? new JFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) break block8;
            this.imageFile = jFileChooser.getSelectedFile();
            preferences.put(LAST_USED_FOLDER, this.imageFile.getPath());
            byte[] byArray = FileUtils.readFileToByteArray((File)this.imageFile);
            int n2 = byArray.length / 1024;
            Image image = null;
            if (n2 > 500 && this.b <= 0 && this.c <= 0) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "The image is too large. Do you want to resize?", "Confirm") != 0) {
                    byArray = null;
                    throw new PosException("The image is too large. Please select an image within 500kb in size");
                }
                this.b = 200;
                this.c = 200;
            }
            if (this.b > 0 && this.c > 0) {
                image = ImageIO.read(this.imageFile).getScaledInstance(this.b, this.c, 4);
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
                File file = new File("saved.png");
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                }
                catch (IOException iOException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), iOException.getMessage());
                }
                this.lblImagePreview.putClientProperty("image", file);
            } else {
                image = ImageIO.read(this.imageFile);
                this.lblImagePreview.putClientProperty("image", this.imageFile);
            }
            this.lblImagePreview.setText("");
            this.lblImagePreview.setIcon(new ImageIcon(image));
        }
    }

    private void c() {
        ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY = imageType;
        if (this.imgResource != null && this.imgResource.getImageCategory() != null) {
            iMAGE_CATEGORY = this.imgResource.getImageCategory();
        }
        if (iMAGE_CATEGORY == ImageResource.IMAGE_CATEGORY.UNLISTED) {
            this.tbtnUnlisted.setSelected(true);
        } else if (iMAGE_CATEGORY == ImageResource.IMAGE_CATEGORY.FLOORPLAN) {
            this.tbtnFloorPlan.setSelected(true);
        } else if (iMAGE_CATEGORY == ImageResource.IMAGE_CATEGORY.PRODUCTS) {
            this.tbtnProducts.setSelected(true);
        } else if (iMAGE_CATEGORY == ImageResource.IMAGE_CATEGORY.PEOPLE) {
            this.tbtnPeople.setSelected(true);
        }
        if (this.imgResource == null) {
            return;
        }
        ImageIcon imageIcon = this.imgResource.getScaledImage(120, 120);
        if (imageIcon == null) {
            return;
        }
        this.lblImagePreview.setText("");
        this.lblImagePreview.setIcon(imageIcon);
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        File file = new File("saved.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), iOException.getMessage());
        }
        this.lblImagePreview.putClientProperty("image", file);
        if (this.imgResource.getDescription() != null) {
            this.tfDescription.setText(this.imgResource.getDescription());
        }
    }

    public File getSelectedImageFile() {
        return this.imageFile;
    }

    public List<File> getSelectedImageFiles() {
        return this.e;
    }

    public void setImageMaximumSize(int n, int n2) {
        this.b = n;
        this.c = n2;
    }

    @Override
    public void open() {
        this.showImages();
        super.open();
    }
}

