/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import.service;

import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelImporterService {
    private static final ExcelImporterService a = new ExcelImporterService();

    public static ExcelImporterService getInstance() {
        return a;
    }

    public void doImportMenuItemFromXLSX(List<Object> list, MenuCategory menuCategory, MenuGroup menuGroup, XSSFSheet xSSFSheet) throws Exception {
        Iterator iterator = xSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            XSSFRow xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() == 0) continue;
            if (xSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)xSSFRow))) break;
            Iterator iterator2 = xSSFRow.cellIterator();
            MenuItem menuItem = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = xSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(string);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(string);
                    menuCategory.setVisible(true);
                    MenuCategoryDAO.getInstance().save(menuCategory);
                    continue;
                }
                if (string2.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(string);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(string);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    MenuGroupDAO.getInstance().saveOrUpdate(menuGroup);
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (string2.equals("Product Name")) {
                    menuItem = new MenuItem();
                    menuItem.setName(string);
                    menuItem.setMenuCategoryId(menuCategory.getId());
                    menuItem.setMenuGroupId(menuGroup.getId());
                    menuItem.setMenuGroupName(menuGroup.getName());
                    menuItem.setMenuCategoryName(menuCategory.getName());
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (string2.equals("Product Description")) {
                    menuItem.setDescription(string);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuItem.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Cost")) {
                    menuItem.setCost(this.a(string, d));
                    continue;
                }
                if (string2.equals("SKU")) {
                    menuItem.setSku(string);
                    continue;
                }
                if (string2.equals("Barcode")) {
                    menuItem.setBarcode(string);
                    continue;
                }
                if (string2.equals("Active")) {
                    menuItem.setVisible(this.a(string));
                    continue;
                }
                if (string2.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.a(string));
                    continue;
                }
                if (string2.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.a(string));
                    continue;
                }
                if (!string2.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.a(string));
            }
            if (menuItem == null) continue;
            list.add(menuItem);
        }
    }

    public void doImportMenuModifierFromXLSX(List<Object> list, ModifierGroup modifierGroup, XSSFSheet xSSFSheet) throws Exception {
        Iterator iterator = xSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            XSSFRow xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() == 0) continue;
            if (xSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)xSSFRow))) break;
            Iterator iterator2 = xSSFRow.cellIterator();
            MenuModifier menuModifier = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = xSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Modifier Group")) {
                    modifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(string);
                    if (modifierGroup != null) continue;
                    modifierGroup = new ModifierGroup();
                    modifierGroup.setName(string);
                    ModifierGroupDAO.getInstance().saveOrUpdate(modifierGroup);
                    continue;
                }
                if (string2.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(string);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(string);
                        modifierGroup.addTomodifiers(menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuModifier.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Active")) {
                    menuModifier.setEnable(this.a(string));
                    continue;
                }
                if (!string2.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.a(string));
            }
            if (menuModifier == null) continue;
            list.add(menuModifier);
        }
    }

    public void doImportMenuItemFromXLS(List<Object> list, MenuCategory menuCategory, MenuGroup menuGroup, HSSFSheet hSSFSheet) throws Exception {
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            if (hSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)hSSFRow))) break;
            Iterator iterator2 = hSSFRow.cellIterator();
            MenuItem menuItem = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = hSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(string);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(string);
                    menuCategory.setVisible(true);
                    continue;
                }
                if (string2.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(string);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(string);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (string2.equals("Product Name")) {
                    menuItem = new MenuItem();
                    menuItem.setName(string);
                    menuItem.setMenuCategoryId(menuCategory.getId());
                    menuItem.setMenuGroupId(menuGroup.getId());
                    menuItem.setMenuGroupName(menuGroup.getName());
                    menuItem.setMenuCategoryName(menuCategory.getName());
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (string2.equals("Product Description")) {
                    menuItem.setDescription(string);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuItem.setPrice(d);
                    continue;
                }
                if (string2.equals("Cost")) {
                    menuItem.setCost(d);
                    continue;
                }
                if (string2.equals("SKU")) {
                    menuItem.setSku(string);
                    continue;
                }
                if (string2.equals("Barcode")) {
                    menuItem.setBarcode(string);
                    continue;
                }
                if (string2.equals("Active")) {
                    menuItem.setVisible(this.a(string));
                    continue;
                }
                if (string2.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.a(string));
                    continue;
                }
                if (string2.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.a(string));
                    continue;
                }
                if (!string2.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.a(string));
            }
            if (menuItem == null) continue;
            list.add(menuItem);
        }
    }

    public void doImportMenuModifierFromXLS(List<Object> list, ModifierGroup modifierGroup, HSSFSheet hSSFSheet) throws Exception {
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            boolean bl;
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            if (hSSFRow.getRowNum() == 1 && (bl = this.isRowEmpty((Row)hSSFRow))) break;
            Iterator iterator2 = hSSFRow.cellIterator();
            MenuModifier menuModifier = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = hSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Modifier Group")) {
                    modifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(string);
                    if (modifierGroup != null) continue;
                    modifierGroup = new ModifierGroup();
                    modifierGroup.setName(string);
                    ModifierGroupDAO.getInstance().saveOrUpdate(modifierGroup);
                    continue;
                }
                if (string2.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(string);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(string);
                        modifierGroup.addTomodifiers(menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuModifier.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Active")) {
                    menuModifier.setEnable(this.a(string));
                    continue;
                }
                if (!string2.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.a(string));
            }
            if (menuModifier == null) continue;
            list.add(menuModifier);
        }
    }

    private double a(String string, double d) {
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d2 = d;
        }
        return d2;
    }

    private boolean a(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return string.equalsIgnoreCase("yes");
    }

    public boolean isRowEmpty(Row row) {
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellTypeEnum() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    public boolean checkImporteMenuItemIsDublicate(List<MenuItem> list) {
        if (list == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (MenuItem serializable2 : list) {
            arrayList.add(serializable2.getBarcode());
            arrayList2.add(serializable2.getSku());
            boolean bl = MenuItemDAO.getInstance().hasByBarcodeOrSKU(serializable2.getBarcode(), serializable2.getSku());
            if (!bl) continue;
            return true;
        }
        HashSet hashSet = new HashSet(arrayList);
        if (hashSet.size() < arrayList.size()) {
            return true;
        }
        HashSet hashSet2 = new HashSet(arrayList2);
        return hashSet2.size() < arrayList2.size();
    }
}

