/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.LogoutAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.KitchenActionButton;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayConfigDialog;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.kitchendisplay.KitchenFilterDialog;
import com.floreantpos.ui.kitchendisplay.KitchenTicketActionListener;
import com.floreantpos.ui.kitchendisplay.KitchenTicketView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class KitchenTicketListPanel
extends JPanel
implements KitchenTicketActionListener,
ActionListener {
    private static final int a = 0;
    private static final int b = 0;
    private PaginatedListModel c = new PaginatedListModel();
    private JPanel d;
    private TitledBorder e;
    private KitchenActionButton f;
    private KitchenActionButton g;
    private KitchenActionButton h;
    private KitchenActionButton i;
    private KitchenActionButton j;
    private KitchenActionButton k;
    private KitchenActionButton l;
    private int m = 4;
    private List<Printer> n;
    private List<OrderType> o;
    private PosBlinkButton p;
    private KitchenActionButton q;
    private Stack<KitchenTicket> r = new Stack();
    private Timer s;
    private Date t;
    private static final Color u = Color.white;
    private static final Color v = Color.black;
    private KitchenActionButton w;

    public KitchenTicketListPanel() {
        this.e = new TitledBorder("");
        this.e.setTitleJustification(2);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new CompoundBorder(this.e, new EmptyBorder(0, 0, 0, 0)));
        this.d = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.d.setOpaque(false);
        this.add(this.d);
        Dimension dimension = PosUIManager.getSize(90, 40);
        Color color = Color.white;
        Color color2 = Color.white;
        Color color3 = Color.white;
        this.f = new KitchenActionButton("", u, v);
        this.i = new KitchenActionButton(POSConstants.CLOSE.toUpperCase(), u, v);
        this.h = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.2").toUpperCase(), u, v);
        this.g = new KitchenActionButton(POSConstants.FILTER.toUpperCase(), color3);
        this.w = new KitchenActionButton(Messages.getString("OPTION").toUpperCase(), color2);
        this.q = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.1").toUpperCase(), color);
        this.k = new KitchenActionButton(POSConstants.CAPITAL_PREV, u, v);
        this.j = new KitchenActionButton(POSConstants.CAPITAL_NEXT, u, v);
        this.l = new KitchenActionButton(Messages.getString("BUMP_ALL"), u, v);
        this.p = new PosBlinkButton(){

            @Override
            public Color getBackground() {
                if (KitchenTicketListPanel.this.p == null) {
                    return Color.white;
                }
                return super.getBackground();
            }

            @Override
            public Color getForeground() {
                if (KitchenTicketListPanel.this.p == null || !KitchenTicketListPanel.this.p.isBlinking()) {
                    return Color.black;
                }
                return Color.white;
            }
        };
        this.p.setFont(this.p.getFont().deriveFont(1));
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.c();
            }
        });
        this.h.setBtnToogle(true);
        this.h.setCellButton(false);
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.h.setSelected(!KitchenTicketListPanel.this.h.isSelected());
                KitchenTicketListPanel.this.getDataModel().setCurrentRowIndex(0);
                if (KitchenTicketListPanel.this.h.isSelected()) {
                    KitchenTicketListPanel.this.l.setText(Messages.getString("DISPATCH_ALL"));
                } else {
                    KitchenTicketListPanel.this.l.setText(Messages.getString("BUMP_ALL"));
                }
                KitchenTicketListPanel.this.updateKDSView();
            }
        });
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenDisplayConfigDialog kitchenDisplayConfigDialog = new KitchenDisplayConfigDialog();
                kitchenDisplayConfigDialog.pack();
                kitchenDisplayConfigDialog.open();
                if (kitchenDisplayConfigDialog.isCanceled()) {
                    return;
                }
                KitchenTicketListPanel.this.c.setCurrentRowIndex(0);
                KitchenTicketListPanel.this.updateKDSView();
                KitchenDisplayView.getInstance().updateView();
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.b();
            }
        });
        this.f.setAction(new LogoutAction(true, false));
        this.f.setText(POSConstants.LOGOUT.toUpperCase());
        this.q.setEnabled(false);
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.unbump();
            }
        });
        this.p.setText(POSConstants.REFRESH.toUpperCase());
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.c.setCurrentRowIndex(0);
                KitchenTicketListPanel.this.updateKDSView();
            }
        });
        this.p.setBorder(null);
        this.p.setOpaque(true);
        ScrollAction scrollAction = new ScrollAction();
        this.k.addActionListener(scrollAction);
        this.j.addActionListener(scrollAction);
        this.j.setEnabled(false);
        this.k.setEnabled(false);
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.a();
            }
        });
        int n = PosUIManager.getSize(16);
        this.k.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.BACKWARD, (float)n));
        this.j.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FORWARD, (float)n));
        this.j.setHorizontalTextPosition(2);
        this.p.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.REFRESH, (float)n));
        this.g.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FILTER, (float)n));
        this.q.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.UNDO, (float)n));
        this.i.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.WINDOW_CLOSE, (float)n));
        this.f.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ARROW_CIRCLE_O_LEFT, (float)n));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]2px[]", ""));
        jPanel.setOpaque(false);
        String string = "w " + (dimension.width + 7) + "!, growy,gap 1";
        jPanel.add((Component)this.f, string);
        jPanel.add((Component)this.i, string);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3, ins 0 2 3 2", "[][grow][]", "[]"));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setBackground(Color.white);
        jSeparator.setForeground(Color.white);
        jSeparator.setPreferredSize(PosUIManager.getSize(0, 5));
        jPanel2.add((Component)jSeparator, "growx,span");
        jPanel2.add((Component)jPanel, "growy");
        jPanel2.add((Component)this.l, "split 6,center," + string);
        jPanel2.add((Component)this.h, string);
        jPanel2.add((Component)this.g, string);
        jPanel2.add((Component)this.w, string);
        jPanel2.add((Component)this.q, string);
        jPanel2.add((Component)this.p, string + "");
        jPanel2.add((Component)this.k, "split 3,right," + string);
        jPanel2.add((Component)this.j, string + ",gapleft 1");
        this.add((Component)jPanel2, "South");
        jPanel2.setBackground(Color.black);
        this.s = new Timer(5000, this);
        this.s.setRepeats(true);
    }

    public void setBackButtonVisible(boolean bl) {
        this.i.setVisible(bl);
        this.f.setVisible(!bl);
    }

    private void a() {
        KitchenFilterDialog kitchenFilterDialog = new KitchenFilterDialog();
        kitchenFilterDialog.open();
        if (kitchenFilterDialog.isCanceled()) {
            return;
        }
        this.n = kitchenFilterDialog.getPrinter();
        this.o = kitchenFilterDialog.getOrderType();
        this.getDataModel().setCurrentRowIndex(0);
        this.updateKDSView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKDSView() {
        this.stopTimer();
        this.reset();
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            int n = TerminalConfig.getKDSTicketsPerPage();
            this.m = (int)Math.round((double)n / 2.0);
            this.c.setPageSize(n);
            KitchenTicketDAO.getInstance().loadItems(terminal, this.n, this.o, this.h.isSelected(), this.c);
            this.p.setBlinking(false);
            Date date = KitchenTicketDAO.getInstance().getLastUpdateDate();
            if (date != null) {
                this.t = new Date(date.getTime());
            }
            this.setDataModel(this.c);
            this.r.clear();
            this.refreshUndoRedo();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        finally {
            this.restartTimer();
        }
    }

    protected void setDataModel(PaginatedListModel paginatedListModel) {
        this.c = paginatedListModel;
        this.renderItems();
    }

    protected void updateButton() {
        boolean bl = this.c.hasNext();
        boolean bl2 = this.c.hasPrevious();
        this.j.setVisible(bl || bl2);
        this.k.setVisible(bl || bl2);
        this.k.setEnabled(bl2);
        this.j.setEnabled(bl);
    }

    public PaginatedListModel getDataModel() {
        return this.c;
    }

    public void reset() {
        Component[] componentArray;
        for (Component component : componentArray = this.d.getComponents()) {
            if (!(component instanceof KitchenTicketView)) continue;
            KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
            kitchenTicketView.stopTimer();
        }
        this.d.removeAll();
        this.d.repaint();
        this.j.setEnabled(false);
        this.k.setEnabled(false);
    }

    protected void renderItems() {
        try {
            int n;
            this.reset();
            if (this.c == null || this.c.getSize() == 0) {
                this.j.setEnabled(this.c.hasNext());
                this.k.setEnabled(this.c.hasPrevious());
                return;
            }
            int n2 = TerminalConfig.getKDSTicketsPerPage();
            if (n2 <= 5) {
                this.d.setLayout(new GridLayout(1, n2, 5, 5));
            } else {
                n = (int)Math.ceil((double)n2 / 2.0);
                this.d.setLayout(new GridLayout(2, n, 5, 5));
            }
            this.d.setOpaque(false);
            for (n = 0; n < n2; ++n) {
                TransparentPanel transparentPanel;
                if (n >= this.c.getSize()) {
                    transparentPanel = new TransparentPanel();
                    this.d.add(transparentPanel);
                    continue;
                }
                transparentPanel = this.c.getElementAt(n);
                JPanel jPanel = this.createKitchenTicket(transparentPanel, n);
                if (jPanel == null) continue;
                this.d.add(jPanel);
            }
            this.j.setEnabled(this.c.hasNext());
            this.k.setEnabled(this.c.hasPrevious());
            this.refreshUndoRedo();
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    protected void scrollDown() {
        if (!this.c.hasNext()) {
            return;
        }
        this.r.clear();
        this.c.setCurrentRowIndex(this.c.getNextRowIndex());
        this.updateKDSView();
    }

    protected void scrollUp() {
        if (!this.c.hasPrevious()) {
            return;
        }
        this.r.clear();
        this.c.setCurrentRowIndex(this.c.getPreviousRowIndex());
        this.updateKDSView();
    }

    protected JPanel createKitchenTicket(Object object, int n) {
        KitchenTicket kitchenTicket = (KitchenTicket)object;
        kitchenTicket.setSortOrder(n);
        if (kitchenTicket.getId() == null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            return jPanel;
        }
        KitchenTicketView kitchenTicketView = new KitchenTicketView(kitchenTicket, this);
        kitchenTicketView.putClientProperty("key", n + 1);
        return kitchenTicketView;
    }

    public void setSelectedKey(int n) {
        if (PosGuiUtil.isModalDialogShowing()) {
            return;
        }
        if (n == 10) {
            this.updateKDSView();
            return;
        }
        if (n == 81) {
            Application.getInstance().doLogout();
            return;
        }
        if (n == 85 && !this.h.isSelected()) {
            this.unbump();
            return;
        }
        Component[] componentArray = this.d.getComponents();
        if (componentArray.length == 0) {
            return;
        }
        if (n == 78) {
            this.scrollDown();
            return;
        }
        if (n == 80) {
            this.scrollUp();
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (Component component2 : componentArray) {
            if (component2 instanceof KitchenTicketView) {
                boolean bl3;
                KitchenTicketView kitchenTicketView = (KitchenTicketView)component2;
                if (kitchenTicketView.isKeySelected() && (n == 66 || n == 32)) {
                    kitchenTicketView.fireBumpSelected();
                    return;
                }
                if (n != 37 && n != 39 && n != 40 && n != 38 && (bl3 = kitchenTicketView.keySelected(n))) {
                    bl2 = true;
                }
                if (kitchenTicketView.isKeySelected()) {
                    bl = true;
                    n3 = n4;
                    n2 = n4;
                }
            }
            ++n4;
        }
        if (bl2) {
            return;
        }
        boolean bl4 = true;
        if (bl && n != 32) {
            switch (n) {
                case 39: {
                    if (++n3 < this.m * 2) break;
                    n3 = 0;
                    break;
                }
                case 37: {
                    if (--n3 >= 0) break;
                    return;
                }
                case 40: {
                    if ((n3 += this.m) < this.m * 2) break;
                    return;
                }
                case 38: {
                    if ((n3 -= this.m) < this.m * 2) break;
                    return;
                }
                default: {
                    bl4 = false;
                }
            }
        }
        if (bl4) {
            if (n3 < 0 || componentArray.length < n3 + 1) {
                return;
            }
            Component component = componentArray[n3];
            if (component == null || !(component instanceof KitchenTicketView)) {
                return;
            }
            KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
            kitchenTicketView.setSelected(true);
            if (n3 != n2) {
                Component component2;
                component2 = (KitchenTicketView)componentArray[n2];
                if (component2 == null) {
                    return;
                }
                ((KitchenTicketView)component2).setSelected(false);
            }
        }
    }

    public PaginatedListModel getModel() {
        return this.c;
    }

    public void refreshUndoRedo() {
        this.q.setEnabled(!this.r.isEmpty());
    }

    @Override
    public boolean isDispatchMode() {
        if (this.h != null) {
            return this.h.isSelected();
        }
        return false;
    }

    @Override
    public void dispatch(KitchenTicketView kitchenTicketView) {
        KitchenTicket kitchenTicket = kitchenTicketView.getTicket();
        KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.DISPATCHED, KitchenStatus.DISPATCHED, false);
        KitchenTicketDAO.getInstance().delete(kitchenTicket);
        this.updateKDSView();
    }

    @Override
    public void bump(KitchenTicketView kitchenTicketView) {
        try {
            KitchenTicket kitchenTicket = kitchenTicketView.getTicket();
            KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.BUMP, KitchenStatus.BUMP, true);
            this.t = kitchenTicket.getLastUpdateTime();
            this.r.push(kitchenTicket);
            this.c.getDataList().set(kitchenTicket.getSortOrder(), new KitchenTicket());
            this.renderItems();
            this.refreshUndoRedo();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), staleStateException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public void bumpAll() {
        try {
            List<KitchenTicket> list = KitchenTicketDAO.getInstance().findAllOpen();
            if (list.isEmpty()) {
                POSMessageDialog.showError(this, "No data to bump");
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to bump all tickets?", "Confirm");
            if (n != 0) {
                return;
            }
            for (KitchenTicket kitchenTicket : list) {
                KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.BUMP, KitchenStatus.BUMP, true);
            }
            this.c.getDataList().clear();
            this.t = new Date();
            this.renderItems();
            this.refreshUndoRedo();
            this.c.getDataList().clear();
            this.t = new Date();
            this.renderItems();
            this.refreshUndoRedo();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), staleStateException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void b() {
        try {
            if (this.h.isSelected()) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to dispatch all tickets?", "Confirm");
                if (n != 0) {
                    return;
                }
                KitchenTicketDAO.getInstance().dispatchAll();
                this.updateKDSView();
            } else {
                this.bumpAll();
                this.updateKDSView();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void unbump() {
        if (this.r.isEmpty()) {
            return;
        }
        KitchenTicket kitchenTicket = this.r.pop();
        try {
            KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.WAITING, KitchenStatus.WAITING, false);
            this.t = kitchenTicket.getLastUpdateTime();
            this.c.getDataList().set(kitchenTicket.getSortOrder(), kitchenTicket);
            this.renderItems();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public boolean isBlinkingRefreshButton() {
        return this.p.isBlinking();
    }

    public void setBlinkingRefreshButton(boolean bl) {
        this.p.setBlinking(bl);
        Window window = SwingUtilities.getWindowAncestor(this);
        window.toFront();
    }

    private void c() {
        Window window = this.d();
        if (window == null) {
            RootView.getInstance().showDefaultView();
        } else {
            window.dispose();
        }
    }

    private Window d() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            return window;
        }
        return null;
    }

    public void startTimer() {
        if (!this.s.isRunning()) {
            this.s.start();
        }
    }

    public void stopTimer() {
        if (this.s.isRunning()) {
            this.s.stop();
        }
    }

    public void restartTimer() {
        this.s.restart();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (PosGuiUtil.isModalDialogShowing()) {
                return;
            }
            this.s.stop();
            this.d.repaint();
            if (this.isBlinkingRefreshButton()) {
                return;
            }
            Date date = KitchenTicketDAO.getInstance().getLastUpdateDate();
            if (date == null) {
                return;
            }
            if (this.t != null && new Date(date.getTime()).after(this.t)) {
                this.setBlinkingRefreshButton(true);
            }
        }
        finally {
            this.s.restart();
        }
    }

    private class ScrollAction
    implements ActionListener {
        private ScrollAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = actionEvent.getSource();
                if (object == KitchenTicketListPanel.this.k) {
                    KitchenTicketListPanel.this.scrollUp();
                } else if (object == KitchenTicketListPanel.this.j) {
                    KitchenTicketListPanel.this.scrollDown();
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }
    }
}

