/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class MenuCategoryForm
extends BeanEditor {
    private CheckBoxList a;
    private CheckBoxList b;
    private CheckBoxList c;
    private JCheckBox d;
    private JCheckBox e;
    private JLabel f;
    private FixedLengthTextField g;
    private IntegerTextField h;
    private JButton i;
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private FixedLengthTextField m;
    private JLabel n;
    private JButton o;

    public MenuCategoryForm() throws Exception {
        this(new MenuCategory());
    }

    public MenuCategoryForm(MenuCategory menuCategory) throws Exception {
        this.a();
        this.setBean(menuCategory);
    }

    @Override
    public String getDisplayText() {
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        if (menuCategory.getId() == null) {
            return POSConstants.NEW_MENU_CATEGORY;
        }
        return POSConstants.EDIT_MENU_CATEGORY;
    }

    private void a() {
        this.f = new JLabel();
        this.e = new JCheckBox();
        this.g = new FixedLengthTextField();
        this.g.setLength(120);
        this.d = new JCheckBox();
        this.f.setText(POSConstants.NAME + ":");
        this.e.setText(POSConstants.VISIBLE);
        this.e.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.e.setMargin(new Insets(0, 0, 0, 0));
        this.d.setText(POSConstants.BEVERAGE);
        this.d.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.d.setMargin(new Insets(0, 0, 0, 0));
        this.j = new JLabel(Messages.getString("MenuCategoryForm.1"));
        this.h = new IntegerTextField();
        this.h.setColumns(10);
        this.k = new JLabel(Messages.getString("MenuCategoryForm.2"));
        this.i = new JButton();
        this.i.setPreferredSize(new Dimension(140, 40));
        this.a = new CheckBoxList();
        List<Department> list = DepartmentDAO.getInstance().findAll();
        this.a.setModel(list);
        TitledBorder titledBorder = new TitledBorder(Messages.getString("MenuCategoryForm.0"));
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setBorder(titledBorder);
        jScrollPane.setPreferredSize(new Dimension(228, 100));
        this.b = new CheckBoxList();
        this.b.setModel(OrderTypeDAO.getInstance().findAll());
        JScrollPane jScrollPane2 = new JScrollPane(this.b);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Order Types"));
        jScrollPane2.setPreferredSize(new Dimension(228, 120));
        this.c = new CheckBoxList();
        List<MenuShift> list2 = MenuShiftDAO.getInstance().findAll();
        this.c.setModel(list2);
        TitledBorder titledBorder2 = new TitledBorder("Menu shifts");
        JScrollPane jScrollPane3 = new JScrollPane(this.c);
        jScrollPane3.setBorder(titledBorder2);
        jScrollPane3.setPreferredSize(new Dimension(228, 100));
        this.l = new JLabel(Messages.getString("MenuCategoryForm.7"));
        this.m = new FixedLengthTextField();
        this.m.setLength(120);
        this.n = new JLabel("Text color");
        this.o = new JButton();
        this.o.setText(Messages.getString("MenuCategoryForm.16"));
        this.o.setPreferredSize(new Dimension(140, 40));
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "[87px][327px,grow]", ""));
        this.add((Component)this.f, "cell 0 0,alignx left,aligny center");
        this.add((Component)this.g, "cell 1 0,growx,aligny top");
        this.add((Component)this.l, "cell 0 1,alignx trailing");
        this.add((Component)this.m, "cell 1 1,growx");
        this.add((Component)this.j, "cell 0 2,alignx left,aligny center");
        this.add((Component)this.h, "cell 1 2,alignx left,aligny top");
        this.add((Component)this.k, "cell 0 3,h 25!,alignx left,growy");
        this.add((Component)this.i, "cell 1 3,h 25!,alignx left,growy");
        this.add((Component)this.n, "cell 0 4,h 25!");
        this.add((Component)this.o, "cell 1 4,h 25!,growy");
        this.add((Component)this.d, "cell 1 5,alignx left,growy");
        this.add((Component)this.e, "cell 1 6,alignx left,gapbottom 5,aligny top");
        this.add((Component)jScrollPane2, "cell 1 7, growy, split 2");
        this.add((Component)jScrollPane3, "cell 1 7, growy");
        this.add((Component)jScrollPane, "cell 1 8, growy");
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryForm.21"), MenuCategoryForm.this.i.getBackground());
                MenuCategoryForm.this.i.setBackground(color);
                MenuCategoryForm.this.o.setBackground(color);
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryForm.22"), MenuCategoryForm.this.o.getForeground());
                MenuCategoryForm.this.o.setForeground(color);
            }
        });
    }

    @Override
    protected void updateView() {
        Color color;
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        MenuCategoryDAO.getInstance().initialize(menuCategory);
        if (menuCategory == null) {
            this.g.setText("");
            this.m.setText("");
            this.h.setText("0");
            this.e.setSelected(false);
            return;
        }
        this.g.setText(menuCategory.getName());
        this.m.setText(menuCategory.getTranslatedName());
        if (menuCategory.getSortOrder() != null) {
            this.h.setText(menuCategory.getSortOrder().toString());
        }
        if ((color = menuCategory.getButtonColor()) != null) {
            this.i.setBackground(color);
            this.o.setBackground(color);
        }
        if (menuCategory.getTextColor() != null) {
            this.o.setForeground(menuCategory.getTextColor());
        }
        this.d.setSelected(menuCategory.isBeverage());
        if (menuCategory.getId() == null) {
            this.e.setSelected(true);
        } else {
            this.e.setSelected(menuCategory.isVisible());
        }
        if (menuCategory.getDepartments() != null) {
            ArrayList<Department> arrayList = new ArrayList<Department>(menuCategory.getDepartments());
            this.a.selectItems(arrayList);
        }
        this.b.selectItems(menuCategory.getOrderTypes());
        this.c.selectItems(menuCategory.getMenuShifts());
    }

    @Override
    protected boolean updateModel() {
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        if (menuCategory == null) {
            return false;
        }
        String string = this.g.getText();
        if (POSUtil.isBlankOrNull(string)) {
            MessageDialog.showError(Messages.getString("MenuCategoryForm.26"));
            return false;
        }
        menuCategory.setName(string);
        menuCategory.setTranslatedName(this.m.getText());
        menuCategory.setSortOrder(this.h.getInteger());
        menuCategory.setButtonColor(this.i.getBackground());
        menuCategory.setTextColor(this.o.getForeground());
        menuCategory.setButtonColorCode(this.i.getBackground().getRGB());
        menuCategory.setTextColorCode(this.o.getForeground().getRGB());
        menuCategory.setBeverage(this.d.isSelected());
        menuCategory.setVisible(this.e.isSelected());
        menuCategory.setOrderTypes(POSUtil.copySelectedValues(menuCategory.getOrderTypes(), this.b.getCheckedValuesAsSet()));
        menuCategory.setDepartments(POSUtil.copySelectedValues(menuCategory.getDepartments(), this.a.getCheckedValuesAsSet()));
        menuCategory.setMenuShifts(POSUtil.copySelectedValues(menuCategory.getMenuShifts(), this.c.getCheckedValuesAsSet()));
        return true;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuCategory menuCategory = (MenuCategory)this.getBean();
            MenuCategoryDAO.getInstance().saveOrUpdate(menuCategory);
            return true;
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
            return false;
        }
    }
}

