/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.ui.views.order.multipart.PizzaPriceTableModel;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;

public class PizzaModifierForm
extends BeanEditor {
    private MenuModifier a;
    private JCheckBox b;
    private JComboBox c;
    private JFormattedTextField d;
    private FixedLengthTextField e;
    private DoubleTextField f;
    private DoubleTextField g;
    private IntegerTextField h;
    private JButton i;
    private JButton j;
    private JTable k;
    private JTabbedPane l;
    private JTable m;
    private PizzaPriceTableModel n;
    private JCheckBox o;
    private JCheckBox p;

    public PizzaModifierForm() throws Exception {
        this(new MenuModifier());
    }

    public PizzaModifierForm(MenuModifier menuModifier) throws Exception {
        this.a = menuModifier;
        MenuModifierDAO.getInstance().initialize(menuModifier);
        this.b();
        this.a();
        this.initData();
        this.setBean(menuModifier);
    }

    public void initData() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        TaxGroupDAO taxGroupDAO = new TaxGroupDAO();
        List<TaxGroup> list = taxGroupDAO.findAll();
        for (TaxGroup taxGroup : list) {
            comboBoxModel.addElement(taxGroup);
        }
        this.c.setModel(comboBoxModel);
    }

    private void a() {
        this.setLayout(new BorderLayout(0, 0));
        this.l = new JTabbedPane();
        this.d = new JFormattedTextField();
        this.e = new FixedLengthTextField();
        this.f = new DoubleTextField();
        this.g = new DoubleTextField();
        this.h = new IntegerTextField();
        this.c = new JComboBox();
        JButton jButton = new JButton();
        this.b = new JCheckBox();
        this.p = new JCheckBox();
        JScrollPane jScrollPane = new JScrollPane();
        this.k = new JTable();
        JLabel jLabel = new JLabel(POSConstants.NAME + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("MenuModifierForm.0"));
        JLabel jLabel3 = new JLabel(Messages.getString("MenuModifierForm.15"));
        JLabel jLabel4 = new JLabel("Tax Group:");
        JLabel jLabel5 = new JLabel();
        this.g.setText("0");
        jLabel5.setText("");
        this.f.setText("0");
        jButton.setText("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierForm.this.a(actionEvent);
            }
        });
        this.b.setText(POSConstants.PRINT_TO_KITCHEN);
        this.b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.b.setMargin(new Insets(0, 0, 0, 0));
        this.p.setText("Sectionwise price");
        this.p.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.p.setMargin(new Insets(0, 0, 0, 0));
        this.o = new JCheckBox("Use fixed price");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.l.addTab(POSConstants.GENERAL, jPanel);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fill", "[60%][40%]", ""));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[90px][grow]", ""));
        transparentPanel2.add((Component)jLabel, "alignx left,aligny center");
        transparentPanel2.add((Component)this.d, "growx,aligny top");
        transparentPanel2.add((Component)jLabel2, "alignx left,aligny center");
        transparentPanel2.add((Component)this.e, "growx");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("wrap 2", "[86px][grow]"));
        jPanel2.add((Component)jLabel4, "alignx left,aligny center,split 2");
        jPanel2.add((Component)jLabel5, "alignx left,aligny center");
        jPanel2.add((Component)this.c, "growx,aligny top,split 2");
        jPanel2.add((Component)jButton, "alignx left,aligny top");
        jPanel2.add((Component)jLabel3, "alignx left,aligny center");
        jPanel2.add((Component)this.h, "growx,aligny top");
        jPanel2.add((Component)this.b, "skip 1,alignx left,aligny top");
        jPanel2.add((Component)this.p, "skip 1");
        transparentPanel.add((Component)transparentPanel2, "grow");
        transparentPanel.add((Component)jPanel2, "grow");
        jPanel.add((Component)transparentPanel, "North");
        JLabel jLabel6 = new JLabel(Messages.getString("MenuModifierForm.1"));
        this.i = new JButton("");
        this.i.setPreferredSize(new Dimension(140, 40));
        JLabel jLabel7 = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.j = new JButton(Messages.getString("MenuModifierForm.29"));
        this.j.setPreferredSize(new Dimension(140, 40));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2"));
        jPanel3.add(jLabel6);
        jPanel3.add(this.i);
        jPanel3.add(jLabel7);
        jPanel3.add(this.j);
        this.l.addTab("Button Style", jPanel3);
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PizzaModifierForm.this, Messages.getString("MenuModifierForm.39"), PizzaModifierForm.this.i.getBackground());
                PizzaModifierForm.this.i.setBackground(color);
                PizzaModifierForm.this.j.setBackground(color);
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PizzaModifierForm.this, Messages.getString("MenuModifierForm.40"), PizzaModifierForm.this.j.getForeground());
                PizzaModifierForm.this.j.setForeground(color);
            }
        });
        this.k.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane.setViewportView(this.k);
        this.a(jPanel);
        this.add(this.l);
    }

    private void b() {
        Multiplier multiplier = MultiplierDAO.getInstance().get("Regular");
        if (multiplier != null && multiplier.isMain().booleanValue()) {
            return;
        }
        if (multiplier == null) {
            multiplier = new Multiplier("Regular");
            multiplier.setRate(0.0);
            multiplier.setSortOrder(0);
            multiplier.setTicketPrefix("");
            multiplier.setDefaultMultiplier(true);
            multiplier.setMain(true);
            MultiplierDAO.getInstance().save(multiplier);
        } else {
            multiplier.setMain(true);
            MultiplierDAO.getInstance().update(multiplier);
        }
    }

    private void a(JPanel jPanel) {
        List<PizzaModifierPrice> list = this.a.getPizzaModifierPriceList();
        list = this.a(list);
        this.m = new JTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                PizzaModifierForm.this.m.editCellAt(n, n2);
                PizzaModifierForm.this.m.transferFocus();
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)PizzaModifierForm.this.m.getCellEditor(n, n2);
                if (n2 != 0) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                }
            }
        };
        this.m.setRowHeight(PosUIManager.getSize(22));
        this.m.setCellSelectionEnabled(true);
        this.m.setSelectionMode(0);
        this.m.setSurrendersFocusOnKeystroke(true);
        this.n = new PizzaPriceTableModel(list, MultiplierDAO.getInstance().findAll());
        this.m.setModel(this.n);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.m);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setPreferredSize(PosUIManager.getSize(600, 250));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel.add(jPanel2);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setAllowNegativeValue(true);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.m.setDefaultEditor(this.m.getColumnClass(1), defaultCellEditor);
    }

    private List<PizzaModifierPrice> a(List<PizzaModifierPrice> list) {
        List<MenuItemSize> list2 = MenuItemSizeDAO.getInstance().findAll();
        ArrayList<MenuItemSize> arrayList = new ArrayList<MenuItemSize>();
        if (list == null || list.isEmpty()) {
            list = new ArrayList<PizzaModifierPrice>();
            for (int i = 0; i < list2.size(); ++i) {
                PizzaModifierPrice pizzaModifierPrice = new PizzaModifierPrice();
                pizzaModifierPrice.setSize(list2.get(i));
                pizzaModifierPrice.setPrice(0.0);
                pizzaModifierPrice.setExtraPrice(0.0);
                list.add(pizzaModifierPrice);
            }
            return list;
        }
        for (PizzaModifierPrice pizzaModifierPrice : list) {
            arrayList.add(pizzaModifierPrice.getSize());
        }
        list2.removeAll(arrayList);
        for (int i = 0; i < list2.size(); ++i) {
            PizzaModifierPrice pizzaModifierPrice;
            pizzaModifierPrice = new PizzaModifierPrice();
            pizzaModifierPrice.setSize(list2.get(i));
            pizzaModifierPrice.setPrice(0.0);
            pizzaModifierPrice.setExtraPrice(0.0);
            list.add(pizzaModifierPrice);
        }
        return list;
    }

    private void a(ActionEvent actionEvent) {
        try {
            TaxForm taxForm = new TaxForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.c.getModel();
            comboBoxModel.setDataList(TaxGroupDAO.getInstance().findAll());
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuModifier menuModifier = (MenuModifier)this.getBean();
            ModifierDAO modifierDAO = new ModifierDAO();
            modifierDAO.saveOrUpdate(menuModifier);
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.SAVE_ERROR, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color color;
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier == null) {
            this.d.setText("");
            this.f.setText("0");
            this.g.setText("0");
            return;
        }
        this.d.setText(menuModifier.getName());
        this.e.setText(menuModifier.getTranslatedName());
        this.f.setText(String.valueOf(menuModifier.getPrice()));
        this.g.setText(String.valueOf(menuModifier.getExtraPrice()));
        this.b.setSelected(menuModifier.isShouldPrintToKitchen());
        this.p.setSelected(menuModifier.isShouldSectionWisePrice());
        this.o.setSelected(menuModifier.isFixedPrice());
        if (menuModifier.getSortOrder() != null) {
            this.h.setText(menuModifier.getSortOrder().toString());
        }
        if (menuModifier.getButtonColor() != null) {
            color = new Color(menuModifier.getButtonColor());
            this.i.setBackground(color);
            this.j.setBackground(color);
        }
        if (menuModifier.getTextColor() != null) {
            color = new Color(menuModifier.getTextColor());
            this.j.setForeground(color);
        }
        if (menuModifier.getTaxGroup() != null) {
            this.c.setSelectedItem(menuModifier.getTaxGroup());
        }
    }

    @Override
    protected boolean updateModel() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        String string = this.d.getText();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        menuModifier.setName(string);
        menuModifier.setPrice(this.f.getDouble());
        menuModifier.setExtraPrice(this.g.getDouble());
        menuModifier.setTaxGroup((TaxGroup)this.c.getSelectedItem());
        menuModifier.setShouldPrintToKitchen(this.b.isSelected());
        menuModifier.setShouldSectionWisePrice(this.p.isSelected());
        menuModifier.setTranslatedName(this.e.getText());
        menuModifier.setButtonColor(this.i.getBackground().getRGB());
        menuModifier.setTextColor(this.j.getForeground().getRGB());
        menuModifier.setSortOrder(this.h.getInteger());
        menuModifier.setFixedPrice(this.o.isSelected());
        menuModifier.setMultiplierPriceList(null);
        menuModifier.setPizzaModifier(true);
        List<PizzaModifierPrice> list = this.n.getRows(menuModifier);
        menuModifier.setPizzaModifierPriceList(list);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier.getId() == null) {
            return Messages.getString("MenuModifierForm.45");
        }
        return Messages.getString("MenuModifierForm.46");
    }
}

