/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Tax;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class TaxForm
extends BeanEditor<Tax> {
    private FixedLengthTextField a = new FixedLengthTextField();
    private DoubleTextField b = new DoubleTextField(10);

    public TaxForm() {
        this(new Tax());
    }

    public TaxForm(Tax tax) {
        this.a();
        this.setBean(tax);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(POSConstants.NAME + ":"));
        this.add((Component)this.a, "grow, wrap");
        this.add(new JLabel(POSConstants.RATE + ":"));
        this.b.setHorizontalAlignment(4);
        this.add((Component)this.b, "split 2,grow");
        this.add((Component)new JLabel("%"), "wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Tax tax = (Tax)this.getBean();
            TaxDAO.getInstance().saveOrUpdate(tax);
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
            return false;
        }
    }

    @Override
    public void createNew() {
        this.setBean(new Tax());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
    }

    @Override
    public void clearFields() {
        this.a.setText("");
        this.b.setText("");
    }

    @Override
    protected void updateView() {
        Tax tax = (Tax)this.getBean();
        if (tax == null) {
            return;
        }
        this.a.setText(tax.getName());
        this.b.setText(String.valueOf(tax.getRate()));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Tax tax = (Tax)this.getBean();
        String string = this.a.getText();
        if (POSUtil.isBlankOrNull(string)) {
            MessageDialog.showError(POSConstants.NAME_REQUIRED);
            return false;
        }
        if (TaxDAO.getInstance().nameExists(tax, string)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "An tax with that name already exists");
            return false;
        }
        Double d = this.b.getDoubleOrZero();
        tax.setName(string);
        tax.setRate(d);
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Tax tax = (Tax)this.getBean();
            if (tax == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected item ?", "Confirm");
            if (n != 0) {
                return false;
            }
            TaxDAO.getInstance().delete(tax);
            this.clearFields();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        Tax tax = (Tax)this.getBean();
        if (tax.getId() == null) {
            return POSConstants.NEW_TAX_RATE;
        }
        return POSConstants.EDIT_TAX_RATE;
    }
}

