/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.BarTabButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.CurrencyUtil;
import com.jidesoft.swing.JideScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class BarTabSelectionView
extends JPanel {
    private Map<Ticket, BarTabButton> a = new HashMap<Ticket, BarTabButton>();
    private ScrollableFlowPanel b;
    private OrderType c;

    public BarTabSelectionView() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        this.b = new ScrollableFlowPanel(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "Bar Tab Tickets", 2, 0);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        JideScrollPane jideScrollPane = new JideScrollPane((Component)this.b, 20, 31);
        jideScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(60, 0));
        jPanel.add((Component)jideScrollPane, "Center");
        this.add((Component)jPanel, "Center");
    }

    private void b() {
        List<Ticket> list = TicketDAO.getInstance().findBarTabOpenTickets(this.c);
        if (list != null && list.size() > 0) {
            for (Ticket ticket : list) {
                BarTabButton barTabButton = new BarTabButton(ticket);
                barTabButton.setPreferredSize(PosUIManager.getSize(157, 138));
                barTabButton.setFont(new Font(barTabButton.getFont().getName(), 1, 24));
                barTabButton.setText(barTabButton.getText());
                barTabButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BarTabSelectionView.this.a(actionEvent);
                    }
                });
                barTabButton.update();
                this.b.add(barTabButton);
                this.a.put(ticket, barTabButton);
                String string = barTabButton.getTicket().getProperty("CUSTOMER_NAME");
                if (string == null) {
                    string = "Guest";
                }
                barTabButton.setText("<html><center>" + string + "<br><h4 style='margin:0px;'>" + ticket.getOwner().getFirstName() + "<br>Chk#" + ticket.getId() + "</h4>" + CurrencyUtil.getCurrencySymbol() + ticket.getTotalAmountWithTips() + "<br><small style='margin:0px;'>Due: " + CurrencyUtil.getCurrencySymbol() + ticket.getDueAmount() + "</small></center></html>");
                if (!ticket.getOwner().getId().equals(Application.getCurrentUser().getId())) {
                    barTabButton.setBackground(new Color(139, 0, 139));
                    barTabButton.setForeground(Color.WHITE);
                }
                barTabButton.setTicket(ticket);
                barTabButton.setUser(ticket.getOwner());
            }
        }
    }

    private boolean a(ActionEvent actionEvent) {
        BarTabButton barTabButton = (BarTabButton)actionEvent.getSource();
        if (!barTabButton.hasUserAccess()) {
            return false;
        }
        this.a(barTabButton.getTicket());
        return true;
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(false);
            window.dispose();
        }
    }

    private boolean a(Ticket ticket) {
        if (ticket == null) {
            return false;
        }
        this.a(false);
        Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        OrderView.getInstance().setCurrentTicket(ticket2);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    public void updateView(OrderType orderType) {
        this.c = orderType;
        this.b.getContentPane().removeAll();
        this.a.clear();
        this.b();
        this.b.revalidate();
        this.b.repaint();
    }
}

