/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardTransactionsReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardTransactionInfoDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class GiftCardTransactionInfoView
extends POSDialog {
    private JXTable a;
    private BeanTableModel<PosTransaction> b;
    private Pattern c;
    private Matcher d;
    private static final String e = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private GiftCardProcessor f;
    private GiftCard g;
    private JXDatePicker h;
    private JXDatePicker i;
    private List<PosTransaction> j;

    public GiftCardTransactionInfoView(GiftCard giftCard, GiftCardProcessor giftCardProcessor) {
        this.f = giftCardProcessor;
        this.g = giftCard;
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Transaction Info");
        jPanel.add((Component)titlePanel, "grow,span");
        JLabel jLabel = new JLabel("From date: ");
        this.h = new JXDatePicker(new Date());
        JLabel jLabel2 = new JLabel("To date: ");
        this.i = new JXDatePicker(new Date());
        JButton jButton = new JButton("Search");
        jPanel.add((Component)jLabel, "split 5");
        jPanel.add((Component)this.h, "gapright 10");
        jPanel.add(jLabel2);
        jPanel.add((Component)this.i, "gapright 10");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardTransactionInfoView.this.b();
            }
        });
        this.add((Component)jPanel, "North");
        this.c = Pattern.compile(e);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        this.b = new BeanTableModel(PosTransaction.class);
        this.b.addColumn("TRANSACTION TIME", "transactionTime");
        this.b.addColumn("AMOUNT", "amount");
        this.a = new JXTable(this.b);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(30);
        this.a.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object instanceof Date) {
                    return super.getTableCellRendererComponent(jTable, DateUtil.formatReportDateAsString((Date)object), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.a.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosTransaction posTransaction;
                if (object instanceof Double && (posTransaction = (PosTransaction)GiftCardTransactionInfoView.this.b.getRow(n)) instanceof GiftCertificateTransaction) {
                    double d = (Double)object;
                    return super.getTableCellRendererComponent(jTable, NumberUtil.formatNumberAcceptNegative(d * -1.0), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        jPanel2.add((Component)new JScrollPane((Component)this.a), "grow");
        this.add((Component)jPanel2, "Center");
        this.resizeColumnWidth((JTable)this.a);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton posButton = new PosButton(Messages.getString("GiftCardTransactionInfoView.9"));
        jPanel3.add((Component)posButton, "grow");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardTransactionInfoView.this.doPrint();
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("GiftCardTransactionInfoView.11"));
        jPanel3.add((Component)posButton2, "grow");
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardTransactionInfoView.this.doEmail();
            }
        });
        jPanel3.add(new PosButton(new CloseDialogAction(this, Messages.getString("GiftCardTransactionInfoView.13"))));
        this.add((Component)jPanel3, "South");
    }

    private void b() {
        Date date;
        Date date2 = this.h.getDate();
        if (date2.after(date = this.i.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        this.j = this.f.getTransactionList(this.g.getCardNumber(), date2, date);
        if (this.j == null || this.j.isEmpty()) {
            this.b.removeAll();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionDialog.15"));
            return;
        }
        this.b.setRows(this.j);
    }

    public void doPrint() {
        JasperPrint jasperPrint = this.reportCreation();
        if (jasperPrint == null) {
            return;
        }
        GiftCardTransactionInfoDialog giftCardTransactionInfoDialog = new GiftCardTransactionInfoDialog(jasperPrint);
        giftCardTransactionInfoDialog.setTitle(Messages.getString("GiftCardTransactionInfoView.14"));
        giftCardTransactionInfoDialog.setDefaultCloseOperation(2);
        giftCardTransactionInfoDialog.setSize(PosUIManager.getSize(900, 600));
        giftCardTransactionInfoDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardTransactionInfoDialog.setVisible(true);
    }

    public void doEmail() {
        String string = PosOptionPane.showInputDialog(Messages.getString("GiftCardTransactionInfoView.15"));
        if (string == null) {
            return;
        }
        this.d = this.c.matcher(string);
        if (this.d.matches()) {
            JasperPrint jasperPrint = this.reportCreation();
            if (jasperPrint == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JRPdfExporter jRPdfExporter = new JRPdfExporter();
            jRPdfExporter.setParameter(JRPdfExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jRPdfExporter.setParameter(JRPdfExporterParameter.OUTPUT_STREAM, (Object)byteArrayOutputStream);
            try {
                jRPdfExporter.exportReport();
            }
            catch (JRException jRException) {
                PosLog.error(this.getClass(), (Exception)((Object)jRException));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, "application/pdf");
            MailService.sendMail(string, Messages.getString("GiftCardTransactionInfoView.0"), Messages.getString("GiftCardTransactionInfoView.18"), "GiftCardTransactionReport.pdf", byteArrayDataSource);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.20"));
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.21"));
            this.doEmail();
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(100);
        arrayList.add(150);
        arrayList.add(180);
        arrayList.add(200);
        arrayList.add(300);
        return arrayList;
    }

    public JasperPrint reportCreation() {
        JasperPrint jasperPrint = null;
        try {
            if (this.j == null || this.j.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No transaction found!");
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ReportUtil.populateRestaurantProperties(hashMap);
            hashMap.put("reportTitle", "Gift card transactions report");
            hashMap.put("cardNo", this.g.getCardNumber() != null ? this.g.getCardNumber() : "");
            hashMap.put("cardOwner", this.g.getOwnerName() != null ? this.g.getOwnerName() : "");
            hashMap.put("endBalance", this.g.getBalance() != null ? NumberUtil.formatNumber(this.g.getBalance()) : "");
            hashMap.put("reportTime", ReportService.formatFullDate(new Date()));
            hashMap.put("terminalName", String.valueOf(TerminalConfig.getTerminalId()));
            hashMap.put("currency", CurrencyUtil.getCurrencySymbol());
            hashMap.put("activeDate", ReportService.formatFullDate(this.g.getActivationDate()));
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_transaction_report"));
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new GiftCardTransactionsReportModel(this.j)));
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception.getMessage());
        }
        return jasperPrint;
    }
}

