/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MenuCategorySelectionView
extends JPanel {
    private JComboBox a;
    private JXTable b;
    private BeanTableModel<MenuCategory> c;
    private JTextField d;
    private MenuCategory e;
    private PosButton f;
    private PosButton g;
    private OrderType h;
    private JLabel i = new JLabel();
    private JLabel j;
    private JButton k;
    private JPanel l;
    private Map<String, MenuCategory> m = new HashMap<String, MenuCategory>();
    private JCheckBox n;
    private JCheckBox o;
    private JLabel p;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;

    public MenuCategorySelectionView(List<MenuCategory> list) {
        this.a();
        this.c.setCurrentRowIndex(0);
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MenuCategorySelectionView.this.o.setEnabled(true);
                MenuCategorySelectionView.this.c.setCurrentRowIndex(0);
                MenuCategorySelectionView.this.setSelectedOrderTypes(MenuCategorySelectionView.this.a.getSelectedItem());
            }
        });
        this.setMenuCategories(list);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new BeanTableModel(MenuCategory.class);
        this.c.addColumn("", "visible");
        this.c.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.c.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.c.setPageSize(10);
        this.b = new JXTable(this.c);
        this.b.setSelectionMode(2);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setRowHeight(PosUIManager.getSize(40));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuCategorySelectionView.this.j();
                } else {
                    MenuCategorySelectionView.this.m();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane jScrollPane = new JScrollPane((Component)this.b);
        jScrollPane.setPreferredSize(PosUIManager.getSize(500, 250));
        jPanel.add(jScrollPane);
        jPanel.add((Component)this.c(), "North");
        this.add(jPanel);
        this.resizeColumnWidth((JTable)this.b);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        jPanel2.add((Component)this.h(), "left,split 2");
        this.n = new JCheckBox("Show selected");
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategorySelectionView.this.b();
            }
        });
        jPanel2.add(this.n);
        jPanel2.add((Component)this.i, "split 3,center");
        this.g = new PosButton();
        this.g.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        jPanel2.add((Component)this.g, "center");
        PosButton posButton = new PosButton();
        posButton.setBorder(null);
        posButton.setOpaque(false);
        posButton.setContentAreaFilled(false);
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.f = new PosButton();
        this.f.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        jPanel2.add(this.f);
        jPanel2.add((Component)new JSeparator(), "newline,span,grow");
        jPanel.add((Component)jPanel2, "South");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object == MenuCategorySelectionView.this.g) {
                        MenuCategorySelectionView.this.l();
                    } else if (object == MenuCategorySelectionView.this.f) {
                        MenuCategorySelectionView.this.k();
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        this.g.addActionListener(actionListener);
        this.f.addActionListener(actionListener);
        this.f.setEnabled(false);
        this.g.setEnabled(false);
    }

    private void b() {
        if (this.n.isSelected()) {
            this.c.setRows(new ArrayList<MenuCategory>(this.m.values()));
            this.f();
            this.n.setText("Show Selected (" + this.m.values().size() + ")");
            this.i.setText("");
            this.g.setEnabled(false);
            this.f.setEnabled(false);
            this.a.setEnabled(false);
            this.b.repaint();
        } else {
            if (this.a.getSelectedItem() != null) {
                this.d();
            }
            this.a.setEnabled(true);
        }
    }

    private JPanel c() {
        this.l = new JPanel();
        this.l.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.j = new JLabel(POSConstants.NAME + ":");
        this.d = new JTextField(15);
        this.k = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.l.add((Component)this.j, "align label,split 5");
        this.l.add((Component)this.d, "growx");
        this.o = new JCheckBox("Select All");
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategorySelectionView.this.e();
            }
        });
        this.a = new JComboBox();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("<All>");
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        arrayList.addAll(list);
        ComboBoxModel comboBoxModel = new ComboBoxModel(arrayList);
        this.a.setModel(comboBoxModel);
        this.a.setSelectedItem("<All>");
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MenuCategorySelectionView.this.d();
            }
        });
        this.l.add(this.k);
        this.p = new JLabel("Ordertype");
        this.l.add((Component)this.p, "split 2,right");
        this.l.add((Component)this.a, "wrap");
        this.l.add((Component)this.o, "left");
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategorySelectionView.this.d();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategorySelectionView.this.d();
            }
        });
        return this.l;
    }

    private void d() {
        this.h = this.a.getSelectedItem() instanceof OrderType ? (OrderType)this.a.getSelectedItem() : null;
        this.c.setCurrentRowIndex(0);
        MenuCategoryDAO.getInstance().findCategories(this.c, true, MenuCategory.PROP_NAME);
        this.n();
        this.g();
        this.f();
        this.b.repaint();
        this.n.setSelected(false);
    }

    private void e() {
        Object object = this.a.getSelectedItem();
        if (object instanceof OrderType) {
            List<MenuCategory> list = this.c.getRows();
            if (list != null && list.size() > 0) {
                for (MenuCategory menuCategory : list) {
                    if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuCategory.getId())) continue;
                    menuCategory.setVisible(this.o.isSelected());
                    if (menuCategory.isVisible().booleanValue()) {
                        this.m.put(menuCategory.getId(), menuCategory);
                        continue;
                    }
                    this.m.remove(menuCategory.getId());
                }
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No items found!");
                this.o.setSelected(false);
            }
        } else {
            List<MenuCategory> list = this.c.getRows();
            if (list == null) {
                return;
            }
            for (MenuCategory menuCategory : list) {
                if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuCategory.getId())) continue;
                menuCategory.setVisible(this.o.isSelected());
                if (menuCategory.isVisible().booleanValue()) {
                    this.m.put(menuCategory.getId(), menuCategory);
                } else {
                    this.m.remove(menuCategory.getId());
                }
                this.n.setText("Show Selected (" + this.m.values().size() + ")");
                this.b.repaint();
            }
        }
        this.b.repaint();
    }

    private void f() {
        List<MenuCategory> list = this.c.getRows();
        if (list == null) {
            return;
        }
        Iterator<MenuCategory> iterator = list.iterator();
        while (iterator.hasNext()) {
            MenuCategory menuCategory;
            MenuCategory menuCategory2 = this.m.get((menuCategory = iterator.next()).getId());
            menuCategory.setVisible(menuCategory2 != null);
        }
    }

    private void g() {
        int n;
        int n2 = this.c.getCurrentRowIndex() + 1;
        int n3 = this.c.getNextRowIndex();
        if (n3 > (n = this.c.getNumRows())) {
            n3 = n;
        }
        this.i.setText(String.format("Showing %s to %s of %s", n2, n3, n));
        this.g.setEnabled(this.c.hasPrevious());
        this.f.setEnabled(this.c.hasNext());
        if (this.c.getRowCount() > 0) {
            this.b.setRowSelectionInterval(0, 0);
        }
        this.n.setText("Show Selected (" + this.m.values().size() + ")");
    }

    private TransparentPanel h() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        jButton2.setText(POSConstants.ADD);
        jButton.setText(POSConstants.EDIT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategorySelectionView.this.j();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuCategory menuCategory = new MenuCategory();
                    MenuCategoryForm menuCategoryForm = new MenuCategoryForm(menuCategory);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuCategory menuCategory2 = (MenuCategory)menuCategoryForm.getBean();
                    MenuCategorySelectionView.this.c.addRow(menuCategory2);
                    MenuCategorySelectionView.this.c.setNumRows(MenuCategorySelectionView.this.c.getNumRows() + 1);
                    MenuCategorySelectionView.this.g();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.i().get(i));
        }
    }

    private List i() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(70);
        arrayList.add(250);
        arrayList.add(70);
        return arrayList;
    }

    private void j() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuCategory menuCategory = this.c.getRow(n);
            MenuCategoryDAO.getInstance().initialize(menuCategory);
            this.c.setRow(n, menuCategory);
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm(menuCategory);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public List<MenuCategory> getSelectedMenuCategoryList() {
        return new ArrayList<MenuCategory>(this.m.values());
    }

    public void setMenuCategories(List<MenuCategory> list) {
        if (list != null) {
            for (MenuCategory menuCategory : list) {
                this.m.put(menuCategory.getId(), menuCategory);
                this.c.addRow(menuCategory);
            }
        }
    }

    public void setParentMenuItem(MenuCategory menuCategory, boolean bl) {
        this.e = menuCategory;
        if (bl) {
            this.n.setSelected(true);
            this.b();
        } else {
            this.d();
        }
    }

    private void k() {
        this.c.setCurrentRowIndex(this.c.getNextRowIndex());
        MenuCategoryDAO.getInstance().findCategories(this.c, true, MenuCategory.PROP_NAME);
        this.n();
        this.g();
        this.f();
        this.b.repaint();
        this.n.setSelected(false);
    }

    private void l() {
        this.c.setCurrentRowIndex(this.c.getPreviousRowIndex());
        MenuCategoryDAO.getInstance().findCategories(this.c, true, MenuCategory.PROP_NAME);
        this.n();
        this.g();
        this.f();
        this.b.repaint();
        this.n.setSelected(false);
    }

    public void setSelectedOrderTypes(Object object) {
        this.h = object instanceof OrderType ? (OrderType)object : null;
        this.d();
    }

    private void m() {
        if (this.b.getSelectedRow() < 0) {
            return;
        }
        int n = this.b.getSelectedRow();
        n = this.b.convertRowIndexToModel(n);
        MenuCategory menuCategory = this.c.getRow(n);
        if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuCategory.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Parent item cannot be selected");
            return;
        }
        menuCategory.setVisible(menuCategory.isVisible() == false);
        if (menuCategory.isVisible().booleanValue()) {
            this.m.put(menuCategory.getId(), menuCategory);
        } else {
            this.m.remove(menuCategory.getId());
        }
        this.n.setText("Show Selected (" + this.m.values().size() + ")");
        this.b.repaint();
    }

    private void n() {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        List<MenuCategory> list = this.c.getRows();
        for (MenuCategory menuCategory : list) {
            if (!this.m.containsKey(menuCategory.getId())) continue;
            arrayList.add(menuCategory.isVisible());
        }
        if (arrayList.size() != 0 && !arrayList.contains(false)) {
            this.o.setSelected(true);
        } else {
            this.o.setSelected(false);
        }
    }

    public BeanTableModel<MenuCategory> getModel() {
        return this.c;
    }

    public int getSelectedRow() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return this.b.convertRowIndexToModel(n);
    }

    public void repaintTable() {
        this.b.repaint();
    }

    public void setSelectionMode(int n) {
        this.n.setVisible(n == 1);
        this.o.setVisible(n == 1);
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.b.getColumnModel();
        tableColumnModelExt.getColumnExt(0).setVisible(n == 1);
        this.d();
    }

    public void setSelectedOrdertype(OrderType orderType) {
        if (orderType != null && orderType.getId().equals(orderType.getId())) {
            return;
        }
        this.h = orderType;
        this.a.setSelectedItem(orderType);
        this.d();
    }

    public void setEnableSearch(boolean bl) {
        this.d.setVisible(bl);
        this.j.setVisible(bl);
        this.k.setVisible(bl);
    }
}

