/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.ui.util.StreamUtils;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.NumberUtil;
import com.mercurypay.ws.sdk.MercuryResponse;
import com.mercurypay.ws.sdk.MercuryWebRequest;
import java.io.IOException;

public class MercuryPayProcessor
implements CardProcessor {
    public static final String $merchantId = "$merchantId";
    public static final String $laneId = "$laneId";
    public static final String $invoiceNo = "$invoiceNo";
    public static final String $encryptedBlock = "$encryptedBlock";
    public static final String $encryptedKey = "$encryptedKey";
    public static final String $amount = "$amount";
    public static final String $authorizeAmount = "$authorizeAmount";
    public static final String $terminalName = "$terminalName";
    public static final String $shiftName = "$shiftName";
    public static final String $operatorId = "$operatorId";
    public static final String $tranCode = "$tranCode";
    public static final String $refNo = "$refNo";

    @Override
    public void preAuth(PosTransaction posTransaction) throws Exception {
        Ticket ticket = posTransaction.getTicket();
        if (ticket.getOrderType().name() == "BAR_TAB" && ticket.hasProperty("AcqRefData")) {
            this.captureAuthAmount(posTransaction);
            return;
        }
        String string = this.a(ticket, posTransaction.getCardTrack(), posTransaction.getAmount());
        MercuryResponse mercuryResponse = new MercuryResponse(string);
        if (!mercuryResponse.isApproved()) {
            throw new PosException(Messages.getString("MercuryPayProcessor.13"));
        }
        PosLog.info(this.getClass(), string);
        posTransaction.setCardTransactionId(mercuryResponse.getTransactionId());
        posTransaction.setCardAuthCode(mercuryResponse.getAuthCode());
        posTransaction.addProperty("AcqRefData", mercuryResponse.getAcqRefData());
    }

    private String a(Ticket ticket, String string, double d) throws IOException, Exception {
        String string2 = StreamUtils.toString(MercuryPayProcessor.class.getResourceAsStream("/com/mercurypay/ws/sdk/mercuryAuth.xml"));
        String[] stringArray = string.split("\\|");
        String string3 = "01";
        String string4 = "PreAuth";
        String string5 = String.valueOf(ticket.getId());
        String string6 = NumberUtil.formatNumber(d);
        String string7 = stringArray[3];
        String string8 = stringArray[9];
        string2 = string2.replace($merchantId, CardConfig.getMerchantAccount());
        string2 = string2.replace($laneId, string3);
        string2 = string2.replace($tranCode, string4);
        string2 = string2.replace($invoiceNo, string5);
        string2 = string2.replace($refNo, string5);
        string2 = string2.replace($encryptedBlock, string7);
        string2 = string2.replace($encryptedKey, string8);
        string2 = string2.replace($amount, string6);
        string2 = string2.replace($authorizeAmount, string6);
        PosLog.info(this.getClass(), string2);
        MercuryWebRequest mercuryWebRequest = new MercuryWebRequest("https://w1.mercurydev.net/ws/ws.asmx");
        mercuryWebRequest.addParameter("tran", string2);
        mercuryWebRequest.addParameter("pw", CardConfig.getMerchantPass());
        mercuryWebRequest.setWebMethodName("CreditTransaction");
        mercuryWebRequest.setTimeout(10);
        String string9 = mercuryWebRequest.sendRequest();
        return string9;
    }

    @Override
    public void captureAuthAmount(PosTransaction posTransaction) throws Exception {
        String string = StreamUtils.toString(MercuryPayProcessor.class.getResourceAsStream("/com/mercurypay/ws/sdk/mercuryPreAuthCapture.xml"));
        Ticket ticket = posTransaction.getTicket();
        String string2 = "01";
        String string3 = String.valueOf(ticket.getId());
        String string4 = String.valueOf(posTransaction.getAmount());
        string = string.replace($merchantId, CardConfig.getMerchantAccount());
        string = string.replace($laneId, string2);
        string = string.replace($invoiceNo, string3);
        string = string.replace($refNo, string3);
        string = string.replace($amount, string4);
        string = string.replace($authorizeAmount, string4);
        string = string.replace("$gratuity", String.valueOf(posTransaction.getTipsAmount()));
        string = string.replace("$recordNo", posTransaction.getCardTransactionId());
        string = string.replace("$authCode", posTransaction.getCardAuthCode());
        string = string.replace("$AcqRefData", posTransaction.getProperty("AcqRefData"));
        MercuryWebRequest mercuryWebRequest = new MercuryWebRequest("https://w1.mercurydev.net/ws/ws.asmx");
        mercuryWebRequest.addParameter("tran", string);
        mercuryWebRequest.addParameter("pw", CardConfig.getMerchantPass());
        mercuryWebRequest.setWebMethodName("CreditTransaction");
        mercuryWebRequest.setTimeout(10);
        String string5 = mercuryWebRequest.sendRequest();
        MercuryResponse mercuryResponse = new MercuryResponse(string5);
        if (!mercuryResponse.isApproved()) {
            throw new PosException("Error authorizing transaction.");
        }
        posTransaction.setCardTransactionId(mercuryResponse.getTransactionId());
        posTransaction.setCardAuthCode(mercuryResponse.getAuthCode());
    }

    @Override
    public void chargeAmount(PosTransaction posTransaction) throws Exception {
        throw new PosException("Not supported.");
    }

    @Override
    public void voidTransaction(PosTransaction posTransaction) throws Exception {
        throw new PosException("Not supported.");
    }

    @Override
    public String getCardInformationForReceipt(PosTransaction posTransaction) {
        return null;
    }

    @Override
    public void cancelTransaction() {
        throw new PosException("Not supported.");
    }

    @Override
    public void refundTransaction(PosTransaction posTransaction, double d) throws Exception {
        throw new PosException("Not supported.");
    }
}

