/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.PosException;
import com.floreantpos.model.Address;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.beanutils.PropertyUtils;

public class CloudDataUploader {
    private ProgressObserver a;
    private PosWebService b;

    public void uploadData(ProgressObserver progressObserver) throws Exception {
        this.a = progressObserver;
        this.b = PosWebService.get();
        int n = 0;
        this.a.progress(n, "Uploading outlets...");
        this.f();
        this.a.progress(n++, "Uploading order types...");
        this.i();
        this.a.progress(n++, "Uploading departments...");
        this.j();
        this.a.progress(n++, "Uploading user types...");
        this.k();
        this.a.progress(n++, "Uploading users...");
        this.l();
        this.a.progress(n++, "Uploading taxes...");
        this.g();
        this.a.progress(n++, "Uploading customers...");
        this.h();
        this.a.progress(n++, "Uploading menu modifiers...");
        this.c();
        this.a.progress(n++, "Uploading modifier groups...");
        this.b();
        this.a.progress(n++, "Uploading menu categories...");
        this.e();
        this.a.progress(n++, "Uploading menu groups...");
        this.d();
        this.a.progress(n++, "Uploading menu items...");
        this.a();
        this.a.progress(n++, "Uploading store session data...");
        this.b.uploadStoreSessionData();
        this.a.progress(100, "Upload complete");
    }

    private void a() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuItem> list = MenuItemDAO.getInstance().findAllUnSyncMenuItems();
        if (list != null && !list.isEmpty()) {
            for (MenuItem object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<MenuItem>>(list){}, "menuitem");
                MenuItemDAO.getInstance().updateMenuItemSync(arrayList, Boolean.TRUE);
            }
            catch (Exception exception) {
                String string = "Uploading menuitems failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuItem menuItem) {
        MenuItemDAO.getInstance().initialize(menuItem);
        String string = menuItem.getParentMenuItemId();
        menuItem.setStockUnits(null);
        menuItem.setComboGroups(null);
        menuItem.setComboItems(null);
        menuItem.setParentMenuItem(null);
        menuItem.setParentMenuItemId(string);
        menuItem.setPizzaPriceList(null);
        menuItem.setAttributes(null);
        menuItem.setMenuItemModiferSpecs(null);
        menuItem.setPrinterGroup(null);
        menuItem.setVariants(null);
        MenuGroup menuGroup = menuItem.getParent();
        if (menuGroup != null) {
            MenuCategory menuCategory = menuGroup.getParent();
            MenuCategory menuCategory2 = new MenuCategory();
            if (menuCategory != null) {
                try {
                    PropertyUtils.copyProperties((Object)menuCategory2, (Object)menuCategory);
                    menuCategory2.setDepartments(null);
                    menuCategory2.setOrderTypes(null);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
            menuGroup.setParent(menuCategory2);
        }
    }

    private void b() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ModifierGroup> list = ModifierGroupDAO.getInstance().findAllUnSyncModifierGroup();
        if (list != null && !list.isEmpty()) {
            for (ModifierGroup object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<ModifierGroup>>(list){}, "modifiergroup");
                ModifierGroupDAO.getInstance().updateModifierGroupSync(arrayList, Boolean.TRUE);
            }
            catch (Exception exception) {
                String string = "Uploading modifier groups failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(ModifierGroup modifierGroup) {
        modifierGroup.setModifiers(null);
    }

    private void c() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuModifier> list = MenuModifierDAO.getInstance().findAllUnSyncMenuModifier();
        if (list != null && !list.isEmpty()) {
            for (MenuModifier object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<MenuModifier>>(list){}, "modifier");
                MenuModifierDAO.getInstance().updateMenuModifierSync(arrayList, Boolean.TRUE);
            }
            catch (Exception exception) {
                String string = "Uploading menu modifiers failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuModifier menuModifier) {
        menuModifier.setMultiplierPriceList(null);
        menuModifier.setMenuItemModifierGroup(null);
        menuModifier.setPizzaModifierPriceList(null);
        menuModifier.setModifierGroups(null);
    }

    private void d() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAllUnSyncMenuGroup();
        if (list != null && !list.isEmpty()) {
            for (MenuGroup object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<MenuGroup>>(list){}, "menugroup");
                MenuGroupDAO.getInstance().updateMenuGroupSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading menu groups failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuGroup menuGroup) {
        menuGroup.setMenuPages(null);
        MenuCategory menuCategory = menuGroup.getParent();
        menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
        if (menuCategory != null) {
            this.a(menuCategory);
        }
    }

    private void e() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAllUnSyncMenuCategory();
        if (list != null && !list.isEmpty()) {
            for (MenuCategory object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<MenuCategory>>(list){}, "menucategory");
                MenuCategoryDAO.getInstance().updateMenuCategoriesSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading menu categories failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuCategory menuCategory) {
        menuCategory.setDepartments(null);
        menuCategory.setMenuGroups(null);
        menuCategory.setMenuShifts(null);
        menuCategory.setOrderTypes(null);
        menuCategory.setTerminalTypes(null);
    }

    private void f() {
        Object object;
        ArrayList<Outlet> arrayList = new ArrayList<Outlet>();
        ArrayList<Address> arrayList2 = new ArrayList<Address>();
        Store store = StoreDAO.getRestaurant();
        Outlet outlet = OutletDAO.getInstance().get(String.valueOf(store.getUniqueId()));
        if (store.getAddress() == null) {
            throw new PosException("Address cannot be empty. Please provide store address and try again");
        }
        String string = store.getAddress().getId();
        Address address = AddressDAO.getInstance().findAddressById(string);
        if (outlet == null) {
            outlet = new Outlet();
            outlet.setId(String.valueOf(store.getUniqueId()));
            outlet.setName(store.getOutletName());
            OutletDAO.getInstance().save(outlet);
            List<Terminal> list = TerminalDAO.getInstance().findAll();
            if (list != null) {
                for (Terminal terminal : list) {
                    terminal.setOutlet(outlet);
                    TerminalDAO.getInstance().saveOrUpdate(terminal);
                }
            }
        } else {
            OutletDAO.getInstance().initialize(outlet);
            outlet.setId(String.valueOf(store.getUniqueId()));
            outlet.setName(store.getOutletName());
        }
        arrayList2.add(address);
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            try {
                PosWebService.get().uploadData((GenericEntity)new GenericEntity<List<Address>>(arrayList2){}, "address");
            }
            catch (Exception exception) {
                object = "Uploading address failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), (String)object, exception);
            }
        }
        outlet.setAddressId(address.getId());
        outlet.setDepartments(null);
        arrayList.add(outlet);
        if (arrayList != null && !arrayList.isEmpty()) {
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<Outlet>>(arrayList){}, "outlet");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = "Uploading outlet failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), (String)object, exception);
            }
        }
    }

    private void g() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Tax> list2 = TaxDAO.getInstance().findAllUnSyncTax();
        if (list2 != null && !list2.isEmpty()) {
            for (Tax list3 : list2) {
                arrayList.add(list3.getId());
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<Tax>>(list2){}, "tax");
                TaxDAO.getInstance().updateTaxSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading tax failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAllUnSyncTaxGroup();
        if (list != null && !list.isEmpty()) {
            for (TaxGroup taxGroup : list) {
                arrayList2.add(taxGroup.getId());
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<TaxGroup>>(list){}, "taxgroup");
                TaxGroupDAO.getInstance().updateTaxGroupSync(arrayList2, true);
            }
            catch (Exception exception) {
                String string = "Uploading tax group failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void h() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Customer> list = CustomerDAO.getInstance().findAllUnSyncCustomer();
        if (list != null && !list.isEmpty()) {
            for (Customer object : list) {
                arrayList.add(object.getId());
                CloudDataUploader.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<Customer>>(list){}, "customer");
                CustomerDAO.getInstance().updateCustomerSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading customer failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void i() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<OrderType> list = OrderTypeDAO.getInstance().findAllUnSyncOrderType();
        if (list != null && !list.isEmpty()) {
            for (OrderType object : list) {
                arrayList.add(object.getId());
                CloudDataUploader.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype");
                OrderTypeDAO.getInstance().updateOrderTypeSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading OrderType failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void j() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Department> list = DepartmentDAO.getInstance().findAllUnSyncDepartment();
        if (list != null && !list.isEmpty()) {
            for (Department object : list) {
                arrayList.add(object.getId());
                CloudDataUploader.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<Department>>(list){}, "departments");
                DepartmentDAO.getInstance().updateDepartmentSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading departments failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void k() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<UserType> list = UserTypeDAO.getInstance().findAllUnSyncUserType();
        if (list != null && !list.isEmpty()) {
            for (UserType object : list) {
                arrayList.add(object.getId());
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<UserType>>(list){}, "usertypes");
                UserTypeDAO.getInstance().updateUserTypeSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading User type failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void l() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<User> list = UserDAO.getInstance().findAllUnSyncUser();
        if (list != null && !list.isEmpty()) {
            for (User object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                this.b.uploadData((GenericEntity)new GenericEntity<List<User>>(list){}, "users");
                UserDAO.getInstance().updateUserSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading user failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(User user) {
        if (user == null) {
            return;
        }
        user.setCurrentCashDrawer(null);
        user.setLinkedUser(null);
    }

    private static void a(Department department) {
        if (department == null) {
            return;
        }
        department.setOrderTypes(null);
        department.setOutlets(null);
    }

    private static void a(OrderType orderType) {
        if (orderType == null) {
            return;
        }
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    private static void a(Customer customer) {
        if (customer == null) {
            return;
        }
        customer.setDeliveryAddresses(null);
        customer.setDeliveryInstructions(null);
        customer.setCustomerGroup(null);
    }

    public static CloudDataUploader get() {
        return new CloudDataUploader();
    }
}

