/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Database;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudConfigurationDialog;
import com.floreantpos.webservice.CloudDataDownloader;
import com.floreantpos.webservice.CloudDataUploader;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.PosResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CloudSyncDialog
extends POSDialog
implements ProgressObserver,
ActionListener {
    private static final Color a = new Color(126, 180, 69);
    private static final String b = "CD";
    private static final String c = "UD";
    private static final String d = "SAVE";
    private static final String e = "cancel";
    private static final String f = "test";
    private PosButton g;
    private PosButton h;
    private JButton i;
    private JComboBox j;
    private JLabel k;
    private boolean l;
    private JLabel m;
    private JProgressBar n;
    private JLabel o;
    private JTabbedPane p;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getBackOfficeWindow());
        this.b();
    }

    @Override
    public void setVisible(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudSyncDialog.this.a(false);
            }
        });
        super.setVisible(bl);
    }

    @Override
    protected void initUI() {
        this.p = new JTabbedPane();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 5 20 20 20,fill,hidemode 3"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("fill"));
        jPanel.add((Component)jPanel2, "growx,span");
        this.p.addTab("Download/Upload", jPanel);
        this.m = new JLabel();
        this.m.setFont(new Font("Arial", 1, 20));
        this.n = new JProgressBar();
        this.n.setValue(0);
        this.n.setMaximum(100);
        this.n.setStringPainted(true);
        this.n.setPreferredSize(new Dimension(0, 30));
        this.o = new JLabel("Click download/upload to sync with server.");
        this.n.setVisible(false);
        this.i = new JButton(Messages.getString("DatabaseConfigurationDialog.28").toUpperCase());
        this.i.setActionCommand(e);
        jPanel.add((Component)new JSeparator(), "newline,grow");
        jPanel.add((Component)this.o, "right,newline,split 2");
        jPanel.add((Component)this.n, "grow");
        jPanel.add((Component)new JLabel("Connection Status:"), "newline,split 3");
        jPanel.add(this.m);
        this.k = new JLabel("Store Id:");
        this.k.setFont(new Font("Arial", 1, 16));
        this.k.setForeground(Color.GRAY);
        jPanel.add((Component)this.m, "grow");
        jPanel.add((Component)this.k, "right,grow");
        jPanel.add((Component)new JSeparator(), "newline,grow");
        jPanel.add((Component)this.i, "newline,center,span");
        this.j = new JComboBox<Database>(Database.values());
        String string = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)string)) {
            this.j.setSelectedItem((Object)Database.getByProviderName(string));
        }
        this.updateTitle();
        this.g = new PosButton("UPLOAD");
        this.g.setActionCommand(b);
        this.h = new PosButton("DOWNLOAD");
        this.h.setActionCommand(c);
        this.h.setIcon(IconFactory.getIcon("/ui_icons/", "page-down.png"));
        this.g.setIcon(IconFactory.getIcon("/ui_icons/", "page-up.png"));
        JButton jButton = new JButton(IconFactory.getIcon("/ui_icons/", "backoffice.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudConfigurationDialog cloudConfigurationDialog = new CloudConfigurationDialog();
                cloudConfigurationDialog.setSize(PosUIManager.getSize(650, 500));
                cloudConfigurationDialog.open();
                boolean bl = CloudSyncDialog.this.a(false);
                if (bl && !cloudConfigurationDialog.isCanceled()) {
                    CloudSyncDialog.this.a();
                }
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudSyncDialog.this.a();
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final Worker worker = new Worker();
                worker.setActionCommand(CloudSyncDialog.b);
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                            CloudSyncDialog.this.n.setValue((Integer)propertyChangeEvent.getNewValue());
                        } else if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                worker.get();
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                });
                worker.execute();
            }
        });
        jPanel2.add((Component)jButton, "right,wrap");
        jPanel2.add((Component)this.h, "split 2,gaptop 20,center");
        jPanel2.add(this.g);
        this.add(this.p);
    }

    private void a() {
        final Worker worker = new Worker();
        worker.setActionCommand(c);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                    CloudSyncDialog.this.n.setValue((Integer)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                    try {
                        worker.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        worker.execute();
    }

    public void startUploading() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.o.setForeground(Color.BLUE);
            this.n.setMaximum(13);
            this.n.setVisible(true);
            CloudDataUploader.get().uploadData(this);
            this.o.setForeground(a);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            this.o.setForeground(Color.RED);
            this.o.setText("Upload failed.");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Upload Failed\n" + exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.n.setValue(0);
            this.n.setVisible(false);
        }
    }

    private void b() {
        this.g.addActionListener(this);
        this.i.addActionListener(this);
        this.h.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (e.equalsIgnoreCase(string)) {
                this.dispose();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (f.equalsIgnoreCase(string)) {
                this.l = this.a(false);
                if (!this.l) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                } else {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                }
            } else if (d.equalsIgnoreCase(string)) {
                this.a(true);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Successfully saved.");
                this.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            POSMessageDialog.showMessage(this, exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void updateTitle() {
        super.setTitle("Sync with cloud");
    }

    private boolean a(boolean bl) {
        PosResponse posResponse = null;
        try {
            posResponse = PosWebService.get().checkConnection();
        }
        catch (Exception exception) {
            this.m.setText("Connection failed");
            this.m.setForeground(Color.RED);
        }
        if (posResponse != null) {
            if (posResponse.getResponseCode() == 200) {
                System.out.println("Connected");
                this.m.setText("Connected");
                this.m.setForeground(a);
                this.k.setText("Store Id: " + posResponse.getStoreId());
                return true;
            }
            this.m.setText(posResponse.getMsg());
            this.m.setForeground(Color.RED);
        }
        return false;
    }

    private void c() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.n.setMaximum(12);
                this.n.setVisible(true);
                this.n.setValue(0);
                this.o.setForeground(Color.BLUE);
                CloudDataDownloader.get().downloadAllData(this);
                this.n.setValue(100);
                this.o.setText("Download complete");
                this.o.setForeground(a);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.o.setText("Download failed .");
                this.o.setForeground(Color.RED);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            POSMessageDialog.showError("Download Failed");
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static CloudSyncDialog show(Frame frame) {
        CloudSyncDialog cloudSyncDialog = new CloudSyncDialog();
        cloudSyncDialog.setSize(PosUIManager.getSize(500, 350));
        cloudSyncDialog.open();
        return cloudSyncDialog;
    }

    @Override
    public void progress(int n) {
        this.n.setValue(n);
    }

    @Override
    public void progress(String string) {
        this.o.setText(string);
    }

    @Override
    public void progress(int n, String string) {
        this.n.setValue(n);
        this.o.setText(string);
    }

    @Override
    public Component getParentComponent() {
        return this;
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String a;

        public void setActionCommand(String string) {
            this.a = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            CloudSyncDialog.this.h.setEnabled(false);
            CloudSyncDialog.this.g.setEnabled(false);
            CloudSyncDialog.this.i.setEnabled(false);
            if (this.a.equals(CloudSyncDialog.c)) {
                CloudSyncDialog.this.c();
            } else if (this.a.equals(CloudSyncDialog.b)) {
                CloudSyncDialog.this.startUploading();
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            CloudSyncDialog.this.n.setVisible(false);
            CloudSyncDialog.this.h.setEnabled(true);
            CloudSyncDialog.this.g.setEnabled(true);
            CloudSyncDialog.this.i.setEnabled(true);
        }
    }
}

