/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.PosResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hibernate.Hibernate;

public class PosWebService {
    public List getDataList(String string) throws Exception {
        ClientResponse clientResponse = this.a("/entity", null);
        return (List)clientResponse.getEntity((GenericType)new GenericType<List>(){});
    }

    public List<OrderType> getOrderTypes() throws Exception {
        ClientResponse clientResponse = this.a("/ordertype", this.a(OrderType.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<OrderType>>(){});
    }

    public List<Outlet> getOutlets() throws Exception {
        ClientResponse clientResponse = this.a("/outlet", this.a(Outlet.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Outlet>>(){});
    }

    public List<SalesArea> getSalesArea() throws Exception {
        ClientResponse clientResponse = this.a("/salesarea", this.a(SalesArea.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<SalesArea>>(){});
    }

    public List<Department> getDepartments() throws Exception {
        ClientResponse clientResponse = this.a("/department", this.a(Department.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Department>>(){});
    }

    public List<TerminalType> getTerminalTypes() throws Exception {
        ClientResponse clientResponse = this.a("/terminaltype", this.a(TerminalType.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<TerminalType>>(){});
    }

    public List<Terminal> getTerminals() throws Exception {
        ClientResponse clientResponse = this.a("/terminal", this.a(Terminal.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Terminal>>(){});
    }

    public List<Currency> getCurrencies() throws Exception {
        ClientResponse clientResponse = this.a("/currency", this.a(Currency.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Currency>>(){});
    }

    public List<UserPermission> getUserPermissions() throws Exception {
        ClientResponse clientResponse = this.a("/userpermission", this.a(UserPermission.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<UserPermission>>(){});
    }

    public List<UserType> getUserTypes() throws Exception {
        ClientResponse clientResponse = this.a("/usertype", this.a(UserType.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<UserType>>(){});
    }

    public List<User> getUsers() throws Exception {
        ClientResponse clientResponse = this.a("/user", this.a(User.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<Tax> getTaxes() throws Exception {
        ClientResponse clientResponse = this.a("/tax", this.a(Tax.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Tax>>(){});
    }

    public List<TaxGroup> getTaxGroups() throws Exception {
        ClientResponse clientResponse = this.a("/taxgroup", this.a(TaxGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<TaxGroup>>(){});
    }

    public List<MenuCategory> getMenuCategories() throws Exception {
        ClientResponse clientResponse = this.a("/MenuCategory", this.a(MenuCategory.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuCategory>>(){});
    }

    public List<MenuGroup> getMenuGroups() throws Exception {
        ClientResponse clientResponse = this.a("/MenuGroup", this.a(MenuGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuGroup>>(){});
    }

    public List<MenuItem> getMenuItems() throws Exception {
        ClientResponse clientResponse = this.a("/MenuItem", this.a(MenuItem.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuItem>>(){});
    }

    public List<ModifierGroup> getModifierGroups() throws Exception {
        ClientResponse clientResponse = this.a("/ModifierGroup", this.a(ModifierGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<ModifierGroup>>(){});
    }

    public List<MenuModifier> getMenuModifiers() throws Exception {
        ClientResponse clientResponse = this.a("/MenuModifier", this.a(MenuModifier.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuModifier>>(){});
    }

    public List<PriceRule> getPriceRules() throws Exception {
        ClientResponse clientResponse = this.a("/PriceRule", this.a(PriceRule.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceRule>>(){});
    }

    public List<PriceTable> getPriceList() throws Exception {
        ClientResponse clientResponse = this.a("/PriceTable", this.a(PriceTable.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceTable>>(){});
    }

    public List<PriceShift> getPriceShift() throws Exception {
        ClientResponse clientResponse = this.a("/PriceShift", this.a(PriceShift.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceShift>>(){});
    }

    public PosResponse register(String string, String string2, String string3, String string4) throws Exception {
        Client client = this.b();
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        multivaluedMapImpl.add((Object)"store_name", (Object)string2);
        multivaluedMapImpl.add((Object)"user_email", (Object)string3);
        multivaluedMapImpl.add((Object)"password", (Object)string4);
        WebResource webResource = client.resource(string + "/service/store/register");
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMapImpl);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
        }
        PosResponse posResponse = this.a(clientResponse);
        return posResponse;
    }

    private String a() {
        return Store.getWebServiceUrl();
    }

    private ClientResponse a(String string, Date date) throws Exception {
        return this.a(string, this.b(), this.a(date));
    }

    private ClientResponse a(String string, Client client, List<NameValuePair> list) throws Exception {
        String string2 = URLEncodedUtils.format(list, (String)"utf-8");
        WebResource webResource = client.resource(this.a() + string + "?" + string2);
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
        }
        return clientResponse;
    }

    private ClientResponse a(String string, Client client, MultivaluedMap multivaluedMap) throws Exception {
        WebResource webResource = client.resource(this.a() + string);
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMap);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
        }
        return clientResponse;
    }

    private PosResponse a(ClientResponse clientResponse) {
        String string = (String)clientResponse.getEntity(String.class);
        PosResponse posResponse = null;
        if (StringUtils.isNotEmpty((String)string)) {
            posResponse = (PosResponse)new GsonBuilder().create().fromJson(string, PosResponse.class);
        }
        return posResponse;
    }

    public PosResponse login(String string, String string2, String string3) throws Exception {
        Client client = this.b();
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        multivaluedMapImpl.add((Object)"device_id", (Object)TerminalUtil.getSystemUID());
        multivaluedMapImpl.add((Object)"user_email", (Object)string2);
        multivaluedMapImpl.add((Object)"password", (Object)string3);
        WebResource webResource = client.resource(string + "/service/store/login");
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMapImpl);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
        }
        PosResponse posResponse = this.a(clientResponse);
        return posResponse;
    }

    public PosResponse checkConnection() throws Exception {
        Store store = StoreDAO.getRestaurant();
        return this.login(store.getProperty("web.service.url"), store.getProperty("web.service.username"), store.getProperty("web.service.password"));
    }

    public PosResponse checkConnection(String string, String string2, String string3) throws Exception {
        return this.login(string, string2, string3);
    }

    private Client b() {
        Client client = Client.create();
        client.getProperties();
        return client;
    }

    private MultivaluedMap<String, Object> c() {
        Store store = StoreDAO.getRestaurant();
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        multivaluedMapImpl.add((Object)"device_id", (Object)TerminalUtil.getSystemUID());
        multivaluedMapImpl.add((Object)"user_email", (Object)store.getProperty("web.service.username"));
        multivaluedMapImpl.add((Object)"password", (Object)store.getProperty("web.service.password"));
        return multivaluedMapImpl;
    }

    private List<NameValuePair> a(Date date) {
        Store store = StoreDAO.getRestaurant();
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("device_id", TerminalUtil.getSystemUID()));
        arrayList.add((NameValuePair)new BasicNameValuePair("user_email", store.getProperty("web.service.username")));
        arrayList.add((NameValuePair)new BasicNameValuePair("password", store.getProperty("web.service.password")));
        if (date != null) {
            arrayList.add((NameValuePair)new BasicNameValuePair("lastUpdateTime", String.valueOf(date.getTime())));
        }
        return arrayList;
    }

    public void uploadStoreSessionData() throws Exception {
        List<StoreSession> list = StoreSessionDAO.getInstance().findAll();
        if (list != null) {
            for (StoreSession storeSession : list) {
                this.uploadStoreSessionData(storeSession);
            }
        }
    }

    public void uploadStoreSessionData(StoreSession storeSession) throws Exception {
        StoreSession storeSession2 = new StoreSession();
        PropertyUtils.copyProperties((Object)storeSession2, (Object)storeSession);
        if (!storeSession2.isCloudSynced().booleanValue()) {
            storeSession2.setOutletId(String.valueOf(StoreDAO.getRestaurant().getUniqueId()));
            this.a(storeSession2.getClosedBy());
            this.a(storeSession2.getOpenedBy());
            ArrayList<StoreSession> arrayList = new ArrayList<StoreSession>();
            arrayList.add(storeSession2);
            try {
                GenericEntity<List<StoreSession>> genericEntity = new GenericEntity<List<StoreSession>>(arrayList){};
                this.uploadData((GenericEntity)genericEntity, "storesession");
            }
            catch (Exception exception) {
                String string = "Uploading storesession failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
            this.b(storeSession2);
            this.a(storeSession2);
            this.c(storeSession2);
            if (storeSession.getCloseTime() != null) {
                storeSession.setCloudSynced(true);
                StoreSessionDAO.getInstance().update(storeSession);
            }
        }
    }

    public void uploadTerminal() {
        List<Terminal> list = TerminalDAO.getInstance().findAll();
        if (list != null && !list.isEmpty()) {
            for (Terminal object : list) {
                this.a(object);
            }
            try {
                this.uploadData((GenericEntity)new GenericEntity<List<Terminal>>(list){}, "terminal");
            }
            catch (Exception exception) {
                String string = "Uploading terminal failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(StoreSession storeSession) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<CashDrawer> list = CashDrawerDAO.getInstance().findByUnSyncStoreOperationData(storeSession);
        if (list != null && !list.isEmpty()) {
            for (CashDrawer object : list) {
                CashDrawer cashDrawer = new CashDrawer();
                PropertyUtils.copyProperties((Object)cashDrawer, (Object)object);
                if (object.getReportTime() != null) {
                    arrayList.add(cashDrawer.getId());
                }
                if (object.getStartTime() != null) {
                    CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(object);
                    cashDrawerReportService.populateReport();
                }
                this.a(object);
            }
            try {
                this.uploadData((GenericEntity)new GenericEntity<List<CashDrawer>>(list){}, "cashdrawer");
                CashDrawerDAO.getInstance().updateCashDrawerSync(arrayList);
            }
            catch (Exception exception) {
                String string = "Uploading cashdrawer failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(CashDrawer cashDrawer) {
        cashDrawer.setTransactions(null);
    }

    private void a(User user) {
        if (user == null) {
            return;
        }
        user.setCurrentCashDrawer(null);
        user.setLinkedUser(null);
    }

    private void a(Terminal terminal) {
        if (terminal == null) {
            return;
        }
        terminal.setCurrentCashDrawer(null);
        terminal.setAssignedUser(null);
    }

    private void b(StoreSession storeSession) {
        TicketDAO ticketDAO = TicketDAO.getInstance();
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        List<Ticket> list = ticketDAO.getTicketsOfCurrentSession(storeSession);
        Store store = StoreDAO.getRestaurant();
        String string = String.valueOf(store.getUniqueId());
        if (list != null && !list.isEmpty()) {
            for (Ticket object : list) {
                ticketDAO.loadFullTicket(object);
                this.b(object);
                object.setOutletId(string);
                arrayList.add(object);
            }
        }
        try {
            GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(arrayList){};
            this.uploadData((GenericEntity)genericEntity, "tickets");
            ticketDAO.updateTicketAndTicketItemSync(ticketDAO.getTicketsOfCurrentSession(storeSession), true);
        }
        catch (Exception exception) {
            String string2 = "Uploading tickets failed...";
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string2, exception);
        }
    }

    private void c(StoreSession storeSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<PosTransaction> list = PosTransactionDAO.getInstance().getUnSyncTransactionsByStoreSession(storeSession);
        Store store = StoreDAO.getRestaurant();
        if (list != null && !list.isEmpty()) {
            for (PosTransaction object : list) {
                arrayList.add(object.getId());
                String string = String.valueOf(store.getUniqueId());
                object.setOutletId(string);
                this.a(object.getTicket());
            }
        }
        try {
            GenericEntity<List<PosTransaction>> genericEntity = new GenericEntity<List<PosTransaction>>(list){};
            this.uploadData((GenericEntity)genericEntity, "transactions");
            PosTransactionDAO.getInstance().updatePosTransSync(arrayList, true);
        }
        catch (Exception exception) {
            String string = "Uploading transactions failed...";
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
        }
    }

    private void a(Ticket ticket) {
        ticket.setTicketItems(null);
        ticket.setProperties(null);
        ticket.setTransactions(null);
        ticket.setDepartment(null);
        ticket.setDiscounts(null);
        ticket.setCashier(null);
        ticket.setOwner(null);
        ticket.setOrderType(null);
        ticket.setGratuity(null);
    }

    private void b(Ticket ticket) {
        Object object;
        Object object2;
        ticket.setProperties(null);
        ticket.setTransactions(null);
        ticket.setDepartment(null);
        List<TicketDiscount> list = ticket.getDiscounts();
        if (list != null && list.size() > 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TicketDiscount)object2.next();
                this.a((TicketDiscount)object);
            }
        }
        if ((object2 = ticket.getOrderType()) != null) {
            this.a((OrderType)object2);
        }
        if ((object = ticket.getTicketItems()) != null) {
            Hibernate.initialize(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = (TicketItem)iterator.next();
                this.a(ticketItem);
            }
        }
    }

    private void a(TicketDiscount ticketDiscount) {
        ticketDiscount.setTicket(null);
    }

    private void a(TicketItem ticketItem) {
        ticketItem.setTicket(null);
        ticketItem.setTicketItemModifiers(null);
        ticketItem.setParentTicketItem(null);
        ticketItem.setMenuItem(null);
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list != null && list.size() > 0) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                this.a(ticketItemDiscount);
            }
        }
    }

    private void a(TicketItemDiscount ticketItemDiscount) {
        ticketItemDiscount.setTicketItem(null);
    }

    private void a(OrderType orderType) {
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    public void uploadData(GenericEntity genericEntity, String string) throws Exception {
        Client client = this.b();
        String string2 = URLEncodedUtils.format(this.a((Date)null), (String)"utf-8");
        WebResource webResource = client.resource(this.a() + "/" + string + "/save?" + string2);
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)genericEntity);
        if (clientResponse.getStatus() == 200) {
            System.out.println("uploaded...");
        } else if (clientResponse.getStatus() == 500) {
            throw new Exception("upload Failed..");
        }
    }

    public static PosWebService get() {
        return new PosWebService();
    }

    private Date a(Class clazz) {
        return TerminalDAO.getInstance().getLastUpdateTime(clazz);
    }
}

