/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.base.BaseTicketItemDiscount;
import com.floreantpos.model.dao.TicketDAO;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.PosResponse;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class ServiceUtils {
    public static String convertToJson(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        String string = "";
        try {
            System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            marshaller.setProperty("eclipselink.json.include-root", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(object, (Writer)stringWriter);
            string = stringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return "";
        }
    }

    public static String getAsJsonString(PosResponse posResponse) throws Exception {
        return ServiceUtils.getAsJsonString(posResponse, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
    }

    public static String getAsJsonString(PosResponse posResponse, boolean bl) throws Exception {
        if (bl) {
            return ServiceUtils.getAsJsonString(posResponse, CashDrawer.class, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
        }
        return ServiceUtils.getAsJsonString(posResponse, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
    }

    public static String getAsJsonString(PosResponse posResponse, Class ... classArray) throws Exception {
        if (posResponse == null) {
            return "";
        }
        try {
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(classArray)}).create();
            String string = gson.toJson((Object)posResponse);
            return string;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return "";
        }
    }

    public static String convertTicketsToJson(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        try {
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(User.class, StoreSession.class, Terminal.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class)}).create();
            String string = gson.toJson(object);
            return string;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return "";
        }
    }

    public static Ticket convertToObject(String string) throws Exception {
        if (string == null) {
            return null;
        }
        try {
            System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{string.getClass()});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            StringReader stringReader = new StringReader(string);
            Ticket ticket = (Ticket)unmarshaller.unmarshal((Reader)stringReader);
            return ticket;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static String convertImageIconToString(ImageIcon imageIcon) {
        String string = "";
        if (imageIcon != null) {
            try {
                Image image = imageIcon.getImage();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
                File file = new File("saved.png");
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                byteArrayOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = Base64.encodeBase64((byte[])byArray);
                string = new String(byArray2);
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        return string;
    }

    public static List<Integer> convertJsonToIntList(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string3 = String.valueOf(jSONObject.get(string2));
            return ServiceUtils.convertStringArrayToList(string3);
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static List<Ticket> convertJsonToTicketList(String string) {
        try {
            if (string == null) {
                return null;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                List<TicketItemModifier> list;
                Object object;
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                HashMap<String, ArrayList<TicketItemModifier>> hashMap = new HashMap<String, ArrayList<TicketItemModifier>>();
                if (jSONObject.has("ticketItemModifiers")) {
                    object = jSONObject.getJSONArray("ticketItemModifiers");
                    for (int j = 0; j < object.length(); ++j) {
                        JSONObject jSONObject2 = object.getJSONObject(j);
                        TicketItemModifier ticketItemModifier = (TicketItemModifier)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject2.toString(), TicketItemModifier.class);
                        if (ticketItemModifier.getTicketItem() == null) continue;
                        list = (ArrayList<TicketItemModifier>)hashMap.get(ticketItemModifier.getTicketItem().getId());
                        if (list == null) {
                            list = new ArrayList<TicketItemModifier>();
                            hashMap.put(ticketItemModifier.getTicketItem().getId(), (ArrayList<TicketItemModifier>)list);
                        }
                        list.add(ticketItemModifier);
                    }
                }
                if ((object = (Ticket)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), Ticket.class)) == null) continue;
                ((Ticket)object).convertDiscountPropertyToList();
                ArrayList<TicketItem> arrayList2 = new ArrayList<TicketItem>();
                for (TicketItem ticketItem : ((Ticket)object).getTicketItems()) {
                    list = (List)hashMap.get(ticketItem.getId());
                    if (list != null && list.size() > 0) {
                        ModifiableTicketItem modifiableTicketItem = new ModifiableTicketItem(ticketItem.getId());
                        try {
                            PropertyUtils.copyProperties((Object)modifiableTicketItem, (Object)ticketItem);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        modifiableTicketItem.setId(ticketItem.getId());
                        modifiableTicketItem.setTicketItemModifiers(list);
                        arrayList2.add(modifiableTicketItem);
                        continue;
                    }
                    arrayList2.add(ticketItem);
                }
                ((BaseTicket)object).setTicketItems(arrayList2);
                arrayList.add((Ticket)object);
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static List<ShopTableStatus> convertJsonToShopTableStatusList(String string) {
        try {
            if (string == null) {
                return null;
            }
            ArrayList<ShopTableStatus> arrayList = new ArrayList<ShopTableStatus>();
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                ShopTableStatus shopTableStatus = (ShopTableStatus)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), ShopTableStatus.class);
                if (shopTableStatus == null) continue;
                arrayList.add(shopTableStatus);
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static ModifiableTicketItem covertToModifiableTicketItem(TicketItem ticketItem) {
        try {
            ModifiableTicketItem modifiableTicketItem = new ModifiableTicketItem();
            modifiableTicketItem.setId(ticketItem.getId());
            modifiableTicketItem.setVersion(ticketItem.getVersion());
            modifiableTicketItem.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
            modifiableTicketItem.setQuantity(ticketItem.getQuantity());
            modifiableTicketItem.setTicket(ticketItem.getTicket());
            modifiableTicketItem.setUnitPrice(ticketItem.getUnitPrice());
            modifiableTicketItem.setUnitName(ticketItem.getUnitName());
            modifiableTicketItem.setTicketItemModifiers(ticketItem.getTicketItemModifiers());
            modifiableTicketItem.setTaxes(ticketItem.getTaxes());
            modifiableTicketItem.setTaxIncluded(ticketItem.isTaxIncluded());
            modifiableTicketItem.setCourseId(ticketItem.getCourseId());
            modifiableTicketItem.setCourseName(ticketItem.getCourseName());
            modifiableTicketItem.setMenuItemId(ticketItem.getId());
            modifiableTicketItem.setComboItem(ticketItem.isComboItem());
            modifiableTicketItem.setPizzaType(ticketItem.isPizzaType());
            modifiableTicketItem.setFractionalUnit(ticketItem.isFractionalUnit());
            modifiableTicketItem.setName(ticketItem.getName());
            modifiableTicketItem.setGroupId(ticketItem.getGroupId());
            modifiableTicketItem.setGroupName(ticketItem.getGroupName());
            modifiableTicketItem.setCategoryName(ticketItem.getCategoryName());
            modifiableTicketItem.setCategoryId(ticketItem.getCategoryId());
            modifiableTicketItem.setServiceChargeApplicable(ticketItem.isServiceChargeApplicable());
            modifiableTicketItem.setServiceChargeRate(ticketItem.getServiceCharge());
            modifiableTicketItem.setTaxOnServiceCharge(ticketItem.isTaxOnServiceCharge());
            modifiableTicketItem.setUnitCost(ticketItem.getUnitCost());
            modifiableTicketItem.setInventoryItem(ticketItem.isInventoryItem());
            modifiableTicketItem.setShouldPrintToKitchen(ticketItem.isShouldPrintToKitchen());
            modifiableTicketItem.setBeverage(ticketItem.isBeverage());
            modifiableTicketItem.setPrinterGroup(ticketItem.getPrinterGroup());
            modifiableTicketItem.setShouldPrintToKitchen(ticketItem.isShouldPrintToKitchen());
            modifiableTicketItem.setPrintKitchenSticker(ticketItem.isPrintKitchenSticker());
            modifiableTicketItem.setDiscounts(ticketItem.getDiscounts());
            return modifiableTicketItem;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Integer> convertStringArrayToList(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string != null) {
            string = string.replace("[", "").replace("]", "").replaceAll("\"", Matcher.quoteReplacement(""));
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n = Integer.valueOf(stringArray[i]);
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    public static String createPosResponseAsString(List<Ticket> list) throws Exception {
        PosResponse posResponse = ServiceUtils.createPosResponse(list);
        String string = ServiceUtils.convertTicketsToJson(posResponse);
        return string;
    }

    public static PosResponse createPosResponse(List<Ticket> list) {
        PosResponse posResponse = new PosResponse();
        posResponse.setResponseCode(1);
        posResponse.setRequest("Ticket Notification");
        posResponse.setMsg((list.size() == 1 ? "1 ticket" : list.size() + "tickets") + " has been updated.");
        posResponse.setDeviceId(TerminalUtil.getSystemUID());
        posResponse.setData(list);
        for (Ticket ticket : list) {
            Terminal terminal;
            TicketDAO.getInstance().loadFullTicket(ticket);
            Set<PosTransaction> set = ticket.getTransactions();
            if (set != null && set.size() > 0) {
                for (PosTransaction posTransaction : set) {
                    posTransaction.setTicket(null);
                }
            }
            OrderType orderType = ticket.getOrderType();
            orderType.setDepartments(null);
            orderType.setCategories(null);
            orderType.setTerminalTypes(null);
            Outlet comparable2 = ticket.getOutlet();
            if (comparable2 != null) {
                comparable2.setDepartments(null);
            }
            if ((terminal = ticket.getTerminal()) != null) {
                terminal.setOutlet(null);
                terminal.setCurrentCashDrawer(null);
                terminal.setTerminalType(null);
            }
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                Object object;
                Object object2;
                ticketItem.setTicket(null);
                ticketItem.setMenuItem(new MenuItem(ticketItem.getMenuItemId()));
                List<TicketItemDiscount> list2 = ticketItem.getDiscounts();
                if (list2 != null && list2.size() > 0) {
                    object2 = list2.iterator();
                    while (object2.hasNext()) {
                        object = (TicketItemDiscount)object2.next();
                        ((BaseTicketItemDiscount)object).setTicketItem(null);
                    }
                }
                if ((object2 = ticketItem.getTicketItemModifiers()) == null || object2.size() <= 0) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    TicketItemModifier ticketItemModifier = (TicketItemModifier)object.next();
                    ticketItemModifier.setTicketItem(null);
                }
            }
        }
        return posResponse;
    }
}

