/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.util.StoreUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.server.RestDataService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationServiceUtils {
    public static final String DATA_UPDATE_NOTIFICATION = "Data Update Notification";
    public static final String TICKET_NOTIFICATION = "Ticket Notification";
    public static final String RECEIPT_PRINT_NOTIFICATION = "Receipt Print Notification";
    public static final String KITCHEN_PRINT_NOTIFICATION = "Kitchen Print Notification";
    public static final String RECEIPT_AND_KITCHEN_PRINT_NOTIFICATION = "Receipt & Kitchen Print Notification";
    public static final String TABLE_NOTIFICATION = "Table Notification";
    public static final String CASH_DRAWER_NOTIFICATION = "Cash Drawer Notification";

    public static void notificationReceived(JSONObject jSONObject) {
        String string;
        if (!jSONObject.has("request")) {
            return;
        }
        switch (string = jSONObject.getString("request")) {
            case "Ticket Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jSONObject);
                break;
            }
            case "Receipt Print Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jSONObject, true, false);
                break;
            }
            case "Kitchen Print Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jSONObject, false, true);
                break;
            }
            case "Receipt & Kitchen Print Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jSONObject, true, true);
                break;
            }
            case "Cash Drawer Notification": {
                NotificationServiceUtils.convertAndSaveCashDrawers(jSONObject);
            }
        }
    }

    public static void publishDrawerClosed(CashDrawer cashDrawer) {
        ArrayList<CashDrawer> arrayList = new ArrayList<CashDrawer>();
        arrayList.add(cashDrawer);
        NotificationServiceUtils.pulishDrawers(arrayList);
    }

    public static void publishDrawerOpened(CashDrawer cashDrawer) {
        ArrayList<CashDrawer> arrayList = new ArrayList<CashDrawer>();
        arrayList.add(cashDrawer);
        NotificationServiceUtils.pulishDrawers(arrayList);
    }

    public static void pulishDrawers(List<CashDrawer> list) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null && list.size() > 0) {
                for (CashDrawer cashDrawer : list) {
                    cashDrawer.setTransactions(null);
                    arrayList.add(cashDrawer.getId());
                }
                String string = NotificationServiceUtils.convertCashDrawersToJson(list);
                OroMqttClient.getInstance().publishOnThread("mobile_notification", string);
            }
        }
        catch (Exception exception) {
            PosLog.error(NotificationServiceUtils.class, exception);
        }
    }

    public static void pulishTicket(final String string) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(string);
                arrayList.add(ticket);
                NotificationServiceUtils.pulishTickets(arrayList);
            }
        }).start();
    }

    public static void pulishTickets(List<Ticket> list) {
        try {
            if (list != null && list.size() > 0) {
                for (Ticket ticket : list) {
                    ticket.setDiscounts(null);
                }
                String string = ServiceUtils.createPosResponseAsString(list);
                OroMqttClient.getInstance().publishData("mobile_notification", string);
            }
        }
        catch (Exception exception) {
            PosLog.error(NotificationServiceUtils.class, exception);
        }
    }

    public static void convertAndSaveAsTicket(JSONObject jSONObject) {
        NotificationServiceUtils.convertAndSaveAsTicket(jSONObject, false, false);
    }

    public static void convertAndSaveAsTicket(JSONObject jSONObject, boolean bl, boolean bl2) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("tickets");
            List<Ticket> list = ServiceUtils.convertJsonToTicketList(jSONArray.toString());
            RestDataService restDataService = new RestDataService();
            restDataService.saveOrUpdateTickets(list);
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
        }
    }

    private static void convertAndSaveCashDrawers(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            if (jSONArray != null && jSONArray.length() > 0) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create();
                    CashDrawer cashDrawer = (CashDrawer)gson.fromJson(jSONObject2.toString(), CashDrawer.class);
                    if (cashDrawer == null) continue;
                    cashDrawer.setStoreOperationData(StoreUtil.getCurrentStoreSession());
                    CashDrawer cashDrawer2 = CashDrawerDAO.getInstance().get(cashDrawer.getId());
                    if (cashDrawer2 == null) {
                        CashDrawerDAO.getInstance().save(cashDrawer);
                        NotificationServiceUtils.updateTerminal(cashDrawer.getTerminalId(), cashDrawer.getAssignedUser(), cashDrawer);
                        cashDrawer2 = cashDrawer;
                    }
                    if (!cashDrawer.isClosed()) continue;
                    cashDrawer2.setClosedBy(cashDrawer.getClosedBy());
                    cashDrawer2.setReportTime(cashDrawer.getReportTime());
                    CashDrawerDAO.getInstance().update(cashDrawer);
                    NotificationServiceUtils.updateTerminal(cashDrawer.getTerminalId(), null, null);
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
        }
    }

    private static void updateTerminal(Integer n, User user, CashDrawer cashDrawer) {
        Terminal terminal = TerminalDAO.getInstance().get(n);
        if (terminal != null) {
            terminal.setAssignedUser(user);
            terminal.setCurrentCashDrawer(cashDrawer);
            terminal.setActive(true);
            TerminalDAO.getInstance().saveOrUpdate(terminal);
        }
    }

    public static String convertCashDrawersToJson(List<CashDrawer> list) throws Exception {
        PosResponse posResponse = new PosResponse();
        posResponse.setResponseCode(1);
        posResponse.setRequest(CASH_DRAWER_NOTIFICATION);
        posResponse.setMsg((list.size() == 1 ? "1 cash drawer" : list.size() + "cash drawers") + " has been updated.");
        posResponse.setDeviceId(TerminalUtil.getSystemUID());
        posResponse.setData(list);
        return ServiceUtils.getAsJsonString(posResponse);
    }
}

