/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.EmployeeInOutHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.ClockInOutDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.LogFactory;

public class ClockInOutAction
extends PosAction {
    public ClockInOutAction() {
        super(Messages.getString("ClockInOutAction.0"));
    }

    public ClockInOutAction(boolean bl, boolean bl2) {
        if (bl) {
            this.putValue("Name", Messages.getString("ClockInOutAction.1"));
        }
        if (bl2) {
            this.putValue("SmallIcon", IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        }
    }

    @Override
    public void execute() {
        User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("ClockInOutAction.3"));
        if (user == null) {
            return;
        }
        ClockInOutDialog clockInOutDialog = ClockInOutDialog.getInstance(user, false);
        clockInOutDialog.openUndecoratedFullScreen();
    }

    private void a(User user) {
        try {
            Calendar calendar;
            Comparable comparable;
            if (user == null) {
                return;
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                comparable = user.getLastClockInTime();
                calendar = Calendar.getInstance();
                calendar.setTime((Date)comparable);
                attendenceHistory.setClockInTime((Date)comparable);
                attendenceHistory.setClockInHour((short)calendar.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            comparable = user.getCurrentShift();
            calendar = Calendar.getInstance();
            user.doClockOut(attendenceHistory, (Shift)comparable, calendar);
            POSMessageDialog.showMessage(Messages.getString("ClockInOutAction.8") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.10"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void b(User user) {
        try {
            if (user == null) {
                return;
            }
            if (user.isClockedIn() != null && user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(Messages.getString("ClockInOutAction.11") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.13"));
                return;
            }
            Shift shift = ShiftUtil.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.doClockIn(Application.getInstance().getTerminal(), shift, calendar);
            POSMessageDialog.showMessage(Messages.getString("ClockInOutAction.14") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.16"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performDriverOut(User user) {
        try {
            if (user == null) {
                return;
            }
            Shift shift = ShiftUtil.getCurrentShift();
            Terminal terminal = Application.getInstance().getTerminal();
            Calendar calendar = Calendar.getInstance();
            user.setAvailableForDelivery(false);
            user.setLastClockOutTime(calendar.getTime());
            LogFactory.getLog(Application.class).info((Object)("terminal id befor saving clockIn=" + terminal.getId()));
            EmployeeInOutHistory employeeInOutHistory = new EmployeeInOutHistory();
            employeeInOutHistory.setOutTime(calendar.getTime());
            employeeInOutHistory.setOutHour((short)calendar.get(11));
            employeeInOutHistory.setClockOut(true);
            employeeInOutHistory.setUser(user);
            employeeInOutHistory.setTerminal(terminal);
            employeeInOutHistory.setShift(shift);
            UserDAO.getInstance().saveDriverOut(user, employeeInOutHistory, shift, calendar);
            POSMessageDialog.showMessage("Driver " + user.getFirstName() + " " + user.getLastName() + " is out for delivery.");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performDriverIn(User user) {
        try {
            Comparable comparable;
            if (user == null) {
                return;
            }
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ClockInOutAction.2"));
                return;
            }
            EmployeeInOutHistoryDAO employeeInOutHistoryDAO = new EmployeeInOutHistoryDAO();
            EmployeeInOutHistory employeeInOutHistory = employeeInOutHistoryDAO.findDriverHistoryByClockedInTime(user);
            if (employeeInOutHistory == null) {
                employeeInOutHistory = new EmployeeInOutHistory();
                comparable = Calendar.getInstance();
                employeeInOutHistory.setInTime(((Calendar)comparable).getTime());
                employeeInOutHistory.setInHour((short)((Calendar)comparable).get(11));
                employeeInOutHistory.setUser(user);
                employeeInOutHistory.setTerminal(Application.getInstance().getTerminal());
                employeeInOutHistory.setShift(user.getCurrentShift());
            }
            comparable = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.setAvailableForDelivery(true);
            employeeInOutHistory.setClockOut(false);
            employeeInOutHistory.setInTime(calendar.getTime());
            employeeInOutHistory.setInHour((short)calendar.get(11));
            UserDAO.getInstance().saveDriverIn(user, employeeInOutHistory, (Shift)comparable, calendar);
            POSMessageDialog.showMessage("Driver " + user.getFirstName() + " " + user.getLastName() + " is in after delivery");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }
}

