/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.CookingInstructionExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class CookingInstructionExplorerAction
extends AbstractAction {
    public CookingInstructionExplorerAction() {
        super(POSConstants.COOKING_INSTRUCTIONS);
    }

    public CookingInstructionExplorerAction(String string) {
        super(string);
    }

    public CookingInstructionExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            CookingInstructionExplorer cookingInstructionExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.COOKING_INSTRUCTIONS);
            if (n == -1) {
                cookingInstructionExplorer = new CookingInstructionExplorer();
                jTabbedPane.addTab(POSConstants.COOKING_INSTRUCTIONS, cookingInstructionExplorer);
            } else {
                cookingInstructionExplorer = (CookingInstructionExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(cookingInstructionExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

