/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.ModifierExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ModifierExplorerAction
extends AbstractAction {
    public ModifierExplorerAction() {
        super(POSConstants.MENU_MODIFIERS);
    }

    public ModifierExplorerAction(String string) {
        super(string);
    }

    public ModifierExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            ModifierExplorer modifierExplorer;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.MODIFIER_EXPLORER);
            if (n == -1) {
                modifierExplorer = new ModifierExplorer();
                jTabbedPane.addTab(POSConstants.MODIFIER_EXPLORER, modifierExplorer);
            } else {
                modifierExplorer = (ModifierExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(modifierExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

