/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.OrderTypeExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class OrdersTypeExplorerAction
extends AbstractAction {
    public OrdersTypeExplorerAction() {
        super(POSConstants.ORDER_TYPE);
    }

    public OrdersTypeExplorerAction(String string) {
        super(string);
    }

    public OrdersTypeExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            OrderTypeExplorer orderTypeExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.ORDER_TYPE);
            if (n == -1) {
                orderTypeExplorer = new OrderTypeExplorer();
                jTabbedPane.addTab(POSConstants.ORDER_TYPE, orderTypeExplorer);
            } else {
                orderTypeExplorer = (OrderTypeExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(orderTypeExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

