/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class DrawerPullReportExplorer
extends TransparentPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JButton d = new JButton(POSConstants.EDIT_ACTUAL_AMOUNT);
    private JButton e = new JButton(Messages.getString("DrawerPullReportExplorer.0"));
    private TableColumnModelExt f;
    private PosTable g;
    private JButton h;
    private JButton i;
    private JLabel j;
    private DrawerPullExplorerTableModel k;

    public DrawerPullReportExplorer() {
        super(new BorderLayout());
        this.a();
        this.b();
    }

    private void a() {
        this.k = new DrawerPullExplorerTableModel();
        this.k.addColumn(POSConstants.TIME, CashDrawer.PROP_REPORT_TIME, 11, BeanTableModel.DataType.DATE);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.2"), CashDrawer.PROP_TICKET_COUNT);
        this.k.addColumn(POSConstants.DRAWER_PULL_AMOUNT, CashDrawer.PROP_DRAWER_ACCOUNTABLE, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.3"), CashDrawer.PROP_ASSIGNED_USER_ID);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.4"), CashDrawer.PROP_TERMINAL_ID);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.5"), CashDrawer.PROP_BEGIN_CASH, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.6"), CashDrawer.PROP_NET_SALES, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.7"), CashDrawer.PROP_SALES_TAX, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.8"), CashDrawer.PROP_CASH_TAX, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.9"), CashDrawer.PROP_TOTAL_REVENUE, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.10"), CashDrawer.PROP_GROSS_RECEIPTS);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.11"), CashDrawer.PROP_GIFT_CERT_RETURN_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.12"), CashDrawer.PROP_GIFT_CERT_RETURN_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.13"), CashDrawer.PROP_GIFT_CERT_CHANGE_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.14"), CashDrawer.PROP_CASH_RECEIPT_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.15"), CashDrawer.PROP_CASH_RECEIPT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.16"), CashDrawer.PROP_CASH_RECEIPT_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.17"), CashDrawer.PROP_CREDIT_CARD_RECEIPT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.18"), CashDrawer.PROP_DEBIT_CARD_RECEIPT_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.19"), CashDrawer.PROP_DEBIT_CARD_RECEIPT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.20"), CashDrawer.PROP_REFUND_RECEIPT_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.21"), CashDrawer.PROP_REFUND_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.22"), CashDrawer.PROP_RECEIPT_DIFFERENTIAL, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.23"), CashDrawer.PROP_CASH_BACK, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.24"), CashDrawer.PROP_CASH_TIPS, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.25"), CashDrawer.PROP_CHARGED_TIPS, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.26"), CashDrawer.PROP_TIPS_PAID, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.27"), CashDrawer.PROP_TIPS_DIFFERENTIAL, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.28"), CashDrawer.PROP_PAY_OUT_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.29"), CashDrawer.PROP_PAY_OUT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.30"), CashDrawer.PROP_DRAWER_BLEED_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.31"), CashDrawer.PROP_DRAWER_BLEED_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("PosMessage.156"), CashDrawer.PROP_CASH_TO_DEPOSIT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.32"), CashDrawer.PROP_VARIANCE, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.33"), CashDrawer.PROP_TOTAL_VOID_WST, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.34"), CashDrawer.PROP_TOTAL_VOID, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.35"), CashDrawer.PROP_TOTAL_DISCOUNT_COUNT);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.36"), CashDrawer.PROP_TOTAL_DISCOUNT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.37"), CashDrawer.PROP_TOTAL_DISCOUNT_SALES, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.38"), CashDrawer.PROP_TOTAL_DISCOUNT_GUEST);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.39"), CashDrawer.PROP_TOTAL_DISCOUNT_PARTY_SIZE);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.40"), CashDrawer.PROP_TOTAL_DISCOUNT_CHECK_SIZE);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.41"), CashDrawer.PROP_TOTAL_DISCOUNT_PERCENTAGE, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.42"), CashDrawer.PROP_TOTAL_DISCOUNT_RATIO, 11, BeanTableModel.DataType.MONEY);
        this.k.setPageSize(50);
        this.g = new PosTable(this.k);
        this.g.getSelectionModel().setSelectionMode(0);
        this.g.setRowHeight(PosUIManager.getSize(30));
        this.g.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.g.setAutoResizeMode(0);
        this.g.setColumnControlVisible(true);
        this.resizeColumnWidth((JTable)((Object)this.g));
        this.add(new JScrollPane((Component)((Object)this.g)));
        this.c();
        this.e();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO), "grow,gapleft 3");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        this.h = new JButton(Messages.getString("DrawerPullReportExplorer.85"));
        this.i = new JButton(Messages.getString("DrawerPullReportExplorer.86"));
        this.j = new JLabel();
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DrawerPullReportExplorer.this.a(DrawerPullReportExplorer.this.k.getPreviousRowIndex());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DrawerPullReportExplorer.this.a(DrawerPullReportExplorer.this.k.getNextRowIndex());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.j);
        jPanel2.add(this.h);
        jPanel2.add(this.i);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.d);
        jPanel3.add(this.e);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "East");
        this.add((Component)jPanel4, "South");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DrawerPullReportExplorer.this.g.getSelectedRow();
                if (n < 0) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, Messages.getString("DrawerPullReportExplorer.1"));
                    return;
                }
                DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)DrawerPullReportExplorer.this.g.getModel();
                CashDrawer cashDrawer = drawerPullExplorerTableModel.getRowData(n);
                try {
                    PosPrintService.printDrawerPullReport(cashDrawer);
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, exception.getMessage(), exception);
                }
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DrawerPullReportExplorer.this.b();
                    DrawerPullReportExplorer.this.resizeColumnWidth((JTable)((Object)DrawerPullReportExplorer.this.g));
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = DrawerPullReportExplorer.this.g.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.SELECT_DRAWER_PULL_TO_EDIT);
                        return;
                    }
                    String string = JOptionPane.showInputDialog(DrawerPullReportExplorer.this, (Object)(POSConstants.ENTER_ACTUAL_AMOUNT + ":"));
                    if (string == null) {
                        return;
                    }
                    double d = 0.0;
                    try {
                        d = Double.parseDouble(string);
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.INVALID_AMOUNT);
                        return;
                    }
                    DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)DrawerPullReportExplorer.this.g.getModel();
                    CashDrawer cashDrawer = drawerPullExplorerTableModel.getRowData(n);
                    CashDrawerDAO cashDrawerDAO = new CashDrawerDAO();
                    CashDrawer cashDrawer2 = cashDrawerDAO.get(cashDrawer.getId());
                    cashDrawer2.setCashToDeposit(d);
                    cashDrawerDAO.saveOrUpdate(cashDrawer2);
                    drawerPullExplorerTableModel.setRow(n, cashDrawer2);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void b() {
        this.a(0);
    }

    private void a(int n) {
        this.k.setCurrentRowIndex(n);
        Date date = this.a.getDate();
        Date date2 = this.b.getDate();
        if (date.after(date2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        date = DateUtil.startOfDay(date);
        date2 = DateUtil.endOfDay(date2);
        CashDrawerDAO.getInstance().loadCashDrawerReport(this.k, date, date2);
        int n2 = this.k.getCurrentRowIndex() + 1;
        int n3 = this.k.getNextRowIndex();
        int n4 = this.k.getNumRows();
        if (n3 > n4) {
            n3 = n4;
        }
        this.j.setText(String.format(Messages.getString("DrawerPullReportExplorer.87"), n2, n3, n4));
        this.h.setEnabled(this.k.hasPrevious());
        this.i.setEnabled(this.k.hasNext());
    }

    private void c() {
        String string = TerminalConfig.getDrawerPullReportHiddenColumns();
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.g.getColumnModel();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("\\*");
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = Integer.parseInt(stringArray[i]);
            tableColumnModelExt.getColumnExt(n - i).setVisible(false);
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n;
            int n2 = this.b(jTable, i);
            if (n2 > (n = this.a(jTable, i))) {
                tableColumnModel.getColumn(i).setPreferredWidth(n2);
                continue;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
    }

    private int a(JTable jTable, int n) {
        int n2 = 50;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, n);
        n2 = Math.max(n2, component.getPreferredSize().width);
        return n2 + 20;
    }

    private int b(JTable jTable, int n) {
        int n2 = 50;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n);
            Component component = jTable.prepareRenderer(tableCellRenderer, i, n);
            n2 = Math.max(component.getPreferredSize().width + 1, n2);
        }
        return n2 + 20;
    }

    private void d() {
        List list = this.f.getColumns(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableColumn tableColumn : list) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            if (tableColumnExt.isVisible()) continue;
            arrayList.add(tableColumnExt.getModelIndex());
        }
        this.a(arrayList);
    }

    private void a(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(iterator.next());
            string = string + string2;
            if (!iterator.hasNext()) continue;
            string = string + "*";
        }
        TerminalConfig.setDrawerPullReportHiddenColumns(string);
    }

    private void e() {
        this.f = (TableColumnModelExt)this.g.getColumnModel();
        this.f.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                DrawerPullReportExplorer.this.d();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                DrawerPullReportExplorer.this.d();
            }
        });
    }

    class DrawerPullExplorerTableModel
    extends BeanTableModel<CashDrawer> {
        public DrawerPullExplorerTableModel() {
            super(CashDrawer.class);
        }

        public CashDrawer getRowData(int n) {
            return (CashDrawer)super.getRow(n);
        }
    }
}

