/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuCategoryExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable a;
    private BeanTableModel<MenuCategory> b;

    public MenuCategoryExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(MenuCategory.class);
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME.toUpperCase(), "translatedName");
        this.b.addColumn(POSConstants.BEVERAGE.toUpperCase(), "beverage");
        this.b.addColumn(POSConstants.VISIBLE.toUpperCase(), "visible");
        this.b.addColumn(POSConstants.SORT_ORDER.toUpperCase(), "sortOrder");
        this.b.addColumn(POSConstants.BUTTON_COLOR.toUpperCase(), "buttonColor");
        this.b.addColumn(POSConstants.TEXT_COLOR.toUpperCase(), "textColor");
        this.a = new JXTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuCategoryExplorer.this.editSelectedRow();
                }
            }
        });
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.add((Component)this.a(), "North");
        this.add(new JScrollPane((Component)this.a));
        this.b();
    }

    private JPanel a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(""));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MenuCategoryExplorer.4")));
        JButton jButton = new JButton(POSConstants.REFRESH);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuCategoryExplorer.this.initData();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private void b() {
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
                    beanEditorDialog.setPreferredSize(PosUIManager.getSize(600, 600));
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
                    MenuCategoryExplorer.this.b.addRow(menuCategory);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategoryExplorer.this.editSelectedRow();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MenuCategoryExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = MenuCategoryExplorer.this.a.convertRowIndexToModel(n);
                    MenuCategory menuCategory = (MenuCategory)MenuCategoryExplorer.this.b.getRow(n);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    MenuGroupDAO menuGroupDAO = new MenuGroupDAO();
                    boolean bl = menuGroupDAO.existsMenuGroups(menuCategory);
                    if (bl && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryExplorer.0"), POSConstants.DELETE) != 0) {
                        return;
                    }
                    MenuCategoryDAO menuCategoryDAO = new MenuCategoryDAO();
                    menuCategoryDAO.releaseParentAndDelete(menuCategory);
                    MenuCategoryExplorer.this.b.removeRow(n);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    public void editSelectedRow() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuCategory menuCategory = this.b.getRow(n);
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm(menuCategory);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(600, 600));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void initData() {
        this.b.setRows(MenuCategoryDAO.getInstance().findAll());
    }
}

