/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.VariantAttributesSelectionDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class MenuItemVariantExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a;
    private final MenuItemExplorerTableModel b;
    private MenuItem c;

    public MenuItemVariantExplorer() {
        this.a();
        this.b = new MenuItemExplorerTableModel();
        this.a.setModel(this.b);
        this.a.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 4) {
                    this.setHorizontalAlignment(0);
                } else if (n2 == 3) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                return component;
            }
        });
        this.b();
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        FixedLengthTextField fixedLengthTextField = new FixedLengthTextField();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(fixedLengthTextField);
        defaultCellEditor.setClickCountToStart(1);
        FixedLengthTextField fixedLengthTextField2 = new FixedLengthTextField();
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(fixedLengthTextField2);
        defaultCellEditor2.setClickCountToStart(1);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setAllowNegativeValue(true);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(doubleTextField);
        defaultCellEditor3.setClickCountToStart(1);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor4 = new DefaultCellEditor(jCheckBox);
        defaultCellEditor4.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(1), defaultCellEditor2);
        this.a.setDefaultEditor(this.a.getColumnClass(2), defaultCellEditor);
        this.a.setDefaultEditor(this.a.getColumnClass(3), defaultCellEditor3);
        this.a.setDefaultEditor(this.a.getColumnClass(4), defaultCellEditor4);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                MenuItemVariantExplorer.this.a.editCellAt(n, n2);
                MenuItemVariantExplorer.this.a.transferFocus();
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)MenuItemVariantExplorer.this.a.getCellEditor(n, n2);
                if (n2 == 4) {
                    JCheckBox jCheckBox = (JCheckBox)defaultCellEditor.getComponent();
                    jCheckBox.requestFocus();
                } else if (n2 == 3) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                } else if (n2 == 2) {
                    FixedLengthTextField fixedLengthTextField = (FixedLengthTextField)defaultCellEditor.getComponent();
                    fixedLengthTextField.requestFocus();
                    fixedLengthTextField.selectAll();
                } else if (n2 == 1) {
                    FixedLengthTextField fixedLengthTextField = (FixedLengthTextField)defaultCellEditor.getComponent();
                    fixedLengthTextField.setLength(255);
                    fixedLengthTextField.requestFocus();
                    fixedLengthTextField.selectAll();
                }
            }
        };
        this.a.setRowHeight(PosUIManager.getSize(40));
        JButton jButton = new JButton(Messages.getString("MenuItemVariantExplorer.2"));
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.DELETE);
        jButton2.setActionCommand(POSConstants.DELETE);
        jButton2.addActionListener(this);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        this.add((Component)new JScrollPane(this.a), "grow");
        this.add((Component)transparentPanel, "grow,newline");
    }

    private void b() {
        this.a.setAutoResizeMode(3);
        this.a(0, PosUIManager.getSize(200));
        this.a(1, PosUIManager.getSize(300));
        this.a(2, PosUIManager.getSize(180));
        this.a(3, PosUIManager.getSize(120));
        this.a(4, PosUIManager.getSize(100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.a.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.c = menuItem;
        this.b.setItems(menuItem.getVariants());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.c();
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            MenuItem menuItem = this.b.getMenuItem(n);
            this.a(n, menuItem);
        }
    }

    private void c() {
        try {
            VariantAttributesSelectionDialog variantAttributesSelectionDialog = new VariantAttributesSelectionDialog(this.b.getItems());
            variantAttributesSelectionDialog.setSize(PosUIManager.getSize(550, 450));
            variantAttributesSelectionDialog.setParentMenuItem(this.c);
            variantAttributesSelectionDialog.open();
            if (variantAttributesSelectionDialog.isCanceled()) {
                return;
            }
            List<MenuItem> list = variantAttributesSelectionDialog.getVariants();
            this.b.getItems().clear();
            this.b.setItems(list);
            this.b.fireTableDataChanged();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(int n, MenuItem menuItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.b.deleteItem(menuItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<MenuItem> getVariants() {
        List<MenuItem> list = this.b.getItems();
        if (list != null) {
            for (MenuItem menuItem : list) {
                menuItem.setUnit(this.c.getUnit());
            }
        }
        return list;
    }

    private class MenuItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("MenuItemVariantExplorer.6"), Messages.getString("MenuItemVariantExplorer.7"), Messages.getString("MenuItemVariantExplorer.8"), Messages.getString("MenuItemVariantExplorer.9"), Messages.getString("MenuItemVariantExplorer.10")};
        List<MenuItem> b = new ArrayList<MenuItem>();

        public void setItems(List<MenuItem> list) {
            if (list == null) {
                return;
            }
            this.b.addAll(list);
        }

        public List<MenuItem> getItems() {
            return this.b;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 4) {
                return Boolean.class;
            }
            if (n == 3) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            MenuItem menuItem = this.b.get(n);
            if (menuItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    String string = "<html>";
                    List<Attribute> list = menuItem.getAttributes();
                    if (list == null) {
                        return string;
                    }
                    Iterator<Attribute> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        string = string + attribute.getGroup().getName() + ": <font style='color:red'>" + attribute.getName() + "</font>";
                        if (!iterator.hasNext()) continue;
                        string = string + ",&nbsp;";
                    }
                    string = string + "</html>";
                    return string;
                }
                case 1: {
                    return menuItem.getTranslatedName();
                }
                case 2: {
                    return menuItem.getBarcode();
                }
                case 3: {
                    return menuItem.getPrice();
                }
                case 4: {
                    return menuItem.isVisible();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            MenuItem menuItem = this.b.get(n);
            if (menuItem == null) {
                return;
            }
            if (n2 == 1) {
                menuItem.setTranslatedName(String.valueOf(object));
            } else if (n2 == 2) {
                menuItem.setBarcode(String.valueOf(object));
            } else if (n2 == 3) {
                String string = (String)object;
                if (string.isEmpty()) {
                    return;
                }
                double d = Double.parseDouble(string);
                menuItem.setPrice(d);
            } else if (n2 == 4) {
                Boolean bl = (Boolean)object;
                if (bl == null) {
                    return;
                }
                menuItem.setVisible(bl);
            }
            super.setValueAt(object, n, n2);
        }

        public void deleteItem(MenuItem menuItem, int n) {
            Iterator<MenuItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem2 = iterator.next();
                if (menuItem != menuItem2) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public MenuItem getMenuItem(int n) {
            return this.b.get(n);
        }
    }
}

