/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MultiplierForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class MultiplierExplorer
extends TransparentPanel {
    private List<Multiplier> a = MultiplierDAO.getInstance().findAll();
    private JTable b;
    private MultiplierExplorerTableModel c = new MultiplierExplorerTableModel();
    private JButton d;
    private JButton e;

    public MultiplierExplorer() {
        this.b = new JTable(this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.b.getColumnModel().getColumn(6).setCellRenderer(new PosTableRenderer());
        this.b.setSelectionMode(0);
        this.b.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = MultiplierExplorer.this.b.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                MultiplierExplorer.this.d.setEnabled(multiplier.isMain() == false);
                MultiplierExplorer.this.e.setEnabled(multiplier.isMain() == false);
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.b));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MultiplierForm multiplierForm = new MultiplierForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)multiplierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MultiplierExplorer.this.c.addMultiplier((Multiplier)multiplierForm.getBean());
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d = new JButton(POSConstants.EDIT);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MultiplierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                    if (multiplier.isMain().booleanValue()) {
                        return;
                    }
                    MultiplierForm multiplierForm = new MultiplierForm(multiplier);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)multiplierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MultiplierExplorer.this.b.repaint();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        this.e = new JButton(POSConstants.DELETE);
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MultiplierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                    if (multiplier.isMain().booleanValue()) {
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(MultiplierExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        MultiplierDAO.getInstance().deleteMultiplier(multiplier);
                        MultiplierExplorer.this.c.deleteMultiplier(multiplier, n);
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(Messages.getString("MultiplierExplorer.2"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MultiplierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MultiplierExplorer.3"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                    for (Multiplier multiplier2 : MultiplierExplorer.this.a) {
                        if (multiplier.getId().equals(multiplier2.getId())) {
                            multiplier2.setDefaultMultiplier(true);
                            continue;
                        }
                        multiplier2.setDefaultMultiplier(false);
                    }
                    MultiplierDAO.getInstance().saveOrUpdateMultipliers(MultiplierExplorer.this.a);
                    MultiplierExplorer.this.c.fireTableDataChanged();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(this.d);
        transparentPanel.add(this.e);
        transparentPanel.add(jButton2);
        this.add((Component)transparentPanel, "South");
    }

    class MultiplierExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, Messages.getString("MultiplierExplorer.4"), POSConstants.RATE, POSConstants.SORT_ORDER, POSConstants.BUTTON_COLOR, POSConstants.TEXT_COLOR, Messages.getString("MultiplierExplorer.5")};

        MultiplierExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (MultiplierExplorer.this.a == null) {
                return 0;
            }
            return MultiplierExplorer.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (MultiplierExplorer.this.a == null) {
                return "";
            }
            Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
            switch (n2) {
                case 0: {
                    return multiplier.getId();
                }
                case 1: {
                    return multiplier.getTicketPrefix();
                }
                case 2: {
                    return multiplier.getRate();
                }
                case 3: {
                    return multiplier.getSortOrder();
                }
                case 4: {
                    if (multiplier.getButtonColor() != null) {
                        return new Color(multiplier.getButtonColor());
                    }
                    return null;
                }
                case 5: {
                    if (multiplier.getTextColor() != null) {
                        return new Color(multiplier.getTextColor());
                    }
                    return null;
                }
                case 6: {
                    return multiplier.isDefaultMultiplier();
                }
            }
            return null;
        }

        public void addMultiplier(Multiplier multiplier) {
            int n = MultiplierExplorer.this.a.size();
            MultiplierExplorer.this.a.add(multiplier);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteMultiplier(Multiplier multiplier, int n) {
            MultiplierExplorer.this.a.remove(multiplier);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

