/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class PizzaItemExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<MenuItem> b = new BeanTableModel(MenuItem.class);
    private JComboBox c;
    private JComboBox d;
    private JTextField e;

    public PizzaItemExplorer() {
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME.toUpperCase(), "translatedName");
        this.b.addColumn(POSConstants.VISIBLE.toUpperCase(), "visible");
        this.b.addColumn("TAX GROUP", "taxGroup");
        this.b.addColumn(Messages.getString("MenuItemExplorer.21"), "sortOrder");
        this.b.addColumn(Messages.getString("MenuItemExplorer.23"), "buttonColor");
        this.b.addColumn(Messages.getString("MenuItemExplorer.25"), "textColor");
        this.b.addColumn(POSConstants.IMAGE.toUpperCase(), "image");
        this.a = new JXTable(this.b);
        this.a.getColumn(0).setMinWidth(100);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)this.d(), "South");
        this.add((Component)this.b(), "North");
        this.resizeColumnWidth((JTable)this.a);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PizzaItemExplorer.this.a();
                }
            }
        });
        this.c();
    }

    private void a() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            int n2 = this.a.convertRowIndexToModel(n);
            MenuItem menuItem = this.b.getRow(n2);
            MenuItemDAO.getInstance().initialize(menuItem);
            PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm);
            beanEditorDialog.openWithScale(900, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.setRow(n2, menuItem);
            this.b.fireTableRowsUpdated(n, n);
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.4"));
        this.d = new JComboBox();
        this.d.addItem(Messages.getString("MenuItemExplorer.5"));
        List<OrderType> list = Application.getInstance().getOrderTypes();
        for (OrderType object2 : list) {
            this.d.addItem(object2);
        }
        JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.0"));
        this.e = new JTextField(15);
        try {
            Object object2;
            List<MenuGroup> throwable = MenuGroupDAO.getInstance().findAll();
            this.c = new JComboBox();
            this.c.addItem(Messages.getString("MenuItemExplorer.2"));
            for (Object object2 : throwable) {
                this.c.addItem(object2);
            }
            JButton jButton = new JButton(Messages.getString("MenuItemExplorer.3"));
            jPanel.add((Component)jLabel2, "align label");
            jPanel.add(this.e);
            jPanel.add(jLabel);
            jPanel.add(this.d);
            jPanel.add(jButton);
            object2 = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder((Border)object2, Messages.getString("PizzaItemExplorer.0"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PizzaItemExplorer.this.c();
                }
            });
            this.e.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PizzaItemExplorer.this.c();
                }
            });
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void c() {
        Object object = this.d.getSelectedItem();
        String string = this.e.getText();
        Object object2 = this.c.getSelectedItem();
        List<MenuItem> list = null;
        list = object2 instanceof MenuGroup ? MenuItemDAO.getInstance().getPizzaItems(string, (MenuGroup)object2, object) : MenuItemDAO.getInstance().getPizzaItems(string, null, object);
        this.b.removeAll();
        this.b.addRows(list);
    }

    private TransparentPanel d() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        JButton jButton4 = new JButton(Messages.getString("PizzaItemExplorer.3"));
        JButton jButton5 = new JButton(Messages.getString("MenuItemExplorer.6"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PizzaItemExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.7"));
                        return;
                    }
                    MenuItem menuItem = (MenuItem)PizzaItemExplorer.this.b.getRow(n);
                    String string = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.8"), menuItem.getAvailableUnit());
                    if (string == null || string.equals("")) {
                        return;
                    }
                    double d = Double.parseDouble(string);
                    if (d < 0.0) {
                        POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.10"));
                        return;
                    }
                    menuItem.setAvailableUnit(d);
                    MenuItemDAO.getInstance().saveOrUpdate(menuItem);
                    PizzaItemExplorer.this.a.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.11"));
                    return;
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, exception);
                    return;
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaItemExplorer.this.a();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PizzaItemExplorer.this.f();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PizzaItemExplorer.this.g();
                }
                catch (ConstraintViolationException constraintViolationException) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaItemExplorer.4"));
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PizzaItemExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("Duplicate"));
                        return;
                    }
                    n = PizzaItemExplorer.this.a.convertRowIndexToModel(n);
                    MenuItem menuItem = (MenuItem)PizzaItemExplorer.this.b.getRow(n);
                    MenuItemDAO.getInstance().initialize(menuItem);
                    MenuItem menuItem2 = menuItem.clone();
                    PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem2);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm);
                    beanEditorDialog.openWithScale(900, 700);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuItem menuItem3 = (MenuItem)pizzaItemForm.getBean();
                    PizzaItemExplorer.this.b.addRow(menuItem3);
                    PizzaItemExplorer.this.a.getSelectionModel().addSelectionInterval(PizzaItemExplorer.this.b.getRowCount() - 1, PizzaItemExplorer.this.b.getRowCount() - 1);
                    PizzaItemExplorer.this.a.scrollRowToVisible(PizzaItemExplorer.this.b.getRowCount() - 1);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton5);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.e().get(i));
        }
    }

    private List e() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(50);
        arrayList.add(200);
        arrayList.add(200);
        arrayList.add(70);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(140);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(200);
        return arrayList;
    }

    private void f() throws Exception {
        Serializable serializable;
        Object object;
        MenuItem menuItem = new MenuItem();
        Object object2 = this.c.getSelectedItem();
        if (object2 instanceof MenuGroup) {
            menuItem.setMenuGroup((MenuGroup)object2);
        }
        if ((object = this.d.getSelectedItem()) instanceof OrderType) {
            serializable = new ArrayList<OrderType>();
            serializable.add((OrderType)object);
            menuItem.setOrderTypeList((List)((Object)serializable));
        }
        serializable = new PizzaItemForm(menuItem);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable);
        beanEditorDialog.openWithScale(900, 700);
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        menuItem = (MenuItem)((BeanEditor)serializable).getBean();
        this.b.addRow(menuItem);
    }

    private void g() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
            return;
        }
        MenuItem menuItem = this.b.getRow(n);
        MenuItemDAO menuItemDAO = new MenuItemDAO();
        menuItemDAO.releaseParentAndDelete(menuItem);
        this.b.removeRow(n);
    }
}

