/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class PizzaModifierExplorer
extends TransparentPanel {
    private String a;
    private JXTable b;
    private PizzaModifierExplorerModel c;
    private JTextField d;

    public PizzaModifierExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = CurrencyUtil.getCurrencySymbol();
        this.c = new PizzaModifierExplorerModel();
        this.b = new JXTable((TableModel)this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.b));
        this.b();
        this.add((Component)this.c(), "North");
        this.updateModifierList();
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PizzaModifierExplorer.this.a();
                }
            }
        });
    }

    private void a() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuModifier menuModifier = (MenuModifier)this.c.getRowData(n);
            PizzaModifierForm pizzaModifierForm = new PizzaModifierForm(menuModifier);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaModifierForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        explorerButtonPanel.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PizzaModifierForm pizzaModifierForm = new PizzaModifierForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaModifierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier = (MenuModifier)pizzaModifierForm.getBean();
                    PizzaModifierExplorer.this.c.addModifier(menuModifier);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        explorerButtonPanel.getEditButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierExplorer.this.a();
            }
        });
        explorerButtonPanel.getDeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PizzaModifierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = PizzaModifierExplorer.this.b.convertRowIndexToModel(n);
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        MenuModifier menuModifier = (MenuModifier)PizzaModifierExplorer.this.c.getRowData(n);
                        ModifierDAO modifierDAO = new ModifierDAO();
                        modifierDAO.delete(menuModifier);
                        PizzaModifierExplorer.this.c.deleteModifier(menuModifier, n);
                    }
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton = new JButton(Messages.getString("PizzaModifierExplorer.2"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Comparable comparable2;
                    ArrayList<PizzaModifierPrice> arrayList;
                    int n = PizzaModifierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("Duplicate"));
                        return;
                    }
                    n = PizzaModifierExplorer.this.b.convertRowIndexToModel(n);
                    MenuModifier menuModifier = (MenuModifier)PizzaModifierExplorer.this.c.getRowData(n);
                    MenuModifier menuModifier2 = new MenuModifier();
                    PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
                    menuModifier2.setId(null);
                    String string = PizzaModifierExplorer.this.a(menuModifier);
                    menuModifier2.setName(string);
                    menuModifier2.setPizzaModifier(true);
                    menuModifier2.setMultiplierPriceList(null);
                    List<PizzaModifierPrice> list = menuModifier.getPizzaModifierPriceList();
                    if (list != null) {
                        arrayList = new ArrayList();
                        for (Comparable comparable2 : list) {
                            PizzaModifierPrice pizzaModifierPrice = new PizzaModifierPrice();
                            PropertyUtils.copyProperties((Object)pizzaModifierPrice, (Object)comparable2);
                            pizzaModifierPrice.setId(null);
                            arrayList.add(pizzaModifierPrice);
                            List<ModifierMultiplierPrice> list2 = pizzaModifierPrice.getMultiplierPriceList();
                            if (list2 == null) continue;
                            ArrayList<ModifierMultiplierPrice> arrayList2 = new ArrayList<ModifierMultiplierPrice>();
                            for (ModifierMultiplierPrice modifierMultiplierPrice : list2) {
                                ModifierMultiplierPrice modifierMultiplierPrice2 = new ModifierMultiplierPrice();
                                PropertyUtils.copyProperties((Object)modifierMultiplierPrice2, (Object)modifierMultiplierPrice);
                                modifierMultiplierPrice2.setId(null);
                                modifierMultiplierPrice2.setModifierId(menuModifier2.getId());
                                arrayList2.add(modifierMultiplierPrice2);
                            }
                            pizzaModifierPrice.setMultiplierPriceList(arrayList2);
                        }
                        menuModifier2.setPizzaModifierPriceList(arrayList);
                    }
                    arrayList = new PizzaModifierForm(menuModifier2);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)((Object)arrayList));
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    comparable2 = (MenuModifier)((BeanEditor)((Object)arrayList)).getBean();
                    PizzaModifierExplorer.this.c.addModifier((MenuModifier)comparable2);
                    PizzaModifierExplorer.this.b.getSelectionModel().addSelectionInterval(PizzaModifierExplorer.this.c.getRowCount() - 1, PizzaModifierExplorer.this.c.getRowCount() - 1);
                    PizzaModifierExplorer.this.b.scrollRowToVisible(PizzaModifierExplorer.this.c.getRowCount() - 1);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        explorerButtonPanel.add(jButton);
        this.add((Component)explorerButtonPanel, "South");
    }

    private String a(MenuModifier menuModifier) {
        String string = menuModifier.getName();
        String string2 = new String();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string2 = string + " 1";
        } else {
            String string3 = string.substring(n + 1, string.length());
            if (StringUtils.isNumeric((CharSequence)string3)) {
                Integer n2 = Integer.valueOf(string3);
                n2 = n2 + 1;
                string2 = string.replace(string3, String.valueOf(n2));
                System.out.println(string2);
            } else {
                string2 = string + " 1";
            }
        }
        return string2;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]30[][]30[]", "[]20[]"));
        JLabel jLabel = new JLabel(Messages.getString("ModifierExplorer.3"));
        JLabel jLabel2 = new JLabel(Messages.getString("ModifierExplorer.4"));
        this.d = new JTextField(15);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierExplorer.this.updateModifierList();
            }
        });
        List<MenuItemModifierSpec> list = MenuItemModifierSpecDAO.getInstance().findAll();
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.addItem(Messages.getString("ModifierExplorer.5"));
        for (MenuItemModifierSpec serializable2 : list) {
            jComboBox.addItem(serializable2);
        }
        JButton jButton = new JButton(Messages.getString("ModifierExplorer.6"));
        jPanel.add((Component)jLabel, "align label,split 2");
        jPanel.add(this.d);
        jPanel.add(jButton);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("ModifierExplorer.8"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierExplorer.this.updateModifierList();
            }
        });
        return jPanel;
    }

    public synchronized void updateModifierList() {
        this.setModifierList(ModifierDAO.getInstance().getPizzaModifiers(this.d.getText()));
    }

    public void setModifierList(List<MenuModifier> list) {
        this.c.setRows(list);
    }

    private class PizzaModifierExplorerModel
    extends ListTableModel {
        public PizzaModifierExplorerModel() {
            super(new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, "TAX GROUP", POSConstants.MODIFIER_GROUP, POSConstants.BUTTON_COLOR, POSConstants.SORT_ORDER});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            List list = this.getRows();
            MenuModifier menuModifier = (MenuModifier)list.get(n);
            switch (n2) {
                case 0: {
                    return menuModifier.getName();
                }
                case 1: {
                    return menuModifier.getTranslatedName();
                }
                case 2: {
                    if (menuModifier.getTaxGroup() == null) {
                        return "";
                    }
                    return menuModifier.getTaxGroup();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    if (menuModifier.getButtonColor() != null) {
                        return new Color(menuModifier.getButtonColor());
                    }
                    return null;
                }
                case 5: {
                    return menuModifier.getSortOrder();
                }
            }
            return null;
        }

        public void addModifier(MenuModifier menuModifier) {
            int n = this.getRows().size();
            this.getRows().add(menuModifier);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteModifier(MenuModifier menuModifier, int n) {
            this.getRows().remove(menuModifier);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

