/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.model.PriceShiftEntryDialog;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class PriceShiftExplorer
extends TransparentPanel {
    private JTable a;
    private PriceShiftTableModel b;

    public PriceShiftExplorer() {
        List<PriceShift> list = new PriceShiftDAO().findAll();
        this.b = new PriceShiftTableModel(list);
        this.a = new JTable(this.b);
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PriceShiftExplorer.this.a();
                }
            }
        });
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.a));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PriceShiftEntryDialog priceShiftEntryDialog = new PriceShiftEntryDialog();
                    priceShiftEntryDialog.open();
                    if (priceShiftEntryDialog.isCanceled()) {
                        return;
                    }
                    PriceShift priceShift = priceShiftEntryDialog.getPriceShift();
                    PriceShiftExplorer.this.b.addItem(priceShift);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PriceShiftExplorer.this.a();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PriceShiftExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    PriceShift priceShift = (PriceShift)PriceShiftExplorer.this.b.getRowData(n);
                    if (ConfirmDeleteDialog.showMessage(PriceShiftExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        PriceShiftDAO.getInstance().releaseParentAndDelete(priceShift);
                        PriceShiftExplorer.this.b.deleteItem(n);
                    }
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void a() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            PriceShift priceShift = (PriceShift)this.b.getRowData(n);
            PriceShiftEntryDialog priceShiftEntryDialog = new PriceShiftEntryDialog();
            priceShiftEntryDialog.setPriceShift(priceShift);
            priceShiftEntryDialog.open();
            if (priceShiftEntryDialog.isCanceled()) {
                return;
            }
            this.b.updateItem(n);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class PriceShiftTableModel
    extends ListTableModel {
        PriceShiftTableModel(List list) {
            super(new String[]{POSConstants.NAME, POSConstants.DESCRIPTION, Messages.getString("PriceShiftExplorer.0"), POSConstants.START_TIME, POSConstants.END_TIME, Messages.getString("PriceShiftExplorer.1"), Messages.getString("PriceShiftExplorer.2"), Messages.getString("PriceShiftExplorer.3")}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PriceShift priceShift = (PriceShift)this.rows.get(n);
            if (priceShift == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return priceShift.getName();
                }
                case 1: {
                    return priceShift.getDescription();
                }
                case 2: {
                    return priceShift.getDayOfWeekAsString();
                }
                case 3: {
                    return ShiftUtil.buildShiftTimeRepresentation(priceShift.getStartTime());
                }
                case 4: {
                    return ShiftUtil.buildShiftTimeRepresentation(priceShift.getEndTime());
                }
                case 5: {
                    return priceShift.getPriority();
                }
                case 6: {
                    return priceShift.isAnyDay();
                }
                case 7: {
                    return priceShift.isEnable();
                }
            }
            return null;
        }
    }
}

