/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class TicketExplorer
extends TransparentPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JXTable d;
    private BeanTableModel<Ticket> e;
    private JButton f;
    private JButton g;
    private JButton h;
    private JPanel i;
    private JTextField j;
    private JButton k;
    private JButton l;
    private JLabel m;

    public TicketExplorer() {
        this.a();
        this.e();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.e = new BeanTableModel(Ticket.class);
        this.e.addColumn(POSConstants.ID, Ticket.PROP_ID);
        this.e.addColumn(POSConstants.CUSTOMER.toUpperCase(), "customerName");
        this.e.addColumn(POSConstants.CREATED_BY.toUpperCase(), "ownerName");
        this.e.addColumn(POSConstants.CREATE_TIME.toUpperCase(), Ticket.PROP_CREATE_DATE);
        this.e.addColumn(POSConstants.SETTLE_TIME.toUpperCase(), Ticket.PROP_CLOSING_DATE);
        this.e.addColumn(POSConstants.SUBTOTAL.toUpperCase(), Ticket.PROP_SUBTOTAL_AMOUNT);
        this.e.addColumn(POSConstants.DISCOUNT.toUpperCase(), Ticket.PROP_DISCOUNT_AMOUNT);
        this.e.addColumn(POSConstants.TAX.toUpperCase(), Ticket.PROP_TAX_AMOUNT);
        this.e.addColumn(POSConstants.TOTAL, Ticket.PROP_TOTAL_AMOUNT);
        this.e.addColumn(POSConstants.PAID, Ticket.PROP_PAID);
        this.e.addColumn(POSConstants.VOID.toUpperCase(), Ticket.PROP_VOID_AMOUNT);
        this.d = new JXTable(this.e);
        this.d.setAutoResizeMode(4);
        this.d.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.d.setRowHeight(PosUIManager.getSize(30));
        int n = PosUIManager.getSize(16);
        this.m = new JLabel();
        this.k = new JButton();
        this.k.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.l = new JButton();
        this.l.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.a(TicketExplorer.this.e.getPreviousRowIndex());
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.a(TicketExplorer.this.e.getNextRowIndex());
            }
        });
        this.i = this.b();
        this.add((Component)this.i, "North");
        this.add((Component)new JScrollPane((Component)this.d), "Center");
        this.d();
    }

    private JPanel b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("MenuItemExplorer.30"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel();
        try {
            jPanel2.setLayout((LayoutManager)new MigLayout());
            JLabel jLabel = new JLabel(Messages.getString("TicketExplorer.0"));
            this.j = new JTextField(15);
            jPanel2.add(jLabel);
            jPanel2.add(this.j);
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (TicketExplorer.this.j.getText().length() > 3) {
                        TicketExplorer.this.e();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        TicketExplorer.this.e();
                    }
                }
            };
            this.j.addKeyListener(keyListener);
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.c(), "Center");
        return jPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TicketExplorer.this.e();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        jPanel.add((Component)this.a, "gapright 10");
        jPanel.add((Component)new JLabel(POSConstants.TO), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "width 60!");
        return jPanel;
    }

    private void d() {
        this.h = new JButton(Messages.getString("TicketExplorer.1"));
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.h();
            }
        });
        this.f = new JButton(POSConstants.DELETE);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.g();
            }
        });
        this.g = new JButton(POSConstants.DELETE_ALL);
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.f();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(this.h);
        transparentPanel.add(this.f);
        transparentPanel.add(this.g);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.m);
        jPanel2.add(this.k);
        jPanel2.add(this.l);
        jPanel.add((Component)transparentPanel, "Center");
        jPanel.add((Component)jPanel2, "East");
        this.add((Component)jPanel, "South");
    }

    private void e() {
        this.a(0);
    }

    private void a(int n) {
        this.e.setCurrentRowIndex(n);
        Date date = this.a.getDate();
        Date date2 = this.b.getDate();
        if (date != null && date2 != null && date.after(date2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        if (date != null) {
            date = DateUtil.startOfDay(date);
        }
        if (date2 != null) {
            date2 = DateUtil.endOfDay(date2);
        }
        date = DateUtil.startOfDay(date);
        date2 = DateUtil.endOfDay(date2);
        String string = this.j.getText();
        TicketDAO.getInstance().loadClosedTicket(this.e, string, date, date2);
        int n2 = this.e.getCurrentRowIndex() + 1;
        int n3 = this.e.getNextRowIndex();
        int n4 = this.e.getNumRows();
        if (n3 > n4) {
            n3 = n4;
        }
        this.m.setText(String.format(Messages.getString("TicketExplorer.2"), n2, n3, n4));
        this.k.setEnabled(this.e.hasPrevious());
        this.l.setEnabled(this.e.hasNext());
    }

    private void f() {
        try {
            List<Ticket> list = this.e.getRows();
            if (list.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE_ALL) != 0) {
                return;
            }
            TicketDAO.getInstance().deleteTickets(list);
            this.e.removeAll();
            this.d.revalidate();
            this.d.repaint();
            this.e();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() {
        try {
            int n = this.d.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.SELECT_ONE_TICKET_TO_VOID);
                return;
            }
            n = this.d.convertRowIndexToModel(n);
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            Ticket ticket = this.e.getRows().get(n);
            arrayList.add(ticket);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            TicketDAO.getInstance().deleteTickets(arrayList);
            this.e.removeRow(n);
            this.d.revalidate();
            this.d.repaint();
            this.e();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void h() {
        try {
            int n = this.d.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.SELECT_ONE_TICKET_TO_VOID);
                return;
            }
            n = this.d.convertRowIndexToModel(n);
            Ticket ticket = this.e.getRows().get(n);
            Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            arrayList.add(ticket2);
            try {
                OrderInfoView orderInfoView = new OrderInfoView(arrayList);
                OrderInfoDialog orderInfoDialog = new OrderInfoDialog(orderInfoView);
                orderInfoDialog.setSize(600, 700);
                orderInfoDialog.setDefaultCloseOperation(2);
                orderInfoDialog.open();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

