/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DatabaseConfigurationView
extends ConfigurationView
implements ActionListener {
    private static final String a = "CD";
    private static final String b = "SAVE";
    private static final String c = "cancel";
    private static final String d = "test";
    private POSTextField e;
    private POSTextField f;
    private POSTextField g;
    private POSTextField h;
    private POSPasswordField i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JComboBox m;
    private JLabel n;
    private JLabel o;
    private JLabel p;
    private JLabel q;
    private JLabel r;

    public DatabaseConfigurationView() throws HeadlessException {
        this.initUI();
        this.a();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fill", "[][grow,fill]", "[][][][][][][][grow,fill]"));
        this.e = new POSTextField();
        this.f = new POSTextField();
        this.g = new POSTextField();
        this.h = new POSTextField();
        this.i = new POSPasswordField();
        this.m = new JComboBox<Database>(Database.values());
        String string = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)string)) {
            this.m.setSelectedItem((Object)Database.getByProviderName(string));
        }
        jPanel.add(new JLabel(Messages.getString("DatabaseConfigurationDialog.8")));
        jPanel.add((Component)this.m, "grow, wrap");
        this.n = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        jPanel.add(this.n);
        jPanel.add((Component)this.e, "grow, wrap");
        this.o = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        jPanel.add(this.o);
        jPanel.add((Component)this.f, "grow, wrap");
        this.p = new JLabel(Messages.getString("DatabaseConfigurationDialog.16") + ":");
        jPanel.add(this.p);
        jPanel.add((Component)this.g, "grow, wrap");
        this.q = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        jPanel.add(this.q);
        jPanel.add((Component)this.h, "grow, wrap");
        this.r = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        jPanel.add(this.r);
        jPanel.add((Component)this.i, "grow, wrap");
        jPanel.add((Component)new JSeparator(), "span, grow, gaptop 10");
        this.j = new JButton(Messages.getString("DatabaseConfigurationDialog.26"));
        this.j.setActionCommand(d);
        this.l = new JButton(Messages.getString("DatabaseConfigurationDialog.27"));
        this.l.setActionCommand(b);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.k = new JButton(Messages.getString("DatabaseConfigurationDialog.29"));
        this.k.setActionCommand(a);
        jPanel2.add(this.k);
        jPanel2.add(this.j);
        jPanel2.add(this.l);
        jPanel.add((Component)jPanel2, "span, grow");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void a() {
        this.j.addActionListener(this);
        this.k.addActionListener(this);
        this.l.addActionListener(this);
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Database database = (Database)((Object)DatabaseConfigurationView.this.m.getSelectedItem());
                if (database == Database.DERBY_SINGLE) {
                    DatabaseConfigurationView.this.a(false);
                    return;
                }
                DatabaseConfigurationView.this.a(true);
                String string = AppConfig.getDatabasePort();
                if (StringUtils.isEmpty((String)string)) {
                    string = database.getDefaultPort();
                }
                DatabaseConfigurationView.this.f.setText(string);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            Database database = (Database)((Object)this.m.getSelectedItem());
            String string2 = database.getProviderName();
            String string3 = this.e.getText();
            String string4 = this.f.getText();
            String string5 = this.g.getText();
            String string6 = this.h.getText();
            String string7 = new String(this.i.getPassword());
            String string8 = database.getConnectString(string3, string4, string5);
            String string9 = database.getHibernateDialect();
            String string10 = database.getHibernateConnectionDriverClass();
            if (d.equalsIgnoreCase(string)) {
                Application.getInstance().setSystemInitialized(false);
                this.a(database, string2, string3, string4, string5, string6, string7, string8, string9);
                try {
                    DatabaseUtil.checkConnection(string8, string9, string10, string6, string7);
                }
                catch (DatabaseConnectionException databaseConnectionException) {
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                    return;
                }
                JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                return;
            }
            if (a.equals(string)) {
                Application.getInstance().setSystemInitialized(false);
                int n = JOptionPane.showConfirmDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.33"), Messages.getString("DatabaseConfigurationDialog.34"), 0);
                if (n != 0) {
                    return;
                }
                n = JOptionPane.showConfirmDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationView.3"), Messages.getString("DatabaseConfigurationView.4"), 0);
                boolean bl = false;
                if (n == 0) {
                    bl = true;
                }
                this.a(database, string2, string3, string4, string5, string6, string7, string8, string9);
                String string11 = database.getCreateDbConnectString(string3, string4, string5);
                this.setCursor(Cursor.getPredefinedCursor(3));
                boolean bl2 = DatabaseUtil.createDatabase(string11, string9, string10, string6, string7, bl);
                this.setCursor(Cursor.getDefaultCursor());
                if (bl2) {
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), "Database created. Default password is 1111.\n\nThe system will now restart.");
                    Main.restart();
                    return;
                } else {
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.36"));
                }
                return;
            }
            if (b.equalsIgnoreCase(string)) {
                Application.getInstance().setSystemInitialized(false);
                this.a(database, string2, string3, string4, string5, string6, string7, string8, string9);
                return;
            }
            if (!c.equalsIgnoreCase(string)) return;
        }
        catch (Exception exception) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void a(Database database, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        AppConfig.setDatabaseProviderName(string);
        AppConfig.setConnectString(string7);
        AppConfig.setDatabaseHost(string2);
        AppConfig.setDatabasePort(string3);
        AppConfig.setDatabaseName(string4);
        AppConfig.setDatabaseUser(string5);
        AppConfig.setDatabasePassword(string6);
    }

    private void a(boolean bl) {
        this.n.setVisible(bl);
        this.e.setVisible(bl);
        this.o.setVisible(bl);
        this.f.setVisible(bl);
        this.p.setVisible(bl);
        this.g.setVisible(bl);
        this.q.setVisible(bl);
        this.h.setVisible(bl);
        this.r.setVisible(bl);
        this.i.setVisible(bl);
    }

    @Override
    public boolean save() throws Exception {
        return true;
    }

    @Override
    public void initialize() throws Exception {
        Database database = (Database)((Object)this.m.getSelectedItem());
        String string = AppConfig.getDatabaseHost();
        this.e.setText(string);
        String string2 = AppConfig.getDatabasePort();
        if (StringUtils.isEmpty((String)string2)) {
            string2 = database.getDefaultPort();
        }
        this.f.setText(string2);
        this.g.setText(AppConfig.getDatabaseName());
        this.h.setText(AppConfig.getDatabaseUser());
        this.i.setText(AppConfig.getDatabasePassword());
        if (database == Database.DERBY_SINGLE) {
            this.a(false);
        } else {
            this.a(true);
        }
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return Messages.getString("DatabaseConfigurationView.5");
    }
}

